/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.kernels;

import explorer.compute.tools.GViewTool;
import explorer.compute.tools.generic.BiLevelParentTool;
import explorer.compute.tools.kernels.DummyKernelTool;
import explorer.compute.tools.kernels.IsomapKernelTool;
import explorer.compute.tools.kernels.LinearKernelTool;
import explorer.compute.tools.kernels.LleKernelTool;
import explorer.compute.tools.kernels.PolynomialKernelTool;
import explorer.compute.tools.kernels.RbfKernelTool;
import explorer.compute.tools.kernels.SigmoidKernelTool;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import explorer.windows.w2D.icview.generic.BiLevelParentView;
import explorer.windows.w2D.icview.kernels.DummyKernelView;
import explorer.windows.w2D.icview.kernels.IsomapKernelView;
import explorer.windows.w2D.icview.kernels.KernelView;
import explorer.windows.w2D.icview.kernels.OneParameterKernelView;
import explorer.windows.w2D.icview.kernels.TwoParametersKernelView;
import explorer.windows.w2D.utils.GView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class KernelParentTool
extends GViewTool
implements BiLevelParentTool {
    protected static final int ATTRVAL = 0;
    protected static final int DIST = 1;
    protected static final int COORD = 2;
    protected static final int UNMANAGED = 3;
    private BiLevelParentView view;
    private List<List<String>> kernnames = null;
    private Map<String, KernelView> subviews = null;
    private KernelView currentsubview = null;

    public KernelParentTool() {
        this.initNames();
    }

    @Override
    public void setBLPView(BiLevelParentView v) {
        this.view = v;
        this.initTools();
    }

    private void initNames() {
        this.kernnames = new ArrayList<List<String>>();
        ArrayList<String> lav = new ArrayList<String>();
        lav.add(Messages.getString("tpgkernels_choice"));
        lav.add(Messages.getString("tpgkernels_Lineaire"));
        lav.add(Messages.getString("tpgkernels_Polynomial"));
        lav.add(Messages.getString("tpgkernels_RBF"));
        lav.add(Messages.getString("tpgkernels_Sigmoid"));
        lav.add(Messages.getString("tpgkernels_ISOMAP"));
        lav.add(Messages.getString("tpgkernels_LLE"));
        this.kernnames.add(0, lav);
        ArrayList<String> ld = new ArrayList<String>();
        ld.add(Messages.getString("tpgkernels_choice"));
        ld.add(Messages.getString("tpgkernels_ISOMAP"));
        ld.add(Messages.getString("tpgkernels_LLE"));
        this.kernnames.add(1, ld);
        this.kernnames.add(2, new ArrayList());
        this.kernnames.add(3, new ArrayList());
    }

    private void initTools() {
        this.subviews = new HashMap<String, KernelView>();
        DummyKernelView nokernelView = new DummyKernelView(Messages.getString("tpgkernels_choice"), new DummyKernelTool());
        this.view.add(nokernelView);
        this.subviews.put(Messages.getString("tpgkernels_choice"), nokernelView);
        this.currentsubview = nokernelView;
        DummyKernelView linearView = new DummyKernelView(Messages.getString("tpgkernels_Lineaire"), new LinearKernelTool());
        this.view.add(linearView);
        this.subviews.put(Messages.getString("tpgkernels_Lineaire"), linearView);
        OneParameterKernelView polyView = new OneParameterKernelView(Messages.getString("tpgkernels_Polynomial"), new PolynomialKernelTool());
        this.view.add(polyView);
        this.subviews.put(Messages.getString("tpgkernels_Polynomial"), polyView);
        OneParameterKernelView rbfView = new OneParameterKernelView(Messages.getString("tpgkernels_RBF"), new RbfKernelTool());
        this.view.add(rbfView);
        this.subviews.put(Messages.getString("tpgkernels_RBF"), rbfView);
        TwoParametersKernelView sigView = new TwoParametersKernelView(Messages.getString("tpgkernels_Sigmoid"), new SigmoidKernelTool());
        this.view.add(sigView);
        this.subviews.put(Messages.getString("tpgkernels_Sigmoid"), sigView);
        IsomapKernelView isoView = new IsomapKernelView(Messages.getString("tpgkernels_ISOMAP"), new IsomapKernelTool());
        this.view.add(isoView);
        this.subviews.put(Messages.getString("tpgkernels_ISOMAP"), isoView);
        OneParameterKernelView lleView = new OneParameterKernelView(Messages.getString("tpgkernels_LLE"), new LleKernelTool());
        this.view.add(lleView);
        this.subviews.put(Messages.getString("tpgkernels_LLE"), lleView);
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (this.f3d != null) {
            this.view.setMethodList(this.getGraphs());
        }
    }

    @Override
    public void toolChanged() {
        String ms = this.view.getMethod();
        if (this.currentsubview != null) {
            this.currentsubview.activate(false);
        }
        if (ms != null) {
            this.currentsubview = this.subviews.get(ms);
            this.currentsubview.activate(true);
        } else {
            this.currentsubview = null;
        }
    }

    private List<String> getGraphs() {
        Source src = this.f3d.getProjection().getProjectiveMethod().getSource();
        if (src instanceof SourceAttrVal) {
            return this.kernnames.get(0);
        }
        if (src instanceof SourceDist) {
            return this.kernnames.get(1);
        }
        if (src instanceof Source3DCoord) {
            return this.kernnames.get(2);
        }
        return this.kernnames.get(3);
    }
}

