/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.kernels;

import explorer.compute.kernels.Kernel;
import explorer.compute.kernels.LLE;
import explorer.compute.tools.GViewTool;
import explorer.compute.tools.kernels.KernelTool;
import explorer.data.Common;
import explorer.windows.w2D.icview.kernels.KernelView;
import explorer.windows.w2D.icview.kernels.OneParameterKernelView;
import explorer.windows.w2D.utils.GView;
import lib3d4j.international.Messages;

public class LleKernelTool
extends GViewTool
implements KernelTool {
    OneParameterKernelView view;

    @Override
    public void setView(KernelView v) {
        this.view = (OneParameterKernelView)v;
        this.view.setParamName(Messages.getString("tpgkernels_paramVoisin"));
        this.view.setParam(2);
        this.setMaxNbg();
    }

    @Override
    public void execute() {
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        this.setMaxNbg();
    }

    @Override
    public void activate(boolean b) {
        if (b) {
            Common.getSingleton().setKernel(new LLE(this.view.getParam()));
        }
    }

    private void setMaxNbg() {
        if (this.f3d != null) {
            this.view.setParamBounds(1, this.f3d.getProjection().getProjectiveMethod().getNbObjets() - 1);
        }
    }

    @Override
    public void paramChanged() {
        Kernel k = Common.getSingleton().getKernel();
        if (k instanceof LLE) {
            ((LLE)k).setNbVoisin(this.view.getParam());
        }
    }
}

