/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.projectivemethods;

import explorer.compute.compute.projection.PMDualPCA;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.tools.OutilsACP;
import explorer.compute.tools.projectivemethods.ProjectiveMethodTool;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import explorer.windows.w2D.icview.projectivemethods.PCAPMView;
import explorer.windows.w2D.icview.projectivemethods.ProjectiveMethodView;

public class PCAPMTool
implements ProjectiveMethodTool {
    private boolean dualauto;
    private boolean dualforce;
    private OutilsACP parentTool;
    private PCAPMView view;

    public PCAPMTool(OutilsACP pt) {
        this.parentTool = pt;
        this.dualauto = true;
        this.dualforce = false;
    }

    @Override
    public void setView(ProjectiveMethodView v) {
        this.view = (PCAPMView)v;
        this.view.setDualAuto(this.dualauto);
        this.view.setDualForce(this.dualforce);
    }

    @Override
    public ProjectiveMethod execute() {
        SourceAttrVal src = this.parentTool.getCurrentSource();
        Conditioning c = this.parentTool.getCurrentConditionning();
        int nbattr = src.getNbAttACP();
        int nbobj = src.getNbObjects();
        if (Common.getSingleton().getKernel() != null) {
            PMDualPCA res = PMFactory.getSingleton().createPMDualPCA(src, c);
            res.setKernel(Common.getSingleton().getKernel());
            return res;
        }
        if (this.dualforce || this.dualauto && nbattr > nbobj) {
            return PMFactory.getSingleton().createPMDualPCA(src, c);
        }
        return PMFactory.getSingleton().createPMPCA(src, c);
    }

    @Override
    public void fire() {
        this.parentTool.compute();
    }

    public void stateChanged() {
        this.dualauto = this.view.isDualAuto();
        this.dualforce = this.view.isDualForce();
    }
}

