/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.voronoi;

public class Pnt {
    private double[] coordinates;

    public Pnt(double[] coords) {
        this.coordinates = new double[coords.length];
        System.arraycopy(coords, 0, this.coordinates, 0, coords.length);
    }

    public Pnt(double coordA, double coordB) {
        this(new double[]{coordA, coordB});
    }

    public Pnt(double coordA, double coordB, double coordC) {
        this(new double[]{coordA, coordB, coordC});
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "()";
        }
        String result = "Pnt(" + this.coordinates[0];
        int i = 1;
        while (i < this.coordinates.length) {
            result = String.valueOf(result) + "," + this.coordinates[i];
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pnt)) {
            return false;
        }
        Pnt p = (Pnt)other;
        if (this.coordinates.length != p.coordinates.length) {
            return false;
        }
        int i = 0;
        while (i < this.coordinates.length) {
            if (this.coordinates[i] != p.coordinates[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.coordinates.length) {
            long bits = Double.doubleToLongBits(this.coordinates[i]);
            hash = 31 * hash ^ (int)(bits ^ bits >> 32);
            ++i;
        }
        return hash;
    }

    public double coord(int i) {
        return this.coordinates[i];
    }

    public int dimension() {
        return this.coordinates.length;
    }

    public int dimCheck(Pnt p) {
        int len = this.coordinates.length;
        if (len != p.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return len;
    }

    public Pnt extend(double[] coords) {
        double[] result = new double[this.coordinates.length + coords.length];
        System.arraycopy(this.coordinates, 0, result, 0, this.coordinates.length);
        System.arraycopy(coords, 0, result, this.coordinates.length, coords.length);
        return new Pnt(result);
    }

    public double dot(Pnt p) {
        int len = this.dimCheck(p);
        double sum = 0.0;
        int i = 0;
        while (i < len) {
            sum += this.coordinates[i] * p.coordinates[i];
            ++i;
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public Pnt subtract(Pnt p) {
        int len = this.dimCheck(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] - p.coordinates[i];
            ++i;
        }
        return new Pnt(coords);
    }

    public Pnt add(Pnt p) {
        int len = this.dimCheck(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] + p.coordinates[i];
            ++i;
        }
        return new Pnt(coords);
    }

    public double angle(Pnt p) {
        return Math.acos(this.dot(p) / (this.magnitude() * p.magnitude()));
    }

    public Pnt bisector(Pnt point) {
        int dim = this.dimCheck(point);
        Pnt diff = this.subtract(point);
        Pnt sum = this.add(point);
        double dot = diff.dot(sum);
        return diff.extend(new double[]{-dot / 2.0});
    }

    public static String toString(Pnt[] matrix) {
        StringBuffer buf = new StringBuffer("{");
        int i = 0;
        while (i < matrix.length) {
            buf.append(" " + matrix[i]);
            ++i;
        }
        buf.append(" }");
        return buf.toString();
    }

    public static double determinant(Pnt[] matrix) {
        if (matrix.length != matrix[0].dimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] columns = new boolean[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            columns[i] = true;
            ++i;
        }
        try {
            return Pnt.determinant(matrix, 0, columns);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(Pnt[] matrix, int row, boolean[] columns) {
        if (row == matrix.length) {
            return 1.0;
        }
        double sum = 0.0;
        int sign = 1;
        int col = 0;
        while (col < columns.length) {
            if (columns[col]) {
                columns[col] = false;
                sum += (double)sign * matrix[row].coordinates[col] * Pnt.determinant(matrix, row + 1, columns);
                columns[col] = true;
                sign = -sign;
            }
            ++col;
        }
        return sum;
    }

    public static Pnt cross(Pnt[] matrix) {
        int len = matrix.length + 1;
        if (len != matrix[0].dimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] columns = new boolean[len];
        int i = 0;
        while (i < len) {
            columns[i] = true;
            ++i;
        }
        double[] result = new double[len];
        int sign = 1;
        try {
            int i2 = 0;
            while (i2 < len) {
                columns[i2] = false;
                result[i2] = (double)sign * Pnt.determinant(matrix, 0, columns);
                columns[i2] = true;
                sign = -sign;
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new Pnt(result);
    }

    public static double content(Pnt[] simplex) {
        Pnt[] matrix = new Pnt[simplex.length];
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = simplex[i].extend(new double[]{1.0});
            ++i;
        }
        int fact = 1;
        int i2 = 1;
        while (i2 < matrix.length) {
            fact *= i2;
            ++i2;
        }
        return Pnt.determinant(matrix) / (double)fact;
    }

    public int[] relation(Pnt[] simplex) {
        int dim = simplex.length - 1;
        if (this.dimension() != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] matrix = new Pnt[dim + 1];
        double[] coords = new double[dim + 2];
        int j = 0;
        while (j < coords.length) {
            coords[j] = 1.0;
            ++j;
        }
        matrix[0] = new Pnt(coords);
        int i = 0;
        while (i < dim) {
            coords[0] = this.coordinates[i];
            int j2 = 0;
            while (j2 < simplex.length) {
                coords[j2 + 1] = simplex[j2].coordinates[i];
                ++j2;
            }
            matrix[i + 1] = new Pnt(coords);
            ++i;
        }
        Pnt vector = Pnt.cross(matrix);
        double content = vector.coordinates[0];
        int[] result = new int[dim + 1];
        int i2 = 0;
        while (i2 < result.length) {
            double value = vector.coordinates[i2 + 1];
            result[i2] = Math.abs(value) <= 1.0E-6 * Math.abs(content) ? 0 : (value < 0.0 ? -1 : 1);
            ++i2;
        }
        if (content < 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = -result[i2];
                ++i2;
            }
        }
        if (content == 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = Math.abs(result[i2]);
                ++i2;
            }
        }
        return result;
    }

    public Pnt isOutside(Pnt[] simplex) {
        int[] result = this.relation(simplex);
        int i = 0;
        while (i < result.length) {
            if (result[i] > 0) {
                return simplex[i];
            }
            ++i;
        }
        return null;
    }

    public Pnt isOn(Pnt[] simplex) {
        int[] result = this.relation(simplex);
        Pnt witness = null;
        int i = 0;
        while (i < result.length) {
            if (result[i] == 0) {
                witness = simplex[i];
            } else if (result[i] > 0) {
                return null;
            }
            ++i;
        }
        return witness;
    }

    public boolean isInside(Pnt[] simplex) {
        int[] result = this.relation(simplex);
        int i = 0;
        while (i < result.length) {
            if (result[i] >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int vsCircumcircle(Pnt[] simplex) {
        int result;
        Pnt[] matrix = new Pnt[simplex.length + 1];
        int i = 0;
        while (i < simplex.length) {
            matrix[i] = simplex[i].extend(new double[]{1.0, simplex[i].dot(simplex[i])});
            ++i;
        }
        matrix[simplex.length] = this.extend(new double[]{1.0, this.dot(this)});
        double d = Pnt.determinant(matrix);
        int n = d < 0.0 ? -1 : (result = d > 0.0 ? 1 : 0);
        if (Pnt.content(simplex) < 0.0) {
            result = -result;
        }
        return result;
    }

    public static Pnt circumcenter(Pnt[] simplex) {
        int dim = simplex[0].dimension();
        if (simplex.length - 1 != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] matrix = new Pnt[dim];
        int i = 0;
        while (i < dim) {
            matrix[i] = simplex[i].bisector(simplex[i + 1]);
            ++i;
        }
        Pnt hCenter = Pnt.cross(matrix);
        double last = hCenter.coordinates[dim];
        double[] result = new double[dim];
        int i2 = 0;
        while (i2 < dim) {
            result[i2] = hCenter.coordinates[i2] / last;
            ++i2;
        }
        return new Pnt(result);
    }
}

