/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.voronoi;

import explorer.compute.voronoi.DelaunayTriangulation;
import explorer.compute.voronoi.Pnt;
import explorer.compute.voronoi.Simplex;
import explorer.windows.w2D.utils.VoronoiPanel;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Voronoi {
    public static final int VORONOI_PROXY = 0;
    public static final int VORONOI_DIST = 1;

    public void getVoronoiToWindowFromxD(int pt, javafx.geometry.Point2D[] p2d, float[][] pxd, int dim, int width, int height) throws IllegalArgumentException {
        if (p2d.length != pxd.length) {
            throw new IllegalArgumentException("Les tableaux de points 2D et " + dim + "D ne contiennent pas le meme nombre d'arguments");
        }
        List<Cell> cells = this.makeVoronoiCellsProxy(p2d);
        this.drawVoronoiCells(cells, pt, p2d, null, pxd, width, height);
    }

    public void getVoronoiToWindowFromxD(int pt, javafx.geometry.Point2D[] p2d, float[][] p3d, float[][] pxd, int dim, int width, int height) throws IllegalArgumentException {
        if (p2d.length != pxd.length) {
            throw new IllegalArgumentException("Les tableaux de points 2D et " + dim + "D ne contiennent pas le meme nombre d'arguments");
        }
        List<Cell> cells = this.makeVoronoiCellsProxy(p2d);
        this.drawVoronoiCells(cells, pt, null, p3d, pxd, width, height);
    }

    public void getVoronoiDistortionToWindowFromxD(javafx.geometry.Point2D[] p2d, float[][] pxd, int dim, int width, int height) throws IllegalArgumentException {
        if (p2d.length != pxd.length) {
            throw new IllegalArgumentException("Les tableaux de points 2D et " + dim + "D ne contiennent pas le meme nombre d'arguments");
        }
        List<CellDist> cells = this.makeVoronoiCellsDist(p2d);
        this.drawVoronoiDistCells(cells, p2d, pxd, width, height);
    }

    public void getVoronoiDistortionToWindowFromxD(javafx.geometry.Point2D[] p2d, float[][] p3d, float[][] pxd, int dim, int width, int height) throws IllegalArgumentException {
        if (p2d.length != pxd.length) {
            throw new IllegalArgumentException("Les tableaux de points 2D et " + dim + "D ne contiennent pas le meme nombre d'arguments");
        }
        List<CellDist> cells = this.makeVoronoiCellsDist(p2d);
        this.drawVoronoiDistCells(cells, p2d, p3d, pxd, width, height);
    }

    private Cell[] prepareCells(javafx.geometry.Point2D[] p2d, DelaunayTriangulation dt) {
        Cell[] c = new Cell[p2d.length];
        int i = 0;
        while (i < p2d.length) {
            Pnt p = new Pnt(p2d[i].getX(), p2d[i].getY());
            dt.delaunayPlace(p);
            c[i] = new Cell(p);
            ++i;
        }
        return c;
    }

    private DelaunayTriangulation prepareDelaunay() {
        Simplex initialTriangle = new Simplex(new Pnt[]{new Pnt(-10000.0, -10000.0), new Pnt(10000.0, -10000.0), new Pnt(0.0, 10000.0)});
        return new DelaunayTriangulation(initialTriangle);
    }

    private List<Cell> makeVoronoiCellsProxy(javafx.geometry.Point2D[] p2d) {
        DelaunayTriangulation dt = this.prepareDelaunay();
        Cell[] c = this.prepareCells(p2d, dt);
        LinkedList<Cell> res = new LinkedList<Cell>();
        Cell[] cellArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            res.add(new Cell(cell.getPoint()));
            ++n2;
        }
        Iterator<Simplex> it = dt.iterator();
        while (it.hasNext()) {
            Simplex triangle = it.next();
            LinkedList l = new LinkedList();
            Pnt p = Pnt.circumcenter(triangle.toArray(new Pnt[0]));
            Iterator otherIt = triangle.iterator();
            while (otherIt.hasNext()) {
                l.add(otherIt.next());
            }
            otherIt = dt.neighbors(triangle).iterator();
            block3: while (otherIt.hasNext()) {
                Nearest nearest = this.computeNearest((Simplex)otherIt.next(), l.iterator());
                Pnt p1 = nearest.p1;
                Pnt p2 = nearest.p2;
                Pnt q = nearest.q;
                int i = 0;
                while (i < c.length) {
                    if (p1 != null && c[i].getPoint().coord(0) == p1.coord(0) && c[i].getPoint().coord(1) == p1.coord(1)) {
                        ((Cell)res.get(i)).addPoint(new Line2D.Double(p.coord(0), p.coord(1), q.coord(0), q.coord(1)));
                        p1 = null;
                    }
                    if (p2 != null && c[i].getPoint().coord(0) == p2.coord(0) && c[i].getPoint().coord(1) == p2.coord(1)) {
                        ((Cell)res.get(i)).addPoint(new Line2D.Double(p.coord(0), p.coord(1), q.coord(0), q.coord(1)));
                        p2 = null;
                    }
                    if (p1 == null && p2 == null) continue block3;
                    ++i;
                }
            }
        }
        for (Cell cel : res) {
            cel.setPolygon();
        }
        return res;
    }

    private List<CellDist> makeVoronoiCellsDist(javafx.geometry.Point2D[] p2d) {
        DelaunayTriangulation dt = this.prepareDelaunay();
        Cell[] c = this.prepareCells(p2d, dt);
        LinkedList<CellDist> res = new LinkedList<CellDist>();
        Iterator<Simplex> it = dt.iterator();
        block0: while (it.hasNext()) {
            Simplex triangle = it.next();
            LinkedList l = new LinkedList();
            Pnt p = Pnt.circumcenter(triangle.toArray(new Pnt[0]));
            Iterator otherIt = triangle.iterator();
            while (otherIt.hasNext()) {
                l.add(otherIt.next());
            }
            otherIt = dt.neighbors(triangle).iterator();
            while (otherIt.hasNext()) {
                Nearest nearest = this.computeNearest((Simplex)otherIt.next(), l.iterator());
                Pnt p1 = nearest.p1;
                Pnt p2 = nearest.p2;
                Pnt q = nearest.q;
                System.out.println("nearest " + p1 + " " + p2 + " " + q);
                Iterator it2 = res.iterator();
                Line2D.Double l2d = new Line2D.Double(p.coord(0), p.coord(1), q.coord(0), q.coord(1));
                javafx.geometry.Point2D m = new javafx.geometry.Point2D((double)((float)(p1.coord(0) + p2.coord(0)) / 2.0f), (double)((float)(p1.coord(1) + p2.coord(1)) / 2.0f));
                if (!l2d.intersectsLine(new Line2D.Double(p1.coord(0), p1.coord(1), p2.coord(0), p2.coord(1)))) {
                    m = new javafx.geometry.Point2D((double)((float)(p.coord(0) + q.coord(0)) / 2.0f), (double)((float)(p.coord(1) + q.coord(1)) / 2.0f));
                }
                boolean b1 = false;
                boolean b2 = false;
                int i = 0;
                while (!(i >= c.length || b1 && b2)) {
                    b1 |= c[i].getPoint().equals(p1);
                    b2 |= c[i].getPoint().equals(p2);
                    ++i;
                }
                if (!b1 || !b2) continue;
                boolean b = false;
                while (it2.hasNext() && !b) {
                    if (!((CellDist)it2.next()).getPoint().equals((Object)m)) continue;
                    b = true;
                }
                if (!b) {
                    int pos1 = -1;
                    int pos2 = -1;
                    int i2 = 0;
                    while (i2 < c.length) {
                        if (c[i2].getPoint().equals(p1) || c[i2].getPoint().equals(p2)) {
                            if (pos1 != -1) {
                                pos2 = i2;
                            } else {
                                pos1 = i2;
                            }
                        }
                        if (pos1 != -1 && pos2 != -1) break;
                        ++i2;
                    }
                    Polygon pol = new Polygon();
                    pol.addPoint((int)p1.coord(0), (int)p1.coord(1));
                    pol.addPoint((int)p.coord(0), (int)p.coord(1));
                    pol.addPoint((int)p2.coord(0), (int)p2.coord(1));
                    pol.addPoint((int)q.coord(0), (int)q.coord(1));
                    res.add(new CellDist(m, pos1, pos2, pol));
                }
                if (p1 == null && p2 == null) continue block0;
            }
        }
        return res;
    }

    private Nearest computeNearest(Simplex other, Iterator<Pnt> lPoints) {
        Pnt q = Pnt.circumcenter(other.toArray(new Pnt[0]));
        double min1 = -1.0;
        double min2 = -1.0;
        Pnt p1 = null;
        Pnt p2 = null;
        p1 = lPoints.next();
        min1 = Math.sqrt(Math.pow(q.coord(0) - p1.coord(0), 2.0) + Math.pow(q.coord(1) - p1.coord(1), 2.0));
        if (lPoints.hasNext()) {
            p2 = lPoints.next();
            min2 = Math.sqrt(Math.pow(q.coord(0) - p2.coord(0), 2.0) + Math.pow(q.coord(1) - p2.coord(1), 2.0));
            if (min2 < min1) {
                double mint = min2;
                Pnt pt = p2;
                min2 = min1;
                p2 = p1;
                min1 = mint;
                p1 = pt;
            }
        }
        while (lPoints.hasNext()) {
            Pnt p3 = lPoints.next();
            double min3 = Math.sqrt(Math.pow(q.coord(0) - p3.coord(0), 2.0) + Math.pow(q.coord(1) - p3.coord(1), 2.0));
            if (min3 <= min1) {
                min2 = min1;
                p2 = p1;
                min1 = min3;
                p1 = p3;
                continue;
            }
            if (!(min3 < min2)) continue;
            min2 = min3;
            p2 = p3;
        }
        return new Nearest(p1, p2, q);
    }

    private void drawVoronoiCells(List<Cell> c, int pt, javafx.geometry.Point2D[] p2d, float[][] p3d, float[][] pxd, int width, int height) {
        VoronoiPanel vPanel = new VoronoiPanel();
        vPanel.validate();
        vPanel.setSize(width, height);
        vPanel.setText("Proximit\ufffd");
        double[] d = p2d != null ? this.computeColor(this.getDistance2D(pt, p2d), this.getDistancexD(pt, pxd), pt) : this.computeColor(this.getDistancexD(pt, p3d), this.getDistancexD(pt, pxd), pt);
        int i = 0;
        for (Cell cel : c) {
            int col = (int)d[i];
            Pnt point = cel.getPoint();
            Polygon p = cel.buildPolygon(width, height);
            vPanel.addPolygon(p, new Point2D.Float((float)point.coord(0), (float)point.coord(1)), col);
            ++i;
        }
        vPanel.setRefPoint(pt);
        vPanel.setVisible(true);
    }

    private void drawVoronoiDistCells(List c, javafx.geometry.Point2D[] p2d, float[][] pxd, int width, int height) {
        VoronoiPanel vPanel = new VoronoiPanel();
        vPanel.validate();
        vPanel.setSize(width, height);
        vPanel.setText("Distorsion");
        this.colorList(c, p2d, pxd);
        for (CellDist cel : c) {
            Point2D.Double p1 = new Point2D.Double(p2d[cel.getPoint1()].getX(), p2d[cel.getPoint1()].getY());
            Point2D.Double p2 = new Point2D.Double(p2d[cel.getPoint2()].getX(), p2d[cel.getPoint2()].getY());
            vPanel.addPolygon(cel.getPolygon(), p1, p2, cel.getColor());
        }
        vPanel.setVisible(true);
    }

    private void drawVoronoiDistCells(List<CellDist> c, javafx.geometry.Point2D[] p2d, float[][] p3d, float[][] pxd, int width, int height) {
        VoronoiPanel vPanel = new VoronoiPanel();
        vPanel.validate();
        vPanel.setSize(width, height);
        vPanel.setText("Distorsion");
        this.colorList(c, p3d, pxd);
        for (CellDist cel : c) {
            Point2D.Double p1 = new Point2D.Double(p2d[cel.getPoint1()].getX(), p2d[cel.getPoint1()].getY());
            Point2D.Double p2 = new Point2D.Double(p2d[cel.getPoint2()].getX(), p2d[cel.getPoint2()].getY());
            vPanel.addPolygon(cel.getPolygon(), p1, p2, cel.getColor());
        }
        vPanel.setVisible(true);
    }

    private void colorList(List c, javafx.geometry.Point2D[] p2d, float[][] pxd) {
        double max = 0.0;
        double[] t = new double[c.size()];
        int pos = 0;
        for (CellDist cel : c) {
            int p1 = cel.getPoint1();
            int p2 = cel.getPoint2();
            if (p1 != -1 && p2 != -1) {
                double val;
                t[pos] = val = p2d[p1].distance(p2d[p2]) / this.getDistance(pxd[p1], pxd[p2]);
                if (max < val) {
                    max = val;
                }
            }
            ++pos;
        }
        Iterator it = c.iterator();
        pos = 0;
        while (it.hasNext()) {
            ((CellDist)it.next()).setColor((int)(t[pos] / max * 255.0));
            ++pos;
        }
    }

    private void colorList(List c, float[][] p3d, float[][] pxd) {
        double max = 0.0;
        double[] t = new double[c.size()];
        int pos = 0;
        for (CellDist cel : c) {
            int p1 = cel.getPoint1();
            int p2 = cel.getPoint2();
            if (p1 != -1 && p2 != -1) {
                double val;
                t[pos] = val = this.getDistance(p3d[p1], p3d[p2]) / this.getDistance(pxd[p1], pxd[p2]);
                if (max < val) {
                    max = val;
                }
            }
            ++pos;
        }
        Iterator it = c.iterator();
        pos = 0;
        while (it.hasNext()) {
            ((CellDist)it.next()).setColor((int)(t[pos] / max * 255.0));
            ++pos;
        }
    }

    private double getDistance(float[] d1, float[] d2) {
        double res = 0.0;
        int i = 0;
        while (i < d1.length) {
            res += Math.pow(d1[i] - d2[i], 2.0);
            ++i;
        }
        res = Math.sqrt(res);
        return res;
    }

    private double[] computeColor(double[] d1, double[] d2, int p) {
        double[] d = new double[d1.length];
        double max = 0.0;
        if (d1.length == d2.length) {
            int i = 0;
            while (i < d1.length) {
                double r = d1[i] / d2[i];
                if (r > max) {
                    max = r;
                }
                d[i] = r;
                ++i;
            }
            i = 0;
            while (i < d1.length) {
                d[i] = i == p ? 255.0 : d[i] / max * 255.0;
                ++i;
            }
        }
        return d;
    }

    private double[] getDistance2D(int pt, javafx.geometry.Point2D[] p2d) {
        double[] result = new double[p2d.length];
        int i = 0;
        while (i < p2d.length) {
            result[i] = p2d[pt].distance(p2d[i]);
            ++i;
        }
        return result;
    }

    private double[] getDistancexD(int pt, float[][] pxd) {
        double[] result = new double[pxd.length];
        int length = pxd[0].length;
        int i = 0;
        while (i < pxd.length) {
            int j = 0;
            while (j < length) {
                int n = i;
                result[n] = result[n] + Math.pow(pxd[i][j] - pxd[pt][j], 2.0);
                ++j;
            }
            result[i] = Math.sqrt(result[i]);
            ++i;
        }
        return result;
    }

    private class Cell {
        Pnt point;
        LinkedList<Line2D> listLine;
        LinkedList<Point2D> listPoint;

        public Cell(Pnt p2d) {
            this.point = p2d;
            this.listLine = new LinkedList();
        }

        public void addPoint(Line2D p) {
            this.listLine.add(p);
        }

        public Pnt getPoint() {
            return this.point;
        }

        public void clearList() {
            this.listLine.clear();
        }

        public void setPolygon() {
            int i = 0;
            while (i < this.listLine.size()) {
                Line2D l1 = this.listLine.get(i);
                int j = i + 1;
                while (j < this.listLine.size()) {
                    Line2D l2 = this.listLine.get(j);
                    if (l1.getP1().equals(l2.getP1()) && l1.getP2().equals(l2.getP2()) || l1.getP1().equals(l2.getP2()) && l1.getP2().equals(l2.getP1())) {
                        this.listLine.remove(j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            LinkedList<Point2D> l = new LinkedList<Point2D>();
            if (!this.listLine.isEmpty()) {
                l.add(this.listLine.getFirst().getP1());
                l.add(this.listLine.getFirst().getP2());
                this.listLine.remove(0);
            }
            while (!this.listLine.isEmpty()) {
                Point2D p = this.searchPoint((Point2D)l.getLast(), this.listLine);
                if (p.equals(l.getLast())) continue;
                if (p.equals(l.get(0))) break;
                l.add(p);
            }
            this.listPoint = l;
        }

        public Polygon buildPolygon(int width, int height) {
            Polygon p = new Polygon();
            for (Point2D p2d : this.listPoint) {
                p.addPoint((int)p2d.getX(), (int)p2d.getY());
            }
            return p;
        }

        private Point2D searchPoint(Point2D p, LinkedList<Line2D> l) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                Line2D l2d = (Line2D)it.next();
                if (l2d.getP1().equals(p)) {
                    it.remove();
                    return l2d.getP2();
                }
                if (!l2d.getP2().equals(p)) continue;
                it.remove();
                return l2d.getP1();
            }
            return p;
        }
    }

    private class CellDist {
        private javafx.geometry.Point2D point;
        private int p1;
        private int p2;
        private Polygon p;
        private int col = 0;

        public CellDist(javafx.geometry.Point2D p0, int p1, int p2, Polygon p) {
            this.point = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p = p;
        }

        public void setColor(int c) {
            this.col = c;
        }

        public javafx.geometry.Point2D getPoint() {
            return this.point;
        }

        public Polygon getPolygon() {
            return this.p;
        }

        public int getPoint1() {
            return this.p1;
        }

        public int getPoint2() {
            return this.p2;
        }

        public int getColor() {
            return this.col;
        }
    }

    private class Nearest {
        public Pnt p1;
        public Pnt p2;
        public Pnt q;

        public Nearest(Pnt p1, Pnt p2, Pnt q) {
            this.p1 = p1;
            this.p2 = p2;
            this.q = q;
        }
    }
}

