/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.compute.compute.Decoupe;
import explorer.data.DatasetParamsExplorer;
import explorer.data.Source3DCoord;
import explorer.data.SourceAVImpl;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import explorer.data.ViewManager;
import explorer.data.VirtualSourceAttrVal;
import explorer.windows.w2D.icview.ICVViewExplorer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Source;
import lib3d4j.data.SourceException;
import lib3d4j.data.SourceImpl;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.international.Messages;

public class DataManager {
    public static final int DT_ATTRVAL = 0;
    public static final int DT_DIST = 10;
    public static final int DT_3DCOORD = 20;
    public static final int DT_ADD = 30;
    public static final int DT_UNKNOWN = 1000;
    private static TreeMap<Integer, String> nameFromType;
    private static TreeMap<String, Integer> typeFromName;
    private int idgen = 0;
    private DatasetParamsExplorer params;
    private DescriptionData compAttr;
    private List<Source> sources;
    private ICVViewExplorer explorer;
    protected static DataManager singleton;

    static {
        singleton = new DataManager();
    }

    public static DataManager getSingleton() {
        return singleton;
    }

    private DataManager() {
        nameFromType = new TreeMap();
        nameFromType.put(0, Messages.getString("dt_attrval"));
        nameFromType.put(10, Messages.getString("dt_dist"));
        nameFromType.put(30, Messages.getString("dt_add"));
        nameFromType.put(20, Messages.getString("dt_3d"));
        nameFromType.put(1000, Messages.getString("dt_unknown"));
        typeFromName = new TreeMap();
        typeFromName.put(Messages.getString("dt_attrval"), 0);
        typeFromName.put(Messages.getString("dt_dist"), 10);
        typeFromName.put(Messages.getString("dt_add"), 30);
        typeFromName.put(Messages.getString("dt_3d"), 20);
        this.sources = new ArrayList<Source>();
        this.compAttr = new DescriptionData();
        this.params = new DatasetParamsExplorer();
        this.compAttr.setParams(this.params);
    }

    public SourceAttrVal createSourceAttrVal(URL u) throws SourceException {
        SourceAttrVal sav = (SourceAttrVal)this.createSource(0, u);
        return sav;
    }

    public VirtualSourceAttrVal createVirtualSourceAttrVal(SourceAttrVal src, int[] in) {
        VirtualSourceAttrVal vsav = new VirtualSourceAttrVal(src, in);
        this.addToSources(vsav);
        return vsav;
    }

    public SourceDist createSourceDist(URL u) throws SourceException {
        SourceDist sd = (SourceDist)this.createSource(10, u);
        return sd;
    }

    public Source3DCoord createSource3DCoord(URL u) throws SourceException {
        Source3DCoord s3dc = (Source3DCoord)this.createSource(20, u);
        return s3dc;
    }

    public Source createSource(int type, float[][] data) {
        SourceImpl src = null;
        if (type == 0) {
            src = new SourceAVImpl(data);
        } else if (type != 10) {
            if (type == 20) {
                src = new Source3DCoord(data);
            } else if (type == 30) {
                src = new SourceAVImpl(data);
            }
        }
        this.addToSources(src);
        return src;
    }

    public Source createSource(int type, URL u) throws SourceException {
        SourceImpl src = null;
        this.prepare();
        try {
            if (type == 0) {
                src = new SourceAVImpl(u);
            } else if (type == 10) {
                src = new SourceDist(u);
            } else if (type == 20) {
                src = new Source3DCoord(u);
            } else if (type == 30) {
                src = new SourceAVImpl(u);
            }
            this.addToSources(src);
            this.validate();
            return src;
        }
        catch (SourceException se) {
            this.rollback();
            throw se;
        }
    }

    public SourceAttrVal createSourceAttrVal(float[][] data) {
        SourceAVImpl sav = new SourceAVImpl(data);
        this.addToSources(sav);
        return sav;
    }

    public Source3DCoord createSource3DCoord(float[][] data) {
        Source3DCoord s3dc = new Source3DCoord(data);
        this.addToSources(s3dc);
        return s3dc;
    }

    public Source createCropedSource(Source s, int[] crop) {
        Source sc = s.crop(crop);
        this.addToSources(sc);
        return sc;
    }

    public Source createCropedSource(Source s, List<Integer> crop) {
        Source sc = s.crop(crop);
        this.addToSources(sc);
        return sc;
    }

    private void addToSources(Source src) {
        if (this.sources.isEmpty()) {
            CentralSelection.getSingleton().setObjectList(src.getNbObjects());
        }
        src.setId("SRC" + ++this.idgen);
        this.sources.add(src);
        this.explorer.addSource(src);
        ViewManager.getSingleton().setActiveSource(src);
    }

    public int getNbSources() {
        return this.sources.size();
    }

    public String getTypeValue(int dt) {
        return nameFromType.get(dt);
    }

    public int getTypeFromName(String dn) {
        Integer it = typeFromName.get(dn);
        if (it == null) {
            it = 1000;
        }
        return it;
    }

    public int getTypeFromDetailedName(String dn) {
        return this.getTypeFromName(dn);
    }

    public Source getSource(int idx) {
        return this.sources.get(idx);
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public DatasetParamsExplorer getParams() {
        return this.params;
    }

    public void setParams(DatasetParamsExplorer params) {
        this.params = params;
    }

    public void setCompAttr(DescriptionData compAttr) {
        this.compAttr = compAttr;
    }

    public DescriptionData getCompAttr() {
        return this.compAttr;
    }

    public void prepare() {
        this.compAttr.resetTmpColumns();
    }

    public void validate() {
        this.compAttr.resetTmpColumns();
    }

    public void rollback() {
        this.compAttr.clean();
        if (this.sources.isEmpty()) {
            this.compAttr.setNbDescrObjects(-1);
        }
    }

    public void reset() {
        this.params.reset();
        this.compAttr.reset();
        this.sources.clear();
    }

    public static int getDataType(URL u) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream()));
            return DataManager.getDataType(br);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1000;
        }
    }

    public static int getDataType(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            return DataManager.getDataType(br);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 1000;
        }
    }

    public static int getDataType(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            return DataManager.getDataType(br);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 1000;
        }
    }

    private static int getDataType(BufferedReader br) {
        String ligneFichier = null;
        Vector<String> vectorFile = new Vector<String>();
        int nbl = 0;
        try {
            while ((ligneFichier = br.readLine()) != null && nbl < 2) {
                String[] tabLigneFichier = ligneFichier.split("\\t");
                ligneFichier = "";
                int i = 0;
                while (i < tabLigneFichier.length) {
                    ligneFichier = i != tabLigneFichier.length - 1 ? String.valueOf(ligneFichier) + tabLigneFichier[i] + " " : String.valueOf(ligneFichier) + tabLigneFichier[i];
                    ++i;
                }
                vectorFile.add(ligneFichier);
                ++nbl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1000;
        }
        return DataManager.getDataType(vectorFile);
    }

    public static int getDataType(Vector<String> vectorFile) {
        int current = 0;
        boolean subset = false;
        String[] line1 = vectorFile.get(current).split("\\s");
        if (line1[0].startsWith("SUBSET")) {
            subset = true;
            line1 = vectorFile.get(++current).split("\\s");
        }
        switch (line1.length) {
            case 1: {
                String[] line2 = vectorFile.get(++current).split("\\s");
                switch (line2.length) {
                    case 1: {
                        return 0;
                    }
                }
                return 10;
            }
            case 2: {
                if (line1[1].equals("COMPLETE")) {
                    return 10;
                }
                return 1000;
            }
            case 3: {
                return 20;
            }
            case 4: {
                if (!subset) break;
                return 20;
            }
        }
        return 1000;
    }

    public int[][] decouperEchantillon(int nbTotalGroupes, int nbConserveApprentissage) {
        if (this.sources.isEmpty()) {
            return null;
        }
        int[][] res = new int[2][];
        int[] decoupage = Decoupe.nFold(this.compAttr.getClassIndices(), nbTotalGroupes);
        int cpt = 0;
        int i = 0;
        while (i < decoupage.length) {
            if (decoupage[i] < nbConserveApprentissage) {
                ++cpt;
            }
            ++i;
        }
        res[0] = new int[cpt];
        res[1] = new int[decoupage.length - cpt];
        int appCpt = 0;
        int testCpt = 0;
        int i2 = 0;
        while (i2 < decoupage.length) {
            if (decoupage[i2] < nbConserveApprentissage) {
                res[0][appCpt] = decoupage[i2];
                ++appCpt;
            } else {
                res[1][++testCpt] = decoupage[i2];
            }
            ++i2;
        }
        return res;
    }

    public boolean controlNbObjects(int nbobj) {
        int nbdo = this.compAttr.getNbDescrObjects();
        if (nbdo == -1) {
            this.compAttr.setNbDescrObjects(nbobj);
            return true;
        }
        return nbdo == nbobj;
    }

    public void setExplorer(ICVViewExplorer e) {
        this.explorer = e;
    }

    public void setClassAttribute(String name) {
        this.params.setClassCol(this.compAttr.getColumnIndex(name));
    }

    public void setColorAttribute(String name) {
        this.params.setColorCol(this.compAttr.getColumnIndex(name));
    }

    public void unsetClassAttribute() {
        this.params.setClassCol(-1);
    }

    public void unsetColorAttribute() {
        this.params.setColorCol(-1);
    }

    public void setMultiClass(String[] nomClasse) {
        int[] indices = new int[nomClasse.length];
        int i = 0;
        while (i < nomClasse.length) {
            indices[i] = this.compAttr.getColumnIndex(nomClasse[i]);
            ++i;
        }
        this.params.setMulticlass(indices);
    }

    public void unsetMultiClass() {
        this.params.setMulticlass(null);
    }
}

