/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import json.JSONException;
import json.JSONObject;
import lib3d4j.data.Options;

public class OptionsExplorer
extends Options {
    private static boolean DEFAULT_MULTISOURCE = true;
    private static String STR_MULTISOURCE = "multisource";
    private boolean multiSource = DEFAULT_MULTISOURCE;
    private static boolean DEFAULT_LISTENTOPORT = false;
    private static String STR_LISTENTOPORT = "listentoport";
    private boolean listenToPort = DEFAULT_LISTENTOPORT;
    private static int DEFAULT_PORT = 50000;
    private static String STR_PORT = "port";
    private int portNumber = DEFAULT_PORT;
    private static boolean DEFAULT_LEGENDDISPLAYED = true;
    private static String STR_LEGENDDISPLAYED = "legenddisplayed";
    private boolean legendDisplayed = DEFAULT_LEGENDDISPLAYED;
    private static OptionsExplorer singleton = null;

    public static OptionsExplorer getSingleton() {
        if (singleton == null) {
            singleton = new OptionsExplorer();
        }
        return singleton;
    }

    public boolean isMultiSource() {
        return this.multiSource;
    }

    public void setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
    }

    public boolean isListenToPort() {
        return this.listenToPort;
    }

    public void setListenToPort(boolean listenToPort) {
        this.listenToPort = listenToPort;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isLegendDisplayed() {
        return this.legendDisplayed;
    }

    public void setLegendDisplayed(boolean legendDisplayed) {
        this.legendDisplayed = legendDisplayed;
        super.notifyObservers();
    }

    public void load(String filename) {
        try {
            FileReader in = new FileReader(filename);
            BufferedReader br = new BufferedReader(in);
            String opt = null;
            while ((opt = br.readLine()) != null) {
                JSONObject jso = new JSONObject(opt);
                this.load(jso);
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("exception during access to option file: " + e.getMessage());
        }
    }

    @Override
    protected void load(JSONObject jso) {
        super.load(jso);
        this.setMultiSource(jso.optBoolean(STR_MULTISOURCE, DEFAULT_MULTISOURCE));
        this.setListenToPort(jso.optBoolean(STR_LISTENTOPORT, DEFAULT_LISTENTOPORT));
        this.setPortNumber(jso.optInt(STR_PORT, DEFAULT_PORT));
        this.setLegendDisplayed(jso.optBoolean(STR_LEGENDDISPLAYED, DEFAULT_LEGENDDISPLAYED));
    }

    public void load() {
        this.load(Options.DEFAULTOPTIONFILE);
    }

    @Override
    protected JSONObject toJson() {
        JSONObject jso = super.toJson();
        try {
            jso.put(STR_MULTISOURCE, this.isMultiSource());
            jso.put(STR_LISTENTOPORT, this.isListenToPort());
            jso.put(STR_PORT, this.getPortNumber());
            jso.put(STR_LEGENDDISPLAYED, this.isLegendDisplayed());
        }
        catch (JSONException e) {
            System.out.println("exception while preparing option file saving: " + e.getMessage());
        }
        return jso;
    }

    public void save(String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            PrintWriter pr = new PrintWriter(out);
            pr.println(this.toJson().toString());
            pr.close();
        }
        catch (Exception e) {
            System.out.println("exception during access to option file: " + e.getMessage());
        }
    }

    public void save() {
        this.save(Options.DEFAULTOPTIONFILE);
    }
}

