/*
 * Decompiled with CFR 0.152.
 */
package explorer.data;

import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.LoadException;
import explorer.data.NoFileException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import lib3d4j.data.Source;
import lib3d4j.data.SourceImpl;
import lib3d4j.international.Messages;

public class Source3DCoord
extends SourceImpl {
    private float[][] tab3D = null;

    public Source3DCoord() {
        this.type = 20;
    }

    public Source3DCoord(URL u) throws LoadException {
        this();
        this.url = u;
        this.loadFromUrl(u, Common.getSingleton());
        if (this.realIndex == null) {
            this.realIndex = new int[this.nbObjects];
            int i = 0;
            while (i < this.nbObjects) {
                this.realIndex[i] = i;
                ++i;
            }
        }
    }

    public Source3DCoord(Source3DCoord parent, int[] crop) {
        this();
        this.url = parent.getUrl();
        this.parent = parent;
        this.nbObjects = crop.length;
        this.realIndex = (int[])crop.clone();
        this.tab3D = new float[this.nbObjects][3];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < 3) {
                this.tab3D[i][j] = parent.tab3D[crop[i]][j];
                ++j;
            }
            ++i;
        }
    }

    public Source3DCoord(float[][] d) {
        this();
        this.tab3D = d;
        this.nbObjects = this.tab3D.length;
    }

    @Override
    public Source crop(int[] crop) {
        return new Source3DCoord(this, crop);
    }

    @Override
    public float[] distOrigine() {
        float[] tab = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            tab[i] = (float)Math.sqrt(this.tab3D[i][0] * this.tab3D[i][0] + this.tab3D[i][1] * this.tab3D[i][1] + this.tab3D[i][2] * this.tab3D[i][2]);
            ++i;
        }
        return tab;
    }

    @Override
    public float distance(int i, int j) {
        float dx = this.tab3D[i][0] - this.tab3D[j][0];
        float dy = this.tab3D[i][1] - this.tab3D[j][1];
        float dz = this.tab3D[i][2] - this.tab3D[j][2];
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public float[][] getCoords() {
        return this.tab3D;
    }

    private void loadFromUrl(URL u, Common c) throws LoadException {
        StringTokenizer st;
        BufferedReader br = null;
        int nbpt = 0;
        int[] ranks = null;
        if (c != null) {
            c.subtaskSetText("Lecture fichier passe 1/2...");
        }
        try {
            br = new BufferedReader(new InputStreamReader(u.openStream()));
        }
        catch (FileNotFoundException fe) {
            throw new NoFileException();
        }
        catch (IOException e) {
            throw new NoFileException();
        }
        int w = -1;
        String line = "";
        boolean subset = false;
        int offset = 0;
        try {
            line = br.readLine();
            if (line != null) {
                if (line.startsWith("SUBSET")) {
                    subset = true;
                    offset = line.indexOf("START WITH ") != -1 ? Integer.parseInt(line.substring(line.indexOf("START WITH ") + "START WITH ".length())) : 0;
                    line = br.readLine();
                }
                st = new StringTokenizer(line);
                try {
                    Float.parseFloat(st.nextToken());
                    ++nbpt;
                }
                catch (NumberFormatException numberFormatException) {}
                while ((line = br.readLine()) != null) {
                    ++nbpt;
                    if (c == null) continue;
                    c.Progress_reDraw();
                }
            }
            br.close();
        }
        catch (Exception e) {
            throw new LoadException();
        }
        if (!subset && !DataManager.getSingleton().controlNbObjects(nbpt)) {
            throw new LoadException(0);
        }
        this.tab3D = new float[nbpt][3];
        this.nbObjects = nbpt;
        if (subset) {
            this.realIndex = new int[nbpt];
        }
        try {
            br = new BufferedReader(new InputStreamReader(u.openStream()));
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (c != null) {
            c.subtaskSetOff();
        }
        if (c != null) {
            c.subtaskSetOn(String.valueOf(Messages.getString("common_fileread")) + " " + Messages.getString("step") + " 2/2" + Messages.getString("ldots"), nbpt);
        }
        try {
            int j;
            int i = 0;
            if (subset) {
                br.readLine();
            }
            line = br.readLine();
            st = new StringTokenizer(line);
            try {
                if (subset) {
                    this.realIndex[i] = Integer.parseInt(st.nextToken()) - offset;
                }
                j = 0;
                while (j < 3) {
                    this.tab3D[i][j] = Float.parseFloat(st.nextToken());
                    ++j;
                }
                if (st.hasMoreTokens()) {
                    this.initCompAttrNames(st.countTokens());
                }
                ++i;
            }
            catch (NumberFormatException e) {
                st.nextToken();
                st.nextToken();
                ranks = this.readCompAttrNames(st);
            }
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line);
                if (c != null) {
                    c.subtaskSetVal(i);
                }
                if (subset) {
                    this.realIndex[i] = Integer.parseInt(st.nextToken()) - offset;
                }
                j = 0;
                while (j < 3) {
                    this.tab3D[i][j] = Float.parseFloat(st.nextToken());
                    ++j;
                }
                if (st.hasMoreTokens()) {
                    this.readCompAttrs(i, st, ranks);
                }
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            throw new LoadException();
        }
        if (c != null) {
            c.subtaskSetOff();
        }
    }

    public static String check(Vector<String> vlist) {
        int numline = 0;
        int nbsup = 0;
        int nbsupexpected = 0;
        String line = "";
        Iterator<String> it = vlist.iterator();
        System.out.println("CHECK");
        if (!it.hasNext()) {
            return "Ligne 1 : fichier vide";
        }
        line = it.next();
        boolean subset = false;
        if (line.equals("SUBSET")) {
            line = it.next();
            subset = true;
        }
        ++numline;
        StringTokenizer st = new StringTokenizer(line);
        if (subset) {
            try {
                Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                return "Line " + numline + " colonne 1 : realindex attendu";
            }
        }
        int i = 0;
        while (i < 3) {
            try {
                Float.parseFloat(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                return "Line " + numline + " : champ num\u00e9ro " + i + 1 + " non num\u00e9rique";
            }
            ++i;
        }
        nbsup = 0;
        while (st.hasMoreTokens()) {
            st.nextToken();
            ++nbsupexpected;
        }
        while (it.hasNext()) {
            line = it.next();
            ++numline;
            st = new StringTokenizer(line);
            i = 0;
            while (i < 3) {
                try {
                    Float.parseFloat(st.nextToken());
                }
                catch (NumberFormatException nfe) {
                    return "Line " + numline + " : champ num\u00e9ro " + i + 1 + " non num\u00e9rique";
                }
                ++i;
            }
            nbsup = 0;
            while (st.hasMoreTokens()) {
                st.nextToken();
                ++nbsup;
            }
            if (nbsup == nbsupexpected) continue;
            return "Line " + numline + " : ne contient pas le bon nombre de champs";
        }
        System.out.println("Fichier correct");
        return "Fichier correct";
    }

    public float getValue(int i, int j) {
        return this.tab3D[i][j];
    }

    public void lireNoms3D(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() > 3) {
            int i = 0;
            while (i < 3) {
                st.nextToken();
                ++i;
            }
            this.readCompAttrNames(st);
        }
    }
}

