/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.AlongAxisTool;
import explorer.data.DataManager;
import explorer.windows.w2D.SwingUtils;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class ICVAlongAxis
extends JPanel {
    protected AlongAxisTool aat;
    protected int minPts = 10;
    protected Vector<String> v1;
    protected Vector<String> v2;
    protected JComboBox element1;
    protected JComboBox element2;
    protected JLabel liste;
    protected JButton JBvalider;
    protected JRadioButton choixAPlan3D;
    protected JRadioButton choixBPlan3D;
    protected JLabel JlMinPts;
    protected JTextField jtfMinPts;
    protected Boolean aChoisi = false;
    protected Boolean bChoisi = false;
    protected Boolean maj = false;
    protected float indicePaire;
    protected JPanel jpListeAxes;
    protected Map<String, JCheckBox> alCheckBox;
    protected Map<String, JButton> alJButton;
    protected JDialog dial;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private TargetSelectionListener alc = null;

    public ICVAlongAxis(AlongAxisTool c) {
        this.aat = c;
        this.setLayout(new BoxLayout(this, 1));
        this.setName(Messages.getString("tpgpaxesobservations_title"));
        this.alc = new TargetSelectionListener();
        JPanel jp = new JPanel(new GridLayout(-1, 2));
        this.choixAPlan3D = new JRadioButton(Messages.getString("tpgpaxesobservations_ObjetA"), false);
        this.choixAPlan3D.addMouseListener(new mouseClickJCB3D());
        jp.add(this.choixAPlan3D);
        this.v1 = new Vector();
        int i = 0;
        while (i < this.dd.getNbDescrObjects()) {
            this.v1.add("n. " + Integer.toString(i));
            ++i;
        }
        this.element1 = new JComboBox<String>(this.v1);
        this.element1.addActionListener(this.alc);
        jp.add(this.element1);
        this.choixBPlan3D = new JRadioButton(Messages.getString("tpgpaxesobservations_ObjetB"), false);
        this.choixBPlan3D.addMouseListener(new mouseClickJCB3D());
        this.choixBPlan3D.setMaximumSize(this.choixBPlan3D.getPreferredSize());
        jp.add(this.choixBPlan3D);
        this.v2 = new Vector();
        i = 0;
        while (i < this.dd.getNbDescrObjects()) {
            this.v2.add("n. " + Integer.toString(i));
            ++i;
        }
        this.element2 = new JComboBox<String>(this.v2);
        this.element2.addActionListener(this.alc);
        jp.add(this.element2);
        this.add(jp);
        ButtonGroup group = new ButtonGroup();
        group.add(this.choixAPlan3D);
        group.add(this.choixBPlan3D);
        jp = new JPanel(new FlowLayout(0));
        this.JlMinPts = new JLabel(Messages.getString("tpgpaxesobservations_minpts"));
        jp.add(this.JlMinPts);
        this.jtfMinPts = new JTextField(3);
        this.jtfMinPts.setMaximumSize(this.jtfMinPts.getPreferredSize());
        this.jtfMinPts.setText(new String("" + this.minPts));
        this.jtfMinPts.addKeyListener(new CheckMinListener());
        jp.add(this.jtfMinPts);
        this.add(jp);
        this.JBvalider = new JButton(Messages.getString("tpgpaxesobservations_valider"));
        this.JBvalider.addMouseListener(new validerclick());
        this.add(this.JBvalider);
        this.alCheckBox = new HashMap<String, JCheckBox>();
        this.alJButton = new HashMap<String, JButton>();
        this.initPanel();
        SwingUtils.alignX(this, 0.0f);
        this.aat.setAxes(this);
    }

    public int getT1() {
        return this.element1.getSelectedIndex();
    }

    public int getT2() {
        return this.element2.getSelectedIndex();
    }

    public int getNbPts() {
        return Integer.parseInt(this.jtfMinPts.getText());
    }

    public void valider() {
        this.aat.createAxis();
    }

    public ArrayList<float[]> listePoints(float[][] points) {
        ArrayList<float[]> pts = new ArrayList<float[]>();
        int i = 0;
        while (i < points.length) {
            float[] f = new float[]{points[i][0], points[i][1], points[i][2], i};
            pts.add(f);
            ++i;
        }
        return pts;
    }

    public void clickedObject(int index) {
        if (this.isShowing()) {
            if (this.aChoisi.booleanValue()) {
                this.element1.setSelectedIndex(index);
            } else if (this.bChoisi.booleanValue()) {
                this.element2.setSelectedIndex(index);
            }
        }
    }

    public void maj() {
        this.alc.setEnabled(false);
        this.element1.removeAllItems();
        this.element2.removeAllItems();
        int i = 0;
        while (i < this.dd.getNbDescrObjects()) {
            String elem = "n. " + i + " : " + (String)this.dd.getLabelValue(i);
            this.v1.add(elem);
            this.v2.add(elem);
            ++i;
        }
        this.maj = true;
        this.element1.setSelectedIndex(-1);
        this.maj = true;
        this.element2.setSelectedIndex(-1);
        this.alc.setEnabled(true);
    }

    public void addAxis(String s) {
        this.addCheckBox(s);
        this.addJButton(s);
    }

    public void removeAxis(String s) {
        this.jpListeAxes.remove(this.alJButton.remove(s));
        this.jpListeAxes.remove(this.alCheckBox.remove(s));
        this.dial.pack();
        if (this.alJButton.isEmpty()) {
            this.dial.setVisible(false);
        }
    }

    private void addCheckBox(String s) {
        JCheckBox box = new JCheckBox(s);
        box.addMouseListener(new CheckBoxListener());
        box.setSelected(true);
        this.alCheckBox.put(s, box);
        this.jpListeAxes.add(box);
        this.jpListeAxes.setVisible(true);
        this.dial.setVisible(true);
        this.dial.pack();
    }

    private void addJButton(String s) {
        JButton jb = new JButton(Messages.getString("tpgaxesobservations_suppr"));
        jb.addMouseListener(new Supprclick(s));
        this.alJButton.put(s, jb);
        this.jpListeAxes.add(jb);
        this.jpListeAxes.setVisible(true);
        this.dial.setVisible(true);
        this.dial.pack();
    }

    private void initPanel() {
        this.dial = new JDialog();
        this.jpListeAxes = new JPanel();
        this.jpListeAxes.setVisible(true);
        GridLayout glAxes = new GridLayout(0, 2);
        this.jpListeAxes.setLayout(glAxes);
        this.jpListeAxes.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.dial.setTitle(Messages.getString("tpgpaxesobservations_liste"));
        this.dial.add(this.jpListeAxes);
        this.dial.setLocation(286, 26);
        this.dial.setVisible(false);
        this.dial.pack();
    }

    class CheckBoxListener
    extends MouseAdapter {
        CheckBoxListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JCheckBox src = (JCheckBox)e.getSource();
            ICVAlongAxis.this.aat.displayAxis(src.getText(), src.isSelected());
        }
    }

    class CheckMinListener
    extends KeyAdapter {
        CheckMinListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int val = 0;
            try {
                val = Integer.parseInt(ICVAlongAxis.this.jtfMinPts.getText());
                if (val < 0) {
                    ICVAlongAxis.this.JBvalider.setEnabled(false);
                    ICVAlongAxis.this.jtfMinPts.setForeground(Color.RED);
                } else {
                    ICVAlongAxis.this.JBvalider.setEnabled(true);
                    ICVAlongAxis.this.jtfMinPts.setForeground(Color.BLACK);
                }
            }
            catch (NumberFormatException nfe) {
                ICVAlongAxis.this.JBvalider.setEnabled(false);
                ICVAlongAxis.this.jtfMinPts.setForeground(Color.RED);
            }
        }
    }

    class Supprclick
    extends MouseAdapter {
        String txt;

        public Supprclick(String s) {
            this.txt = s;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ICVAlongAxis.this.aat.dropAxis(this.txt);
        }
    }

    class TargetSelectionListener
    implements ActionListener {
        boolean enabled = true;

        TargetSelectionListener() {
        }

        public void setEnabled(boolean e) {
            this.enabled = e;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                ICVAlongAxis.this.aat.buildAxis();
            }
        }
    }

    class mouseClickJCB3D
    extends MouseAdapter {
        mouseClickJCB3D() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ICVAlongAxis.this.aChoisi = ICVAlongAxis.this.choixAPlan3D.isSelected();
            ICVAlongAxis.this.bChoisi = ICVAlongAxis.this.choixBPlan3D.isSelected();
        }
    }

    class validerclick
    extends MouseAdapter {
        validerclick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ICVAlongAxis.this.element1.getSelectedIndex() == ICVAlongAxis.this.element2.getSelectedIndex()) {
                JOptionPane.showMessageDialog(null, Messages.getString("warning_eltidentique"), Messages.getString("warning"), 2);
            } else {
                ICVAlongAxis.this.valider();
            }
        }
    }
}

