/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.OutilsCropBox;
import explorer.data.BoxParameters;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVCropBox
extends JPanel
implements BoxParameters {
    protected static final int SJCDEFAULT = 50;
    protected static final int SJMDEFAULT = 5;
    protected JButton btnNewCrop;
    protected JButton btnCancel;
    protected JButton btnCrop;
    protected JButton btnUnCrop;
    protected JSlider sJCX;
    protected JSlider sJCY;
    protected JSlider sJCZ;
    protected JSlider sJMX;
    protected JSlider sJMY;
    protected JSlider sJMZ;
    protected JButton btnClasse;
    private ChangeListenerTPGCrop lcl = null;
    private MouseClickTPGCrop mlc = null;
    private boolean sclOn = true;
    private OutilsCropBox parent = null;

    public ICVCropBox(OutilsCropBox p) {
        this.parent = p;
        this.parent.setICView(this);
        this.setName(Messages.getString("tpgcrop_title"));
        this.lcl = new ChangeListenerTPGCrop();
        this.mlc = new MouseClickTPGCrop();
        this.setLayout(new GridLayout(0, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.btnNewCrop = new JButton(Messages.getString("tpgcrop_new"));
        this.btnNewCrop.setBackground(this.getBackground());
        this.btnNewCrop.addMouseListener(this.mlc);
        panel.add(this.btnNewCrop);
        this.btnCrop = new JButton(Messages.getString("tpgcrop_crop"));
        this.btnCrop.setBackground(this.getBackground());
        this.btnCrop.addMouseListener(this.mlc);
        panel.add(this.btnCrop);
        this.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("tpgcrop_center")));
        this.sJCX = this.createSlider(100, 50);
        panel.add(this.sJCX);
        this.sJCY = this.createSlider(100, 50);
        panel.add(this.sJCY);
        this.sJCZ = this.createSlider(100, 50);
        panel.add(this.sJCZ);
        this.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("tpgcrop_size")));
        this.sJMX = this.createSlider(50, 5);
        panel.add(this.sJMX);
        this.sJMY = this.createSlider(50, 5);
        panel.add(this.sJMY);
        this.sJMZ = this.createSlider(50, 5);
        panel.add(this.sJMZ);
        this.add(panel);
        this.btnClasse = new JButton("Choix par classe");
        this.btnClasse.setBackground(this.getBackground());
        this.btnClasse.addMouseListener(this.mlc);
    }

    @Override
    public int getCX() {
        return this.sJCX.getValue();
    }

    @Override
    public int getCY() {
        return this.sJCY.getValue();
    }

    @Override
    public int getCZ() {
        return this.sJCZ.getValue();
    }

    @Override
    public int getLX() {
        return this.sJMX.getValue();
    }

    @Override
    public int getLY() {
        return this.sJMY.getValue();
    }

    @Override
    public int getLZ() {
        return this.sJMZ.getValue();
    }

    @Override
    public void setCX(int cx) {
        this.sJCX.setValue(cx);
    }

    @Override
    public void setCY(int cy) {
        this.sJCY.setValue(cy);
    }

    @Override
    public void setCZ(int cz) {
        this.sJCZ.setValue(cz);
    }

    @Override
    public void setLX(int lx) {
        this.sJMX.setValue(lx);
    }

    @Override
    public void setLY(int ly) {
        this.sJMY.setValue(ly);
    }

    @Override
    public void setLZ(int lz) {
        this.sJMZ.setValue(lz);
    }

    public void resetSliders() {
        this.setCX(50);
        this.setCY(50);
        this.setCZ(50);
        this.setLX(5);
        this.setLY(5);
        this.setLZ(5);
    }

    public void setSlidersChangeListener(boolean state) {
        this.sclOn = state;
    }

    public boolean isSclOn() {
        return this.sclOn;
    }

    private JSlider createSlider(int max, int def) {
        JSlider js = new JSlider(1, max, def);
        js.setBackground(this.getBackground());
        js.addChangeListener(this.lcl);
        js.addMouseListener(this.mlc);
        js.setMaximumSize(js.getPreferredSize());
        return js;
    }

    class ChangeListenerTPGCrop
    implements ChangeListener {
        ChangeListenerTPGCrop() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ICVCropBox.this.isSclOn()) {
                Object src = e.getSource();
                if (src == ICVCropBox.this.sJCX || src == ICVCropBox.this.sJCY || src == ICVCropBox.this.sJCZ) {
                    ICVCropBox.this.parent.moveCrop();
                } else {
                    ICVCropBox.this.parent.resizeCrop();
                }
            }
        }
    }

    class MouseClickTPGCrop
    extends MouseAdapter {
        MouseClickTPGCrop() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object sender = e.getSource();
            if (sender == ICVCropBox.this.btnNewCrop) {
                ICVCropBox.this.parent.creerCrop();
            } else if (sender == ICVCropBox.this.btnCancel) {
                ICVCropBox.this.parent.effacerCrop();
            } else if (sender == ICVCropBox.this.btnCrop) {
                ICVCropBox.this.parent.appliquerCrop();
            } else if (sender != ICVCropBox.this.btnUnCrop && sender == ICVCropBox.this.btnClasse) {
                System.out.println("Crop par classe : ");
            }
        }
    }
}

