/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.DimensionTravelTool;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVDimensionsTravel
extends JPanel {
    private DimensionTravelTool control;
    protected JButton btnGo;
    protected JCheckBox afficher;
    protected JSlider[][] sliders = null;
    protected JPanel slidersPanel;
    protected Dimension slidersize;
    protected int sJCDefaut = 0;
    private ChangeListenerTPGDimensionsTravel lcl = null;
    private MouseClickTPGDimensionsTravel mlc = null;

    public ICVDimensionsTravel(DimensionTravelTool t) {
        this.control = t;
        try {
            this.setName(Messages.getString("tpg_dimensions_travel_title"));
            this.lcl = new ChangeListenerTPGDimensionsTravel();
            this.mlc = new MouseClickTPGDimensionsTravel();
            this.setLayout(new BoxLayout(this, 1));
            JPanel header = new JPanel();
            int coord = 0;
            while (coord < 3) {
                header.add(new JLabel("X" + (coord + 1)));
                ++coord;
            }
            this.add(header);
            this.slidersize = new Dimension(40, 20);
            this.slidersPanel = new JPanel();
            this.slidersPanel.setLayout(new BoxLayout(this.slidersPanel, 1));
            this.add(this.slidersPanel);
            this.afficher = new JCheckBox(String.valueOf(Messages.getString("draw")) + Messages.getString("lines"));
            this.afficher.addMouseListener(this.mlc);
            this.afficher.setSelected(false);
            this.add(this.afficher);
            this.btnGo = new JButton(Messages.getString("draw"));
            this.btnGo.addMouseListener(this.mlc);
            this.add(this.btnGo);
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        ICVDimensionsTravel.this.control.showingChanged();
                    }
                }
            });
            this.control.setView(this);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, Messages.getString("errortravel"), Messages.getString("warning"), 2);
        }
    }

    public void setDimensions(float[][] coords) {
        this.slidersPanel.removeAll();
        if (coords != null) {
            int i;
            int newnbd = coords[0].length;
            if (this.sliders != null) {
                int j;
                int curnbd = this.sliders[0].length;
                JSlider[][] tmpsliders = new JSlider[3][];
                i = 0;
                while (i < 3) {
                    tmpsliders[i] = Arrays.copyOf(this.sliders[i], newnbd);
                    ++i;
                }
                if (curnbd < newnbd) {
                    i = 0;
                    while (i < 3) {
                        j = curnbd;
                        while (j < newnbd) {
                            tmpsliders[i][j] = new JSlider();
                            tmpsliders[i][j].setPreferredSize(this.slidersize);
                            tmpsliders[i][j].addChangeListener(this.lcl);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < 3) {
                        j = newnbd;
                        while (j < curnbd) {
                            this.sliders[i][j].removeChangeListener(this.lcl);
                            ++j;
                        }
                        ++i;
                    }
                }
                this.sliders = tmpsliders;
            } else {
                this.sliders = new JSlider[3][newnbd];
                int i2 = 0;
                while (i2 < 3) {
                    int j = 0;
                    while (j < newnbd) {
                        this.sliders[i2][j] = new JSlider();
                        this.sliders[i2][j].setPreferredSize(this.slidersize);
                        this.sliders[i2][j].addChangeListener(this.lcl);
                        ++j;
                    }
                    ++i2;
                }
            }
            int j = 0;
            while (j < newnbd) {
                JPanel line = new JPanel();
                line.add(new JLabel(String.valueOf(1 + j) + " "));
                i = 0;
                while (i < 3) {
                    this.sliders[i][j].setValue((int)(100.0f * coords[i][j]));
                    line.add(this.sliders[i][j]);
                    ++i;
                }
                this.slidersPanel.add(line);
                ++j;
            }
        }
        SwingUtilities.windowForComponent(this).pack();
    }

    public float[][] getDimensions() {
        int nbd = this.sliders[0].length;
        float[][] coords = new float[3][nbd];
        int dimDest = 0;
        while (dimDest < nbd) {
            coords[0][dimDest] = (float)this.sliders[0][dimDest].getValue() / 100.0f;
            coords[1][dimDest] = (float)this.sliders[1][dimDest].getValue() / 100.0f;
            coords[2][dimDest] = (float)this.sliders[2][dimDest].getValue() / 100.0f;
            ++dimDest;
        }
        return coords;
    }

    public boolean isDisplayLines() {
        return this.afficher.isSelected();
    }

    class ChangeListenerTPGDimensionsTravel
    implements ChangeListener {
        ChangeListenerTPGDimensionsTravel() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ICVDimensionsTravel.this.control.dimensionsChanged();
        }
    }

    class MouseClickTPGDimensionsTravel
    extends MouseAdapter {
        MouseClickTPGDimensionsTravel() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object sender = e.getSource();
            if (sender == ICVDimensionsTravel.this.btnGo) {
                ICVDimensionsTravel.this.control.move();
            } else if (sender == ICVDimensionsTravel.this.afficher) {
                ICVDimensionsTravel.this.control.dimensionsChanged();
            }
        }
    }
}

