/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.DisplayStyleTool;
import explorer.windows.w2D.SwingUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lib3d4j.international.Messages;

public class ICVDisplayStyle
extends JPanel {
    protected DisplayStyleTool dst;
    protected JComboBox cbBackground;
    protected JComboBox cbGuideLines;
    private componentChangeTPGVisuStyle lcl = null;

    public ICVDisplayStyle(DisplayStyleTool t) {
        this.setName(Messages.getString("tpgstyle_title"));
        this.lcl = new componentChangeTPGVisuStyle();
        this.setLayout(new BoxLayout(this, 1));
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        JLabel lStyle = new JLabel(Messages.getString("tpgstyle_background"));
        lStyle.setBackground(this.getBackground());
        left.add(lStyle);
        this.cbBackground = new JComboBox();
        this.cbBackground.addItemListener(this.lcl);
        right.add(this.cbBackground);
        JLabel lQuad = new JLabel(Messages.getString("tpgstyle_square"));
        lQuad.setBackground(this.getBackground());
        left.add(lQuad);
        this.cbGuideLines = new JComboBox();
        this.cbGuideLines.addItemListener(this.lcl);
        right.add(this.cbGuideLines);
        JPanel jp = new JPanel();
        SwingUtils.setTwoColsLayout(jp, left, right);
        this.add(jp);
        SwingUtils.alignX(this, 0.5f);
        this.dst = t;
        this.dst.setView(this);
    }

    public void setGlList(List<String> gl, int selindex) {
        this.cbGuideLines.removeItemListener(this.lcl);
        this.cbGuideLines.removeAllItems();
        for (String s : gl) {
            this.cbGuideLines.addItem(s);
        }
        this.cbGuideLines.setSelectedIndex(selindex);
        this.cbGuideLines.addItemListener(this.lcl);
    }

    public void setBgList(List<String> bg, int selindex) {
        this.cbBackground.removeItemListener(this.lcl);
        this.cbBackground.removeAllItems();
        for (String s : bg) {
            this.cbBackground.addItem(s);
        }
        this.cbBackground.setSelectedIndex(selindex);
        this.cbBackground.addItemListener(this.lcl);
    }

    public int getGuideLines() {
        return this.cbGuideLines.getSelectedIndex();
    }

    public int getBackgroundStyle() {
        return this.cbBackground.getSelectedIndex();
    }

    public void setGuideLines(int s) {
        this.cbGuideLines.removeItemListener(this.lcl);
        this.cbGuideLines.setSelectedIndex(s);
        this.cbGuideLines.addItemListener(this.lcl);
    }

    public void setBackgroundStyle(int b) {
        this.cbBackground.removeItemListener(this.lcl);
        this.cbBackground.setSelectedIndex(b);
        this.cbBackground.addItemListener(this.lcl);
    }

    class componentChangeTPGVisuStyle
    implements ItemListener {
        componentChangeTPGVisuStyle() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source == ICVDisplayStyle.this.cbGuideLines) {
                ICVDisplayStyle.this.dst.squareChanged();
            } else if (source == ICVDisplayStyle.this.cbBackground) {
                ICVDisplayStyle.this.dst.backgroundChanged();
            }
        }
    }
}

