/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.Lens;
import explorer.windows.w2D.SwingUtils;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVLens
extends JPanel {
    protected JSlider sMagnDia;
    protected JSlider sMagnCoeff;
    protected JSlider sMagnOpacity;
    private mouseClicTPGLoupe lcl = null;

    public ICVLens() {
        this.setName(Messages.getString("lens_title"));
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        this.lcl = new mouseClicTPGLoupe();
        JLabel lDiamLabel = new JLabel(Messages.getString("lens_diameter"));
        lDiamLabel.setBackground(this.getBackground());
        left.add(lDiamLabel);
        this.sMagnDia = new JSlider(50, 500, 50);
        this.sMagnDia.setBackground(this.getBackground());
        this.sMagnDia.addChangeListener(this.lcl);
        right.add(this.sMagnDia);
        JLabel lCoeff = new JLabel(Messages.getString("lens_coeff"));
        left.add(lCoeff);
        this.sMagnCoeff = new JSlider(1, 5, 2);
        this.sMagnCoeff.setBackground(this.getBackground());
        this.sMagnCoeff.addChangeListener(this.lcl);
        right.add(this.sMagnCoeff);
        JLabel lOpacity = new JLabel(Messages.getString("lens_opacity"));
        left.add(lOpacity);
        this.sMagnOpacity = new JSlider(0, 100, 75);
        this.sMagnOpacity.setBackground(this.getBackground());
        this.sMagnOpacity.addChangeListener(this.lcl);
        this.sMagnOpacity.setEnabled(false);
        right.add(this.sMagnOpacity);
        SwingUtils.setTwoColsLayout(this, left, right);
    }

    public int getSMagnDia() {
        return this.sMagnDia.getValue();
    }

    public int getSMagnCoeff() {
        return this.sMagnCoeff.getValue();
    }

    class mouseClicTPGLoupe
    implements ChangeListener {
        mouseClicTPGLoupe() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == ICVLens.this.sMagnDia) {
                Lens.getSingleton().setDiameter(ICVLens.this.sMagnDia.getValue());
            } else if (source == ICVLens.this.sMagnCoeff) {
                Lens.getSingleton().setCoeff(ICVLens.this.sMagnCoeff.getValue());
            } else if (source == ICVLens.this.sMagnOpacity) {
                Lens.getSingleton().setOpacity(ICVLens.this.sMagnOpacity.getValue());
            }
        }
    }
}

