/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.ObservationsTool;
import explorer.windows.w2D.SwingUtils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lib3d4j.international.Messages;

public class ICVObservations
extends JPanel {
    protected JLabel lVarExpliquee;
    protected ZoneGraph zgGraph = null;
    protected JLabel lQualite;
    protected ObservationsTool ot = null;

    public ICVObservations(ObservationsTool t) {
        this.setName(Messages.getString("tpgobs_title"));
        this.ot = t;
        t.setTPG(this);
        this.setLayout(new BoxLayout(this, 1));
        this.lVarExpliquee = new JLabel();
        this.lVarExpliquee.setText("--");
        this.lVarExpliquee.setBackground(this.getBackground());
        this.add(this.lVarExpliquee);
        this.zgGraph = new ZoneGraph();
        this.zgGraph.addMouseListener(new mouseClickTPGObservations(this.zgGraph, this));
        this.add(this.zgGraph);
        this.lQualite = new JLabel();
        this.unsetQual();
        this.add(this.lQualite);
        SwingUtils.alignX(this, 0.0f);
    }

    public void unset() {
        this.zgGraph.unset();
        this.unsetVariance();
    }

    public void draw(double[] ev, int a1, int a2, int a3, double va) {
        this.zgGraph.dessine(ev, a1, a2, a3, va);
        this.setVariance(va);
    }

    private void setVariance(double va) {
        this.lVarExpliquee.setText(String.format("%s : %5.2f %%", Messages.getString("tpgobs_expvar"), va));
    }

    private void unsetVariance() {
        this.lVarExpliquee.setText(String.valueOf(Messages.getString("tpgobs_expvar")) + " : N.C.");
    }

    public void setQual(float f) {
        this.lQualite.setText(String.format("%s : %10.9f", Messages.getString("tpgobs_dunn"), Float.valueOf(f)));
    }

    public void unsetQual() {
        this.lQualite.setText("--");
    }

    private class ZoneGraph
    extends Canvas {
        private static final int ZGH = 120;
        private static final int ZGW = 220;
        private int NBMAXEV = 20;
        private Color UNDISPLAYED = Color.blue;
        private Color DISPLAYED = Color.red;
        private int[] height = null;
        private int varExpliq = 0;
        private int i1 = 0;
        private int i2 = 0;
        private int i3 = 0;

        public ZoneGraph() {
            this.setSize(220, 120);
            this.setBackground(Color.white);
        }

        @Override
        public void paint(Graphics g1) {
            this.dessine();
        }

        public void unset() {
            this.height = null;
        }

        public void dessine(double[] ev, int i1, int i2, int i3, double va) {
            this.height = this.convertToHeight(ev);
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.varExpliq = (int)(va * (double)3.6f);
            this.repaint();
        }

        public void dessine() {
            Graphics g = this.getGraphics();
            if (this.height == null) {
                g.fillRect(0, 0, 220, 120);
            } else {
                g.setColor(Color.white);
                g.fillArc(150, 15, 50, 50, 0, 360);
                g.setColor(Color.gray);
                g.drawOval(150, 15, 50, 50);
                g.setColor(Color.red);
                g.fillArc(150, 15, 50, 50, 90 - this.varExpliq, this.varExpliq);
                g.drawLine(5, 110, 210, 110);
                g.drawLine(205, 107, 210, 110);
                g.drawLine(205, 113, 210, 110);
                g.drawLine(10, 5, 7, 10);
                g.drawLine(10, 5, 13, 10);
                g.drawLine(10, 5, 10, 115);
                if (this.height != null) {
                    int k = 0;
                    int i = 0;
                    while (i < this.height.length) {
                        g.setColor(this.UNDISPLAYED);
                        if (i == this.i1 || i == this.i2 || i == this.i3) {
                            g.setColor(this.DISPLAYED);
                        }
                        g.fillRect(20 + 9 * k, 110 - this.height[i], 5, this.height[i]);
                        ++k;
                        ++i;
                    }
                }
            }
        }

        private int[] convertToHeight(double[] ev) {
            int ln = Math.min(this.NBMAXEV, ev.length);
            int[] res = new int[ln];
            double maxi = ev[0];
            int i = 1;
            while (i < ev.length) {
                if (ev[i] > maxi) {
                    maxi = ev[i];
                }
                ++i;
            }
            i = 0;
            while (i < ln) {
                res[i] = (int)(ev[i] * 100.0 / maxi);
                ++i;
            }
            return res;
        }
    }

    class mouseClickTPGObservations
    extends MouseAdapter {
        Object sender;

        mouseClickTPGObservations(Object sender, ICVObservations t) {
            this.sender = sender;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.sender == ICVObservations.this.zgGraph && e.getButton() == 1) {
                ICVObservations.this.ot.drawHistogram();
            }
        }
    }
}

