/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.OutilSVM;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class ICVSVM
extends JPanel
implements Observer {
    protected JLabel jlConstant;
    protected JLabel jlChoice1;
    protected JLabel jlChoice2;
    protected JTextField jtConstant;
    protected JPanel jpConstant;
    protected JComboBox jcbClass1;
    protected JComboBox jcbClass2;
    protected OutilSVM parent;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private DatasetParamsExplorer params;

    public ICVSVM(OutilSVM osvm) {
        this.parent = osvm;
        this.parent.setTpgSvm(this);
        this.setName(Messages.getString("tpgsvm_title"));
        this.setLayout(new GridLayout(0, 1));
        this.jpConstant = new JPanel(new FlowLayout(0));
        this.jtConstant = new JTextField("1", 5);
        this.jpConstant.add(this.jtConstant);
        this.jlConstant = new JLabel(Messages.getString("tpgsvm_constant"));
        this.jpConstant.add(this.jlConstant);
        this.add(this.jpConstant);
        this.jlChoice1 = new JLabel(Messages.getString("tpgsvm_entre"));
        this.add(this.jlChoice1);
        JPanel jpBetween = new JPanel(new FlowLayout(1));
        this.jcbClass1 = new JComboBox();
        this.jcbClass1.setEnabled(false);
        jpBetween.add(this.jcbClass1);
        this.jlChoice2 = new JLabel(Messages.getString("tpgsvm_et"));
        jpBetween.add(this.jlChoice2);
        this.jcbClass2 = new JComboBox();
        this.jcbClass1.setEnabled(false);
        jpBetween.add(this.jcbClass2);
        this.add(jpBetween);
        this.params = DataManager.getSingleton().getParams();
        this.params.addObserver(this);
        this.maj();
    }

    @Override
    public void update(Observable o, Object arg) {
        int col;
        if (o instanceof DatasetParamsExplorer && arg != null && arg instanceof Integer && (((col = ((Integer)arg).intValue()) & 2) != 0 || (col & 0x40) != 0)) {
            this.maj();
        }
    }

    private void maj() {
        this.jcbClass1.removeAllItems();
        this.jcbClass2.removeAllItems();
        boolean relevant = !this.params.isMultiClassActive() && this.params.isSetClassCol();
        this.setEnabled(relevant);
        if (relevant) {
            int i = 0;
            while (i < this.dd.getNbClasses()) {
                this.jcbClass1.addItem(this.dd.getSymbElementAt(i));
                this.jcbClass2.addItem(this.dd.getSymbElementAt(i));
                ++i;
            }
            this.jcbClass2.addItem(Messages.getString("tpgsvm_leReste"));
            this.jcbClass1.setSelectedIndex(0);
            this.jcbClass2.setSelectedIndex(0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            this.recursiveSetEnabled(c, enabled);
            ++n2;
        }
    }

    private void recursiveSetEnabled(Component c, boolean b) {
        c.setEnabled(b);
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component sub = componentArray[n2];
                this.recursiveSetEnabled(sub, b);
                ++n2;
            }
        }
    }

    public void setConstant(String constant) {
        this.jtConstant.setText(constant);
    }

    public float getConstant() {
        return Float.parseFloat(this.jtConstant.getText());
    }

    public int getIndexSelectedClass1() {
        return this.jcbClass1.getSelectedIndex();
    }

    public int getIndexSelectedClass2() {
        return this.jcbClass2.getSelectedIndex();
    }

    public int restIndice() {
        return this.jcbClass2.getItemCount() - 1;
    }
}

