/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.SamplingTool;
import explorer.data.ViewManager;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class ICVSampling
extends JPanel {
    private SamplingTool control = new SamplingTool(this);
    private JTextField jtfrate;
    private JDialog jd = null;

    public ICVSampling() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jpline = new JPanel(new FlowLayout());
        jpline.add(new JLabel(Messages.getString("samp_source")));
        Source ds = ViewManager.getSingleton().getActiveSource();
        JTextField jtfODS = new JTextField();
        if (ds != null) {
            jtfODS.setText(ds.getName());
        } else {
            jtfODS.setText(Messages.getString("samp_noDS"));
        }
        jtfODS.setEditable(false);
        jpline.add(jtfODS);
        this.add(jpline);
        jpline = new JPanel(new FlowLayout());
        jpline.add(new JLabel(Messages.getString("samp_rate")));
        this.jtfrate = new JTextField(3);
        jpline.add(this.jtfrate);
        this.add(jpline);
        jpline = new JPanel(new FlowLayout());
        JButton jbok = new JButton(Messages.getString("ok"));
        jbok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICVSampling.this.control.doSample();
            }
        });
        jpline.add(jbok);
        if (ds == null) {
            jbok.setEnabled(false);
        }
        JButton jbcancel = new JButton(Messages.getString("cancel"));
        jbcancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICVSampling.this.control.doCancel();
            }
        });
        jpline.add(jbcancel);
        this.add(jpline);
    }

    public int getRate() {
        return Integer.parseInt(this.jtfrate.getText());
    }

    public void close() {
        if (this.jd != null) {
            this.jd.setVisible(false);
        }
    }

    public JDialog getDialog(Frame owner) {
        this.jd = new JDialog(owner, true);
        this.jd.setTitle(Messages.getString("samp_title"));
        this.jd.add(this);
        this.jd.pack();
        return this.jd;
    }
}

