/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.ScaleTool;
import explorer.windows.w2D.SwingUtils;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ICVSpaceScale
extends JPanel {
    private static final int SCALE_DEFAULT = 5;
    protected JSlider sElemScale;
    protected JSlider sSpaceScale;
    protected ScaleTool st;
    private mouseClickTPGVisuEspace lcl = null;

    public ICVSpaceScale(ScaleTool s) {
        this.st = s;
        this.st.setView(this);
        this.setName(Messages.getString("tpgspace_title"));
        this.lcl = new mouseClickTPGVisuEspace();
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        JLabel lStyle = new JLabel(Messages.getString("tpgspace_dilatobj"));
        lStyle.setBackground(this.getBackground());
        left.add(lStyle);
        this.sElemScale = new JSlider(1, 30, 5);
        this.sElemScale.setBackground(this.getBackground());
        this.sElemScale.addChangeListener(this.lcl);
        right.add(this.sElemScale);
        SwingUtils.setTwoColsLayout(this, left, right);
    }

    public void setElemScale(float e) {
        this.lcl.setActive(false);
        this.sElemScale.setValue((int)e);
        this.lcl.setActive(true);
    }

    public void setSpaceScale(float s) {
    }

    class mouseClickTPGVisuEspace
    implements ChangeListener {
        private boolean active = true;

        mouseClickTPGVisuEspace() {
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.active) {
                Object source = e.getSource();
                if (source == ICVSpaceScale.this.sElemScale) {
                    ICVSpaceScale.this.st.rescalePrimitives(ICVSpaceScale.this.sElemScale.getValue());
                } else if (source == ICVSpaceScale.this.sSpaceScale) {
                    float newScale = (float)ICVSpaceScale.this.sSpaceScale.getValue() / 10.0f;
                    ICVSpaceScale.this.st.rescaleSpace(newScale);
                }
            }
        }
    }
}

