/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview;

import explorer.compute.tools.VisualAttributesTool;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.data.ViewManager;
import explorer.data.ViewObserver;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.SwingUtils;
import explorer.windows.w2D.utils.GView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class ICVVisualAttributes
extends JPanel
implements Observer,
ViewObserver {
    protected JComboBox cbForm;
    protected JComboBox cbColor;
    protected JComboBox cbLabel;
    protected JComboBox cbAssocData;
    protected JComboBox cbClass;
    private componentChangeTPGVisuAff lcl = null;
    protected JList jlMulticlass;
    protected JScrollPane jspMulticlass;
    private MulticlassListener mcl = null;
    private JLabel lMultiClass;
    private JCheckBox cbViewSpecAD;
    private JCheckBox cbTexture;
    protected DatasetParamsExplorer params = null;
    protected DescriptionData descr = null;
    protected VisualAttributesTool vat = null;
    private DisplayExplorer f3d = null;

    public ICVVisualAttributes(VisualAttributesTool t) {
        this.setName(Messages.getString("tpgva_title"));
        this.lcl = new componentChangeTPGVisuAff();
        this.vat = t;
        this.vat.setICView(this);
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        JLabel lClass = new JLabel(Messages.getString("tpgva_class"));
        lClass.setBackground(this.getBackground());
        left.add(lClass);
        Vector v1 = new Vector();
        this.cbClass = new JComboBox(v1);
        this.cbClass.addActionListener(this.lcl);
        right.add(this.cbClass);
        this.lMultiClass = new JLabel(Messages.getString("tpgva_class"));
        this.lMultiClass.setBackground(this.getBackground());
        this.lMultiClass.setVisible(false);
        left.add(this.lMultiClass);
        this.jlMulticlass = new JList();
        this.jlMulticlass.setLayoutOrientation(0);
        this.jlMulticlass.setSelectionMode(2);
        this.jlMulticlass.setVisibleRowCount(5);
        this.mcl = new MulticlassListener();
        this.jlMulticlass.addListSelectionListener(this.mcl);
        this.jspMulticlass = new JScrollPane(this.jlMulticlass);
        this.jspMulticlass.setPreferredSize(new Dimension(250, 80));
        this.jspMulticlass.setVisible(false);
        right.add(this.jspMulticlass);
        JLabel lAssocData = new JLabel(Messages.getString("tpgva_assocdata"));
        lAssocData.setBackground(this.getBackground());
        left.add(lAssocData);
        Vector v2 = new Vector();
        this.cbAssocData = new JComboBox(v2);
        this.cbAssocData.addActionListener(this.lcl);
        right.add(this.cbAssocData);
        JLabel lViewSpecAD = new JLabel(Messages.getString("tpgva_viewspecad"));
        lViewSpecAD.setToolTipText(Messages.getString("tpgva_viewspecadcomment"));
        lViewSpecAD.setBackground(this.getBackground());
        left.add(lViewSpecAD);
        this.cbViewSpecAD = new JCheckBox();
        this.cbViewSpecAD.setToolTipText(Messages.getString("tpgva_viewspecadcomment"));
        this.cbViewSpecAD.addActionListener(this.lcl);
        right.add(this.cbViewSpecAD);
        JLabel lLabel = new JLabel(Messages.getString("tpgva_label"));
        lLabel.setBackground(this.getBackground());
        left.add(lLabel);
        Vector v3 = new Vector();
        this.cbLabel = new JComboBox(v3);
        this.cbLabel.addActionListener(this.lcl);
        right.add(this.cbLabel);
        JLabel lForm = new JLabel(Messages.getString("tpgva_form"));
        lForm.setBackground(this.getBackground());
        left.add(lForm);
        Vector v4 = new Vector();
        this.cbForm = new JComboBox(v4);
        this.cbForm.addActionListener(this.lcl);
        right.add(this.cbForm);
        JLabel lColor = new JLabel(Messages.getString("tpgva_color"));
        lColor.setBackground(this.getBackground());
        left.add(lColor);
        Vector v5 = new Vector();
        this.cbColor = new JComboBox(v5);
        this.cbColor.setEnabled(true);
        this.cbColor.addActionListener(this.lcl);
        right.add(this.cbColor);
        JLabel lTexture = new JLabel(Messages.getString("tpgva_texture"));
        lTexture.setToolTipText(Messages.getString("tpgva_texturecomment"));
        lTexture.setBackground(this.getBackground());
        left.add(lTexture);
        this.cbTexture = new JCheckBox();
        this.cbTexture.setToolTipText(Messages.getString("tpgva_texturecomment"));
        this.cbTexture.addActionListener(this.lcl);
        right.add(this.cbTexture);
        SwingUtils.setTwoColsLayout(this, left, right);
        this.params = DataManager.getSingleton().getParams();
        this.params.addObserver(this);
        this.descr = DataManager.getSingleton().getCompAttr();
        this.descr.addObserver(this);
        ViewManager.getSingleton().addViewObserver(this);
        this.updateLists(new ArrayList<String>(), -1, -1, -1, -1, -1);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DatasetParamsExplorer) {
            if (arg != null && arg instanceof Integer) {
                this.lcl.setActive(false);
                int col = (Integer)arg;
                if ((col & 2) != 0 && this.params.getClassCol() != this.getClassColumn()) {
                    this.cbClass.setSelectedIndex(this.params.getClassCol() + 1);
                }
                if ((col & 1) != 0 && this.params.getColorCol() != this.getColorColumn()) {
                    this.cbColor.setSelectedIndex(this.params.getColorCol() + 1);
                }
                if ((col & 4) != 0 && this.params.getAssocDataCol() != this.getAssocDataColumn() && (this.f3d == null || this.f3d.getSpecificPictureAttribute() == -1)) {
                    this.cbAssocData.setSelectedIndex(this.params.getAssocDataCol() + 1);
                }
                if ((col & 8) != 0 && this.params.getFormCol() != this.getFormColumn()) {
                    this.cbForm.setSelectedIndex(this.params.getFormCol() + 1);
                }
                if ((col & 0x10) != 0 && this.params.getLabelCol() != this.getLabelColumn()) {
                    this.cbLabel.setSelectedIndex(this.params.getLabelCol() + 1);
                }
                if ((col & 0x40) != 0) {
                    this.setMulticlassVisible(this.params.isMultiClassActive());
                }
                if ((col & 0x20) != 0) {
                    this.setMultiClass(this.params.getMulticlass());
                }
                this.lcl.setActive(true);
            }
        } else {
            int f = this.params.getFormCol();
            int c = this.params.getColorCol();
            int l = this.params.getLabelCol();
            int a = this.f3d != null && this.f3d.getSpecificPictureAttribute() != -1 ? this.f3d.getSpecificPictureAttribute() : this.params.getAssocDataCol();
            int cl = this.params.getClassCol();
            LinkedList<String> attrNames = this.descr.getListeNoms();
            this.updateLists(attrNames, f, c, l, a, cl);
        }
        if (this.params.isMulticlass()) {
            this.params.getMulticlass();
        }
    }

    @Override
    public void activeViewChanged(GView v) {
        this.lcl.setActive(false);
        int adcol = this.params.getAssocDataCol();
        boolean spec = false;
        if (v instanceof DisplayExplorer) {
            this.f3d = (DisplayExplorer)v;
            if (this.f3d.getSpecificPictureAttribute() != -1) {
                spec = true;
                adcol = this.f3d.getSpecificPictureAttribute();
            }
        } else {
            this.f3d = null;
        }
        this.cbAssocData.setSelectedIndex(adcol + 1);
        this.cbViewSpecAD.setSelected(spec);
        this.lcl.setActive(true);
    }

    private void updateLists(List<String> attrNames, int fom, int col, int lbl, int asso, int cla) {
        this.lcl.setActive(false);
        this.cbForm.removeAllItems();
        this.cbColor.removeAllItems();
        this.cbLabel.removeAllItems();
        this.cbAssocData.removeAllItems();
        this.cbClass.removeAllItems();
        attrNames.add(0, "--");
        for (String s : attrNames) {
            this.cbForm.addItem(s);
            this.cbColor.addItem(s);
            this.cbLabel.addItem(s);
            this.cbAssocData.addItem(s);
            this.cbClass.addItem(s);
        }
        this.cbForm.setSelectedIndex(fom + 1);
        this.cbColor.setSelectedIndex(col + 1);
        this.cbLabel.setSelectedIndex(lbl + 1);
        this.cbAssocData.setSelectedIndex(asso + 1);
        this.cbClass.addItem(Messages.getString("tpgva_multiclass"));
        if (this.params.isMultiClassActive()) {
            this.cbClass.setSelectedIndex(this.cbClass.getItemCount() - 1);
        } else {
            this.cbClass.setSelectedIndex(cla + 1);
        }
        this.lcl.setActive(true);
    }

    public int getFormColumn() {
        if (this.cbForm.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbForm.getSelectedIndex() - 1;
    }

    public int getColorColumn() {
        if (this.cbColor.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbColor.getSelectedIndex() - 1;
    }

    public int getLabelColumn() {
        if (this.cbLabel.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbLabel.getSelectedIndex() - 1;
    }

    public int getAssocDataColumn() {
        if (this.cbAssocData.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbAssocData.getSelectedIndex() - 1;
    }

    public boolean isViewSpecAssodDataSelected() {
        return this.cbViewSpecAD.isSelected();
    }

    public boolean isTextureSelected() {
        return this.cbTexture.isSelected();
    }

    public int getClassColumn() {
        if (this.cbClass.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbClass.getSelectedIndex() - 1;
    }

    public int getClassColumnSize() {
        if (this.cbClass.getSelectedIndex() < 0) {
            return -1;
        }
        return this.cbClass.getItemCount() - 2;
    }

    public void razClasse() {
        this.cbClass.setSelectedIndex(0);
    }

    public void raz() {
        this.lcl.setActive(false);
        if (this.cbClass.getItemCount() > 0) {
            this.cbClass.setSelectedIndex(0);
            this.cbAssocData.setSelectedIndex(0);
            this.cbForm.setSelectedIndex(0);
            this.cbLabel.setSelectedIndex(0);
        }
        this.lcl.setActive(true);
    }

    public void setClassColor(int numeroClasse) {
        this.cbClass.setSelectedIndex(numeroClasse);
    }

    public void setClassColor(String nomClasse) {
        this.setCb(this.cbClass, nomClasse);
    }

    public void setAssociatedData(String nomClasse) {
        this.setCb(this.cbAssocData, nomClasse);
    }

    protected void setCb(JComboBox cb, String nomClasse) {
        int i = 0;
        while (i < cb.getItemCount() && !cb.getItemAt(i).equals(nomClasse)) {
            ++i;
        }
        if (i < cb.getItemCount()) {
            cb.setSelectedIndex(i);
        }
    }

    public void setColorEnabled(boolean b) {
        this.cbColor.setEnabled(b);
    }

    public void setMulticlassVisible(boolean multi) {
        int nbi;
        if (multi && (nbi = this.cbClass.getItemCount()) > 0) {
            --nbi;
            DefaultListModel dlm = new DefaultListModel();
            int i = 1;
            while (i < nbi) {
                dlm.addElement(this.cbClass.getItemAt(i));
                ++i;
            }
            this.jlMulticlass.setModel(dlm);
        }
        this.mcl.setActive(multi);
        this.lMultiClass.setVisible(multi);
        this.jspMulticlass.setVisible(multi);
        this.validate();
    }

    public void setMultiClass(int[] indices) {
        this.mcl.setActive(false);
        if (indices == null) {
            this.jlMulticlass.clearSelection();
        } else {
            this.jlMulticlass.setSelectedIndices(indices);
        }
        this.mcl.setActive(true);
    }

    public void attributsComp(String nomFonction, String nomParametre) {
        nomFonction = nomFonction.substring(3);
        int index = -1;
        if (nomFonction.equals(Messages.getString("tpgva_class"))) {
            int compteur = 0;
            while (compteur < this.cbClass.getItemCount()) {
                if (this.cbClass.getItemAt(compteur).equals(nomParametre)) {
                    index = compteur;
                }
                ++compteur;
            }
            this.cbClass.setSelectedIndex(index);
        } else if (nomFonction.equals(Messages.getString("tpgva_assocdata"))) {
            int compteur = 0;
            while (compteur < this.cbAssocData.getItemCount()) {
                if (this.cbAssocData.getItemAt(compteur).equals(nomParametre)) {
                    index = compteur;
                }
                ++compteur;
            }
            this.cbAssocData.setSelectedIndex(index);
        } else if (nomFonction.equals(Messages.getString("tpgva_label"))) {
            int compteur = 0;
            while (compteur < this.cbLabel.getItemCount()) {
                if (this.cbLabel.getItemAt(compteur).equals(nomParametre)) {
                    index = compteur;
                }
                ++compteur;
            }
            this.cbLabel.setSelectedIndex(index);
        } else if (nomFonction.equals(Messages.getString("tpgva_form"))) {
            int compteur = 0;
            while (compteur < this.cbForm.getItemCount()) {
                if (this.cbForm.getItemAt(compteur).equals(nomParametre)) {
                    index = compteur;
                }
                ++compteur;
            }
            this.cbForm.setSelectedIndex(index);
        } else if (nomFonction.equals(Messages.getString("tpgva_color"))) {
            int compteur = 0;
            while (compteur < this.cbColor.getItemCount()) {
                if (this.cbColor.getItemAt(compteur).equals(nomParametre)) {
                    index = compteur;
                }
                ++compteur;
            }
            this.cbColor.setSelectedIndex(index);
        }
    }

    public int[] getMulticlassColumns() {
        return this.jlMulticlass.getSelectedIndices();
    }

    class MulticlassListener
    implements ListSelectionListener {
        boolean active = true;

        MulticlassListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.active && !e.getValueIsAdjusting()) {
                ICVVisualAttributes.this.vat.multiClassChanged();
            }
        }

        public void setActive(boolean b) {
            this.active = b;
        }
    }

    class componentChangeTPGVisuAff
    implements ActionListener {
        boolean active = true;

        componentChangeTPGVisuAff() {
        }

        public void setActive(boolean b) {
            this.active = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.active) {
                return;
            }
            Object source = e.getSource();
            if (source == ICVVisualAttributes.this.cbForm) {
                ICVVisualAttributes.this.vat.formChanged();
            } else if (source == ICVVisualAttributes.this.cbColor) {
                ICVVisualAttributes.this.vat.colorChanged();
            } else if (source == ICVVisualAttributes.this.cbLabel) {
                ICVVisualAttributes.this.vat.labelChanged();
            } else if (source == ICVVisualAttributes.this.cbAssocData || source == ICVVisualAttributes.this.cbViewSpecAD) {
                ICVVisualAttributes.this.vat.assocDataChanged();
            } else if (source == ICVVisualAttributes.this.cbClass) {
                ICVVisualAttributes.this.vat.classChanged();
            } else if (source == ICVVisualAttributes.this.cbTexture) {
                ICVVisualAttributes.this.vat.textureChanged();
            }
        }
    }
}

