/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.classification;

import explorer.compute.tools.classification.ClassifTool;
import explorer.compute.tools.classification.OutilsClassifDBScan;
import explorer.windows.w2D.icview.classification.ClassificationView;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class DBScanView
extends ClassificationView {
    protected OutilsClassifDBScan control;
    protected int minPts;
    protected float rayon;
    protected JLabel JlMinPts;
    protected JTextField JtfMinPts;
    protected JButton JbValid;
    protected JSlider jsRadius;
    protected JLabel lJC;
    private JPDSChangeListener jpdsl = null;
    private KmdListener kmdl;

    public DBScanView(OutilsClassifDBScan t) {
        super(t, Messages.getString("tpgclassif_dbscan"));
    }

    @Override
    protected void init() {
        this.kmdl = new KmdListener();
        this.jpdsl = new JPDSChangeListener();
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        this.JlMinPts = new JLabel(Messages.getString("dbscan_minpts"));
        panel.add(this.JlMinPts);
        this.JtfMinPts = new JTextField(3);
        this.JtfMinPts.setText(new String("" + this.minPts));
        this.JtfMinPts.addActionListener(this.kmdl);
        panel.add(this.JtfMinPts);
        this.add(panel);
        panel = new JPanel();
        this.lJC = new JLabel(String.valueOf(Messages.getString("tpgcrop_radius")) + ":");
        panel.add(this.lJC);
        this.jsRadius = new JSlider(1, 50, 12);
        this.jsRadius.addChangeListener(this.jpdsl);
        panel.add(this.jsRadius);
        this.add(panel);
        this.JbValid = new JButton(Messages.getString("kmd_compute"));
        this.JbValid.addActionListener(this.kmdl);
        this.JbValid.setAlignmentX(0.0f);
        this.add(this.JbValid);
        JLabel lNoiseClass = new JLabel(Messages.getString("dbscan_noise_class"));
        lNoiseClass.setFont(new Font("SansSerif", 2, 12));
        this.add(lNoiseClass);
    }

    @Override
    protected void setControl(ClassifTool t) {
        this.control = (OutilsClassifDBScan)t;
    }

    @Override
    protected ClassifTool getControl() {
        return this.control;
    }

    public void setRadius(float r) {
        this.jpdsl.setActive(false);
        this.jsRadius.setValue((int)(r * 100.0f));
        this.jpdsl.setActive(true);
    }

    public void setMinPts(int pts) {
        this.kmdl.setActive(false);
        this.JtfMinPts.setText("" + pts);
        this.kmdl.setActive(true);
    }

    class JPDSChangeListener
    implements ChangeListener {
        private boolean active = true;

        JPDSChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source;
            if (this.active && (source = e.getSource()) == DBScanView.this.jsRadius) {
                DBScanView.this.rayon = (float)DBScanView.this.jsRadius.getValue() / 100.0f;
                DBScanView.this.control.resizeSphere(DBScanView.this.rayon);
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    class KmdListener
    implements ActionListener {
        private boolean active = true;

        KmdListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source;
            if (this.active && ((source = e.getSource()) == DBScanView.this.JtfMinPts || source == DBScanView.this.JbValid)) {
                try {
                    DBScanView.this.minPts = Integer.parseInt(DBScanView.this.JtfMinPts.getText());
                    DBScanView.this.rayon = (float)DBScanView.this.jsRadius.getValue() / 100.0f;
                    DBScanView.this.control.afficherDBScan(DBScanView.this.minPts, DBScanView.this.rayon);
                }
                catch (NumberFormatException nbe) {
                    System.out.println("Valeur invalide");
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

