/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.classification;

import explorer.compute.tools.classification.ClassificationTools;
import explorer.windows.w2D.icview.classification.ClassificationView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import lib3d4j.international.Messages;

public class ICVClassification
extends JPanel {
    private Map<String, ClassificationView> subviews = new HashMap<String, ClassificationView>();
    protected JComboBox cbClassif;
    protected ClassificationTools control = null;
    private CBClassifActionListener al = null;

    public ICVClassification(ClassificationTools t) {
        this.control = t;
        this.setName(Messages.getString("tpgclassif_title"));
        this.setLayout(new BoxLayout(this, 1));
        this.al = new CBClassifActionListener();
        this.cbClassif = new JComboBox();
        this.cbClassif.addActionListener(this.al);
        this.add(this.cbClassif);
        this.control.setICView(this);
    }

    public void addMethod(ClassificationView method) {
        this.subviews.put(method.getName(), method);
        this.al.setActive(false);
        this.cbClassif.addItem(method.getName());
        this.cbClassif.setMaximumSize(this.cbClassif.getPreferredSize());
        this.al.setActive(true);
        this.add(method);
    }

    public ClassificationView getSelectedMethod() {
        return this.subviews.get(this.cbClassif.getSelectedItem());
    }

    class CBClassifActionListener
    implements ActionListener {
        private boolean active = true;

        CBClassifActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.active) {
                ICVClassification.this.control.methodChanged();
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

