/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.constrained;

import explorer.compute.tools.PCTool;
import explorer.data.DataManager;
import explorer.windows.w2D.SwingUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class ICVComparison
extends JPanel {
    protected Vector<String> v;
    protected Vector<String> v2;
    protected JComboBox element1;
    protected JComboBox element2;
    protected JButton valider;
    protected JSlider jScomp;
    protected JLabel sous_titre;
    protected JLabel avant;
    protected JLabel apres;
    protected JLabel liste;
    protected float distanceAv = 0.0f;
    protected float distanceAp = 0.0f;
    protected float indiceComp;
    protected float index1x;
    protected float index1y;
    protected float index1z;
    protected float index2x;
    protected float index2y;
    protected float index2z;
    protected float nouvelleDistance = 0.0f;
    protected JRadioButton choixAPlan3D;
    protected JRadioButton choixBPlan3D;
    protected Boolean aChoisi = false;
    protected Boolean bChoisi = false;
    protected Boolean maj = false;
    protected int index1 = 0;
    protected int index2 = 0;
    protected int nbComparaisons = 0;
    protected int valeurInit = 0;
    protected PCTool pct;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private CBActionListener alc = null;

    public ICVComparison(PCTool c) {
        this.pct = c;
        this.setName(Messages.getString("tpgcomp_title"));
        this.setLayout(new BoxLayout(this, 1));
        this.alc = new CBActionListener();
        JPanel jp = new JPanel(new GridLayout(-1, 2));
        this.choixAPlan3D = new JRadioButton(Messages.getString("tpgcomp_ObjetA"), false);
        this.choixAPlan3D.addMouseListener(new mouseClickJCB3D());
        jp.add(this.choixAPlan3D);
        this.element1 = new JComboBox();
        this.element1.addActionListener(this.alc);
        jp.add(this.element1);
        this.choixBPlan3D = new JRadioButton(Messages.getString("tpgcomp_ObjetB"), false);
        this.choixBPlan3D.addMouseListener(new mouseClickJCB3D());
        jp.add(this.choixBPlan3D);
        ButtonGroup group = new ButtonGroup();
        group.add(this.choixAPlan3D);
        group.add(this.choixBPlan3D);
        this.element2 = new JComboBox();
        this.element2.addActionListener(this.alc);
        jp.add(this.element2);
        this.add(jp);
        this.sous_titre = new JLabel(String.valueOf(Messages.getString("tpgcomp_dist")) + ":");
        this.sous_titre.setBackground(this.getBackground());
        this.add(this.sous_titre);
        this.avant = new JLabel(String.valueOf(Messages.getString("tpgcomp_avant")) + " : " + this.distanceAv);
        this.avant.setBackground(this.getBackground());
        this.add(this.avant);
        this.apres = new JLabel(String.valueOf(Messages.getString("tpgcomp_apres")) + " : " + this.distanceAp);
        this.apres.setBackground(this.getBackground());
        this.add(this.apres);
        this.jScomp = new JSlider(0, 100, 1);
        this.jScomp.setMajorTickSpacing(50);
        this.jScomp.setMinorTickSpacing(5);
        this.jScomp.setPaintTicks(true);
        this.jScomp.setPaintLabels(true);
        this.jScomp.setMaximumSize(this.jScomp.getPreferredSize());
        this.add(this.jScomp);
        this.valider = new JButton(Messages.getString("tpgcomp_valider"));
        this.valider.addMouseListener(new validerclick());
        this.add(this.valider);
        SwingUtils.alignX(this, 0.0f);
        this.pct.setComp(this);
    }

    public int getA() {
        return this.element1.getSelectedIndex();
    }

    public int getB() {
        return this.element2.getSelectedIndex();
    }

    public String getRate() {
        return String.valueOf(this.jScomp.getValue() > this.valeurInit ? " > " : " < ") + this.nouvelleDistance;
    }

    public void addComparison(String comp) {
    }

    public void addComparisons(List<String> lst) {
    }

    public void clickedObject(int index) {
        if (this.isShowing()) {
            if (this.aChoisi.booleanValue()) {
                this.element1.setSelectedIndex(index);
            } else if (this.bChoisi.booleanValue()) {
                this.element2.setSelectedIndex(index);
            }
            this.repaint();
        }
    }

    public void maj() {
        this.alc.setEnabled(false);
        this.element1.removeAllItems();
        this.element2.removeAllItems();
        int i = 0;
        while (i < this.dd.getNbDescrObjects()) {
            String label = "n\u00b0 " + i + " : " + (String)this.dd.getLabelValue(i);
            this.element1.addItem(label);
            this.element2.addItem(label);
            ++i;
        }
        this.element1.setSelectedIndex(-1);
        this.element2.setSelectedIndex(-1);
        this.element1.setMaximumSize(this.element1.getPreferredSize());
        this.element2.setMaximumSize(this.element2.getPreferredSize());
        this.alc.setEnabled(true);
    }

    public void setDistances(float dav, float dap) {
        this.distanceAv = dav;
        this.distanceAp = dap;
        this.indiceComp = this.distanceAp * 100.0f / this.distanceAv;
        this.avant.setText(String.valueOf(Messages.getString("tpgcomp_avant")) + " : " + this.distanceAv);
        this.apres.setText(String.valueOf(Messages.getString("tpgcomp_apres")) + " : " + this.distanceAp);
        this.jScomp.setValue((int)this.indiceComp);
        this.valeurInit = (int)this.indiceComp;
    }

    class CBActionListener
    implements ActionListener {
        boolean enabled = true;

        CBActionListener() {
        }

        public void setEnabled(boolean e) {
            this.enabled = e;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                ICVComparison.this.pct.buildComparison();
            }
        }
    }

    class mouseClickJCB3D
    extends MouseAdapter {
        mouseClickJCB3D() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ICVComparison.this.aChoisi = ICVComparison.this.choixAPlan3D.isSelected();
            ICVComparison.this.bChoisi = ICVComparison.this.choixBPlan3D.isSelected();
        }
    }

    class validerclick
    extends MouseAdapter {
        validerclick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ICVComparison.this.nouvelleDistance = (float)ICVComparison.this.jScomp.getValue() * (ICVComparison.this.distanceAv / 100.0f);
            ICVComparison.this.pct.addComparison();
        }
    }
}

