/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.kernels;

import explorer.compute.tools.kernels.KernelTool;
import explorer.windows.w2D.SwingUtils;
import explorer.windows.w2D.icview.kernels.KernelView;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OneParameterKernelView
extends KernelView {
    private JLabel jlParam;
    private JSpinner jsParam;

    public OneParameterKernelView(String s, KernelTool t) {
        super(s, t);
    }

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.jlParam = new JLabel();
        this.jsParam = new JSpinner();
        this.jsParam.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OneParameterKernelView.this.getControl().paramChanged();
            }
        });
        this.jsParam.setMaximumSize(this.jsParam.getPreferredSize());
        this.add(this.jsParam);
        SwingUtils.alignX(this, 0.0f);
    }

    public void setParamBounds(int min, int max) {
        this.jsParam.setModel(new SpinnerNumberModel(this.getParam(), min, max, 1));
        this.jsParam.setMaximumSize(this.jsParam.getPreferredSize());
    }

    public void setParamName(String s) {
        this.jlParam.setText(s);
    }

    public void setParam(int p) {
        this.jsParam.setValue(p);
    }

    public int getParam() {
        return ((SpinnerNumberModel)this.jsParam.getModel()).getNumber().intValue();
    }
}

