/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.icview.kernels;

import explorer.compute.tools.kernels.KernelTool;
import explorer.windows.w2D.SwingUtils;
import explorer.windows.w2D.icview.kernels.KernelView;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TwoParametersKernelView
extends KernelView {
    private JLabel[] jlParam;
    private JSpinner[] jsParam;

    public TwoParametersKernelView(String s, KernelTool t) {
        super(s, t);
    }

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.jlParam = new JLabel[2];
        this.jsParam = new JSpinner[2];
        int i = 0;
        while (i < 2) {
            this.jlParam[i] = new JLabel();
            this.jsParam[i] = new JSpinner();
            this.jsParam[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TwoParametersKernelView.this.getControl().paramChanged();
                }
            });
            this.jsParam[i].setMaximumSize(this.jsParam[i].getPreferredSize());
            this.add(this.jsParam[i]);
            ++i;
        }
        SwingUtils.alignX(this, 0.0f);
    }

    public void setParamBounds(int rank, int min, int max) {
        this.jsParam[rank].setModel(new SpinnerNumberModel(this.getParam(rank), min, max, 1));
        this.jsParam[rank].setMaximumSize(this.jsParam[rank].getPreferredSize());
    }

    public void setParamName(int rank, String s) {
        this.jlParam[rank].setText(s);
    }

    public void setParam(int rank, int p) {
        this.jsParam[rank].setValue(p);
    }

    public int getParam(int rank) {
        return ((SpinnerNumberModel)this.jsParam[rank].getModel()).getNumber().intValue();
    }
}

