/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.jTaskPaneGroup;

import explorer.compute.classification.KMean;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.windows.w2D.SwingUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;

public class ICVStables
extends JPanel {
    public static int DEF_NB_CLASS = 5;
    public static int DEF_NB_STEPS = 20;
    public static int DEF_NB_RUN = 5;
    protected JLabel JlNbClasses;
    protected JTextField JtfNbClasses;
    protected JLabel JlNbRuns;
    protected JTextField JtfNbRuns;
    protected JButton JbValid;
    protected Common parent;
    int nbclasses = DEF_NB_CLASS;
    int nbRuns = DEF_NB_RUN;
    int[] ancienRun = null;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public ICVStables(Common c) {
        this.setName(Messages.getString("tpgstables_title"));
        this.parent = c;
        StablesListener stablel = new StablesListener();
        this.setLayout(new BoxLayout(this, 1));
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        this.JlNbClasses = new JLabel(Messages.getString("tpgstables_nbclasses"));
        left.add(this.JlNbClasses);
        this.JtfNbClasses = new JTextField(3);
        this.JtfNbClasses.setText(new String("" + this.nbclasses));
        this.JtfNbClasses.addActionListener(stablel);
        right.add(this.JtfNbClasses);
        this.JlNbRuns = new JLabel(Messages.getString("tpgstables_nbruns"));
        left.add(this.JlNbRuns);
        this.JtfNbRuns = new JTextField(3);
        this.JtfNbRuns.setText(new String("" + this.nbRuns));
        this.JtfNbRuns.addActionListener(stablel);
        right.add(this.JtfNbRuns);
        JPanel jp = new JPanel();
        SwingUtils.setTwoColsLayout(jp, left, right);
        this.add(jp);
        this.JbValid = new JButton(Messages.getString("tpgstables_compute"));
        this.JbValid.addActionListener(stablel);
        this.add(this.JbValid);
    }

    public void afficher(int nbclasse, int nbr) {
        this.nbclasses = nbclasse;
        this.nbRuns = nbr;
        KMean km = new KMean(this.parent.f3d.getPoints(), this.nbclasses);
        int i = 0;
        while (i < this.nbRuns) {
            km.compute(DEF_NB_STEPS);
            this.newRun(km.getClasses());
            ++i;
        }
        this.ajusterClasses();
        int nbc = this.nombreClasses();
        float[] fres = new float[this.ancienRun.length];
        int i2 = 0;
        while (i2 < this.ancienRun.length) {
            fres[i2] = this.ancienRun[i2];
            ++i2;
        }
        Vector<Object> classes = new Vector<Object>();
        int i3 = 0;
        while (i3 < nbc) {
            classes.add("" + (i3 + 1));
            ++i3;
        }
        this.dd.dropColumn("AUTO_STABLES");
        this.dd.addColumn(fres, classes, "AUTO_STABLES");
        DataManager.getSingleton().setClassAttribute("AUTO_STABLES");
        DataManager.getSingleton().setColorAttribute("AUTO_STABLES");
        this.ancienRun = null;
    }

    private int nombreClasses() {
        int max = 0;
        int i = 0;
        while (i < this.ancienRun.length) {
            if (max < this.ancienRun[i]) {
                max = this.ancienRun[i];
            }
            ++i;
        }
        return max + 1;
    }

    private void ajusterClasses() {
        boolean[] range = new boolean[this.ancienRun.length];
        int[] newtab = new int[this.ancienRun.length];
        int c = 1;
        int i = 0;
        while (i < this.ancienRun.length) {
            if (!range[i]) {
                int j = i + 1;
                while (j < this.ancienRun.length) {
                    if (this.ancienRun[i] == this.ancienRun[j] && !range[j]) {
                        if (!range[i]) {
                            newtab[i] = c;
                            range[i] = true;
                        }
                        newtab[j] = c;
                        range[j] = true;
                    }
                    ++j;
                }
                if (!range[i]) {
                    newtab[i] = 0;
                    range[i] = true;
                } else {
                    ++c;
                }
            }
            ++i;
        }
        this.ancienRun = (int[])newtab.clone();
    }

    private void newRun(int[] ks) {
        if (this.ancienRun == null) {
            this.ancienRun = ks;
        } else {
            int classeEnCours = 0;
            int[] nextRun = new int[ks.length];
            boolean[] ajout = new boolean[ks.length];
            int i = 0;
            while (i < ks.length) {
                if (!ajout[i]) {
                    ArrayList<Integer> ancienVoisins = this.getVoisin(this.ancienRun, this.ancienRun[i]);
                    int j = 0;
                    while (j < ancienVoisins.size()) {
                        if (ks[ancienVoisins.get(j)] == ks[i] && ancienVoisins.get(j) != i) {
                            nextRun[i] = classeEnCours;
                            nextRun[ancienVoisins.get((int)j).intValue()] = classeEnCours;
                            ajout[ancienVoisins.get((int)j).intValue()] = true;
                            ajout[i] = true;
                        }
                        ++j;
                    }
                    if (!ajout[i]) {
                        nextRun[i] = classeEnCours;
                        ajout[i] = true;
                    }
                    ++classeEnCours;
                }
                ++i;
            }
        }
    }

    private ArrayList<Integer> getVoisin(int[] run, int classe) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        int i = 0;
        while (i < run.length) {
            if (run[i] == classe) {
                al.add(i);
            }
            ++i;
        }
        return al;
    }

    class StablesListener
    implements ActionListener {
        StablesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ICVStables.this.JtfNbClasses || source == ICVStables.this.JtfNbRuns || source == ICVStables.this.JbValid) {
                try {
                    int nbc = Integer.parseInt(ICVStables.this.JtfNbClasses.getText());
                    int nbr = Integer.parseInt(ICVStables.this.JtfNbRuns.getText());
                    ICVStables.this.afficher(nbc, nbr);
                }
                catch (NumberFormatException nbe) {
                    System.out.println("Valeur invalide");
                }
            }
        }
    }
}

