/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.data.SourceDist;
import explorer.data.ViewManager;
import explorer.windows.w2D.utils.GView;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lib3d4j.data.Source;

public class Courbes2D
extends JFrame
implements GView {
    public static final int HISTOGRAM = 1;
    public static final int SHEPARD = 2;
    public static final int SHEPARDS = 3;
    public static final int PLOT2DS = 4;
    public static final int PLOT2D = 5;
    public static final int CONTRIB = 6;
    public static final int SQUARECOS = 7;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH = 820;
    private static final int DEFAULT_HEIGHT = 550;
    private JPanel general;
    private Graphique grap;
    private String title;
    private int mode;
    private double[] iv;
    private float[][] tab;
    private float[][] shep;
    private float stress;
    private float max0;
    private float max1;
    private float[] val;
    private String[] noms = null;
    private int taille;
    private ProjectiveMethod pm = null;
    private Projection proj = null;

    private void init() {
        this.init(820, 550);
    }

    private void init(int x, int y) {
        this.setVisible(true);
        Graphics g = this.getGraphics();
        this.paintAll(g);
        this.setSize(x, y);
        this.setLocation(350, 200);
        this.setTitle(this.title);
        this.grap = new Graphique();
        this.general = new JPanel();
        this.general.setLayout(new BorderLayout());
        this.general.add((Component)this.grap, "Center");
        this.setContentPane(this.general);
    }

    public Courbes2D(String titre, Projection p) {
        this.setFocusableWindowState(false);
        this.title = titre;
        this.proj = p;
        this.pm = p.getProjectiveMethod();
        this.addWindowListener(new C2DWindowListener(this));
        ViewManager.getSingleton().addView(this);
    }

    public Courbes2D(String titre, int model, double[] tabl, Projection p) {
        this(titre, p);
        this.title = titre;
        this.mode = model;
        this.iv = tabl;
        this.init();
    }

    public Courbes2D(String titre, int model, float[][] tt, Projection p) {
        this(titre, p);
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.init();
    }

    public Courbes2D(String titre, int model, float[][] tt, String[] lesnoms, Projection p) {
        this(titre, p);
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.noms = lesnoms;
        this.init();
    }

    public Courbes2D(String titre, int model, float[][] tt, SourceDist datDist, Projection p) {
        this(titre, p);
        int n = 0;
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.taille = tt.length;
        this.taille = (this.taille - 1) * this.taille / 2;
        this.shep = new float[this.taille][2];
        this.stress = 0.0f;
        this.max0 = 0.0f;
        this.max1 = 0.0f;
        int i = 0;
        while (i < tt.length) {
            int j = i + 1;
            while (j < tt.length) {
                int ri = i;
                int rj = j;
                this.shep[n][0] = 0.0f;
                int k = 0;
                while (k < 3) {
                    float[] fArray = this.shep[n];
                    fArray[0] = fArray[0] + (this.tab[i][k] - this.tab[j][k]) * (this.tab[i][k] - this.tab[j][k]);
                    ++k;
                }
                double dd = this.shep[n][0];
                this.shep[n][0] = (float)Math.sqrt(dd);
                if (this.shep[n][0] > this.max0) {
                    this.max0 = this.shep[n][0];
                }
                this.shep[n][1] = datDist.getValue(ri, rj);
                if (this.shep[n][1] > this.max1) {
                    this.max1 = this.shep[n][1];
                }
                dd = (double)(this.shep[n][0] - this.shep[n][1]) * (double)(this.shep[n][0] - this.shep[n][1]);
                ++n;
                this.stress = (float)((double)this.stress + dd);
                ++j;
            }
            ++i;
        }
        this.stress += (float)Math.sqrt(this.stress);
        this.init();
    }

    public Courbes2D(String titre, int model, float[][] tt, float[] datDist, Projection p) {
        this(titre, p);
        int n = 0;
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.taille = tt.length;
        this.shep = new float[this.taille][2];
        this.stress = 0.0f;
        this.max0 = 0.0f;
        this.max1 = 0.0f;
        int i = 0;
        while (i < tt.length) {
            this.shep[n][0] = 0.0f;
            int k = 0;
            while (k < 3) {
                float[] fArray = this.shep[n];
                fArray[0] = fArray[0] + this.tab[i][k] * this.tab[i][k];
                ++k;
            }
            double dd = this.shep[n][0];
            this.shep[n][0] = (float)Math.sqrt(dd);
            if (this.shep[n][0] > this.max0) {
                this.max0 = this.shep[n][0];
            }
            this.shep[n][1] = datDist[n];
            if (this.shep[n][1] > this.max1) {
                this.max1 = this.shep[n][1];
            }
            dd = (double)(this.shep[n][0] - this.shep[n][1]) * (double)(this.shep[n][0] - this.shep[n][1]);
            ++n;
            this.stress = (float)((double)this.stress + dd);
            ++i;
        }
        this.stress += (float)Math.sqrt(this.stress);
        this.init();
    }

    public Courbes2D(String titre, int model, float[][] tt, double lambda, String[] lesnoms, int ind, Projection p) {
        this(titre, p);
        float lambd = (float)lambda;
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.taille = tt.length;
        this.val = new float[this.taille];
        this.noms = new String[this.taille];
        int i = 0;
        while (i < this.taille) {
            this.val[i] = tt[i][ind] * tt[i][ind] / lambd;
            this.noms[i] = lesnoms[i];
            ++i;
        }
        i = 0;
        while (i < this.taille - 1) {
            int im = i;
            int j = i + 1;
            while (j < this.taille) {
                if (this.val[j] > this.val[im]) {
                    im = j;
                }
                ++j;
            }
            float tf = this.val[i];
            this.val[i] = this.val[im];
            this.val[im] = tf;
            String ts = this.noms[i];
            this.noms[i] = this.noms[im];
            this.noms[im] = ts;
            ++i;
        }
        this.init(820, 650);
    }

    public Courbes2D(String titre, int model, float[][] tt, float[] dist, String[] lesnoms, int ind, Projection p) {
        this(titre, p);
        this.title = titre;
        this.mode = model;
        this.tab = tt;
        this.taille = tt.length;
        this.val = new float[this.taille];
        this.noms = new String[this.taille];
        int i = 0;
        while (i < this.taille) {
            this.val[i] = tt[i][ind] * tt[i][ind] / (dist[i] * dist[i]);
            this.noms[i] = lesnoms[i];
            ++i;
        }
        i = 0;
        while (i < this.taille - 1) {
            int im = i;
            int j = i + 1;
            while (j < this.taille) {
                if (this.val[j] > this.val[im]) {
                    im = j;
                }
                ++j;
            }
            float tf = this.val[i];
            this.val[i] = this.val[im];
            this.val[im] = tf;
            String ts = this.noms[i];
            this.noms[i] = this.noms[im];
            this.noms[im] = ts;
            ++i;
        }
        this.init(820, 650);
    }

    public void dessine() {
        switch (this.mode) {
            case 1: {
                this.dessine_histo();
                break;
            }
            case 5: {
                this.dessine_plot2D(true);
                break;
            }
            case 4: {
                this.dessine_plot2D(false);
                break;
            }
            case 2: 
            case 3: {
                this.dessine_Shepard();
                break;
            }
            case 6: {
                this.dessine_contrib(false);
                break;
            }
            case 7: {
                this.dessine_contrib(true);
            }
        }
        this.validate();
    }

    private String simplif(double v) {
        int i = (int)(v * 100.0);
        int ii = i / 100;
        int jj = i - 100 * ii;
        if (jj < 10) {
            return ii + ".0" + jj;
        }
        return ii + "." + jj;
    }

    private void dessine_histo() {
        Graphics g = this.grap.getGraphics();
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(new Color(0.0f, 0.0f, 1.0f));
        g.drawString(this.title, 400, 20);
        g.drawLine(10, 480, 790, 480);
        g.drawLine(785, 477, 790, 480);
        g.drawLine(785, 483, 790, 480);
        g.drawLine(20, 30, 17, 35);
        g.drawLine(20, 30, 23, 35);
        g.drawLine(20, 30, 20, 490);
        int k = 0;
        double maxi = this.iv[0];
        int i = 0;
        while (i <= 50) {
            if (i < this.iv.length) {
                g.fillRect(30 + 15 * k, 480 - (int)(this.iv[i] * 450.0 / maxi), 12, (int)(this.iv[i] * 450.0 / maxi));
                ++k;
            }
            ++i;
        }
        k = 0;
        AffineTransform aT = new AffineTransform();
        aT.rotate(-0.7854);
        Font f2 = new Font("Arial", 1, 10);
        Font f = f2.deriveFont(aT);
        g.setFont(f2);
        g.setColor(Color.blue);
        g.setColor(new Color(0.5f, 0.0f, 0.1f));
        i = 0;
        while (i <= 50) {
            if (i < this.iv.length) {
                if (k > 0) {
                    g.setFont(f);
                }
                if (k == 0) {
                    g.drawString(this.simplif(this.iv[i]), 45 + 15 * k, 478 - (int)(this.iv[i] * 450.0 / maxi));
                } else {
                    g.drawString(this.simplif(this.iv[i]), 38 + 15 * k, 478 - (int)(this.iv[i] * 450.0 / maxi));
                }
                ++k;
            }
            ++i;
        }
    }

    private void dessine_contrib(boolean unite) {
        Graphics g = this.grap.getGraphics();
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(new Color(0.0f, 0.0f, 1.0f));
        g.drawString(this.title, 400, 20);
        g.drawLine(10, 580, 790, 580);
        g.drawLine(785, 577, 790, 580);
        g.drawLine(785, 583, 790, 580);
        g.drawLine(20, 30, 17, 35);
        g.drawLine(20, 30, 23, 35);
        g.drawLine(20, 30, 20, 590);
        if (unite) {
            g.setColor(new Color(1.0f, 0.0f, 0.0f));
            g.drawLine(20, 580 - (int)(350.0 / (double)this.val[0]), 790, 580 - (int)(350.0 / (double)this.val[0]));
            g.setColor(new Color(0.0f, 0.0f, 1.0f));
        }
        int j = this.taille;
        int k = 0;
        double maxi = this.val[0];
        int i = 0;
        while (i < j) {
            if (i < 50) {
                g.fillRect(30 + 15 * k, 580 - (int)((double)this.val[i] * 350.0 / maxi), 12, (int)((double)this.val[i] * 350.0 / maxi));
                ++k;
            }
            ++i;
        }
        k = 0;
        AffineTransform aT = new AffineTransform();
        aT.rotate(-0.7854);
        Font f2 = new Font("Arial", 1, 10);
        Font f = f2.deriveFont(aT);
        g.setFont(f2);
        g.setColor(Color.blue);
        g.setColor(new Color(0.5f, 0.0f, 0.1f));
        g.setFont(f);
        i = 0;
        while (i < j) {
            if (i < 50) {
                g.drawString(String.valueOf(this.noms[i]) + "(" + this.val[i] + ")", 38 + 15 * k, 578 - (int)((double)this.val[i] * 350.0 / maxi));
                ++k;
            }
            ++i;
        }
    }

    private void dessine_plot2D(boolean lab) {
        Graphics g = this.grap.getGraphics();
        int nb = this.tab.length;
        float xm = this.tab[0][0];
        float xM = this.tab[0][0];
        float ym = this.tab[0][1];
        float yM = this.tab[0][1];
        int i = 1;
        while (i < nb) {
            if (this.tab[i][0] < xm) {
                xm = this.tab[i][0];
            }
            if (this.tab[i][0] > xM) {
                xM = this.tab[i][0];
            }
            if (this.tab[i][1] < ym) {
                ym = this.tab[i][1];
            }
            if (this.tab[i][1] > yM) {
                yM = this.tab[i][1];
            }
            ++i;
        }
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(new Color(0.0f, 0.0f, 1.0f));
        g.drawString(this.title, 600, 20);
        g.setColor(new Color(0.0f, 0.0f, 0.0f));
        g.drawLine(10, 250, 790, 250);
        g.drawLine(785, 247, 790, 250);
        g.drawLine(785, 253, 790, 250);
        g.drawLine(400, 30, 397, 35);
        g.drawLine(400, 30, 403, 35);
        g.drawLine(400, 30, 400, 490);
        i = 0;
        while (i < nb) {
            int x = 25 + (int)((this.tab[i][0] - xm) / (xM - xm) * 750.0f);
            int y = 20 + (int)((this.tab[i][1] - ym) / (yM - ym) * 460.0f);
            if (lab) {
                if (this.noms == null) {
                    g.drawString("" + i, x + 3, y + 3);
                    g.drawLine(x - 3, y, x + 3, y);
                    g.drawLine(x, y - 3, x, y + 3);
                } else {
                    g.drawString(this.noms[i], x + 3, y + 3);
                }
            }
            ++i;
        }
    }

    private void dessine_Shepard() {
        Graphics g = this.grap.getGraphics();
        int ty = (int)this.getSize().getHeight() - 48;
        int tx = (int)this.getSize().getWidth() - 31;
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(new Color(0.0f, 0.0f, 0.0f));
        g.drawString(this.title, 40 + tx / 4, 40);
        g.drawLine(10, 10, tx + 10, 10);
        g.drawLine(tx + 10, 10, tx + 10, ty + 10);
        g.drawLine(tx + 10, ty + 10, 10, ty + 10);
        g.drawLine(10, ty + 10, 10, 10);
        g.drawLine(10, ty + 10, tx + 10, 10);
        if (tx > 20 && ty > 20) {
            int i = 0;
            while (i < this.shep.length) {
                int x = 10 + (int)((float)tx * (this.shep[i][1] / this.max1));
                int y = ty + 10 - (int)((float)ty * (this.shep[i][0] / this.max0));
                g.drawLine(x - 1, y, x + 1, y);
                g.drawLine(x, y - 1, x, y + 1);
                ++i;
            }
        }
    }

    @Override
    public ProjectiveMethod getProjectiveMethod() {
        return this.pm;
    }

    @Override
    public Source getSource() {
        return this.pm.getSource();
    }

    @Override
    public String toString() {
        return this.title;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public Projection getProjection() {
        return this.proj;
    }

    class C2DWindowListener
    extends WindowAdapter {
        Courbes2D parent = null;

        public C2DWindowListener(Courbes2D p) {
            this.parent = p;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ViewManager.getSingleton().removeView(this.parent);
        }
    }

    class Graphique
    extends Canvas {
        private static final long serialVersionUID = 1L;

        public Graphique() {
            this.setBackground(Color.white);
        }

        @Override
        public void paint(Graphics g) {
            Courbes2D.this.dessine();
        }
    }
}

