/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.utils.DragableImagePanel;
import explorer.windows.w2D.utils.InterImagePanel;
import explorer.windows.w2D.utils.SubsetExplorer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lib3d4j.data.Source;
import lib3d4j.display3D.Display;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.display3D.java3D.CentralSelectionObserver;
import lib3d4j.w2d.ImageDisplayerException;
import lib3d4j.w2d.ImagePanel;

public class ImageAndNeighborsPanel
extends JPanel
implements CentralSelectionObserver {
    private CentralSelection cs = CentralSelection.getSingleton();
    private Display display;
    private int id;
    int dim = 150;
    private JPanel jpNbg = null;
    private JPanel jpImg = null;
    private JScrollPane jspNbg = null;
    private ArrayList<ImagePanel> nbg = null;
    private IANPMouseListener ml = null;
    private HashMap<Integer, ImagePanel> hmi = null;
    private SubsetExplorer parent;

    public ImageAndNeighborsPanel(String title, URL dir, String fileName, int id, Display d, SubsetExplorer p) {
        this.cs.reference(this);
        this.parent = p;
        this.display = d;
        this.id = id;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.ml = new IANPMouseListener();
        this.hmi = new HashMap();
        this.createJpImg();
        this.createJpNbg();
        try {
            this.addImage(title, dir, fileName, id, false);
        }
        catch (ImageDisplayerException e) {
            e.printStackTrace();
        }
    }

    private void setAspect() {
        this.jspNbg.setVisible(this.nbg.size() != 0);
    }

    public void addNeighbor(String title, URL dir, String fileName, int id) throws ImageDisplayerException {
        ImagePanel ip = this.addImage(title, dir, fileName, id, true);
        this.nbg.add(ip);
        this.setAspect();
    }

    public void removeLastNeighbor(int nb) {
        int i = 0;
        while (i < nb) {
            ImagePanel ipr = this.nbg.remove(this.nbg.size() - 1);
            this.hmi.remove(ipr.getId());
            ++i;
        }
        this.jpNbg.removeAll();
        for (ImagePanel ip : this.nbg) {
            this.jpNbg.add(ip);
        }
        this.setAspect();
    }

    private void createJpImg() {
        this.jpImg = new JPanel(new BorderLayout());
        this.jpImg.setBackground(Color.green);
        Dimension size = new Dimension(this.dim, this.dim);
        this.jpImg.setPreferredSize(size);
        this.jpImg.setMinimumSize(size);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.jpImg, gbc);
    }

    private void createJpNbg() {
        this.nbg = new ArrayList();
        this.jpNbg = new JPanel(new FlowLayout(3, 2, 0));
        this.jpNbg.setBackground(Color.pink);
        this.jspNbg = new JScrollPane(this.jpNbg, 21, 32);
        Dimension size = new Dimension(4 * this.dim, this.dim + 70);
        this.jspNbg.setPreferredSize(size);
        this.jspNbg.setMinimumSize(size);
        this.jspNbg.setMaximumSize(new Dimension(6 * this.dim, this.dim));
        this.jspNbg.getHorizontalScrollBar().setPreferredSize(new Dimension(100, 15));
        this.jspNbg.setVisible(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        this.add((Component)this.jspNbg, gbc);
    }

    public ImagePanel addImage(String title, URL dir, String fileName, int id, boolean isNbg) throws ImageDisplayerException {
        URL u;
        try {
            u = new URL(String.valueOf(dir.toString()) + Common.getSingleton().getParam().separator + fileName);
        }
        catch (MalformedURLException e) {
            throw new ImageDisplayerException();
        }
        Image image = Toolkit.getDefaultToolkit().getImage(u);
        image = new ImageIcon(image).getImage();
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        float scale = 0.0f;
        scale = isNbg ? (float)(this.dim - 10) / (float)Math.max(w, h) : (float)this.dim / (float)Math.max(w, h);
        w = (int)((float)w * scale);
        h = (int)((float)h * scale);
        DragableImagePanel imagePanel = null;
        if (isNbg) {
            imagePanel = new InterImagePanel(image, w, h, title, id, this.ml, this, fileName);
            this.jpNbg.add(imagePanel);
            this.jpNbg.revalidate();
        } else {
            imagePanel = new DragableImagePanel(image, w, h, title, id, this.ml, fileName);
            this.jpImg.add(imagePanel);
        }
        this.hmi.put(id, imagePanel);
        this.setVisible(true);
        if (this.cs.isSelected(id)) {
            imagePanel.setSelected(true);
        }
        return imagePanel;
    }

    @Override
    public void selectionStateChanged(int index) {
        this.cs.flipState(((DisplayExplorer)this.display).getProjectiveMethod().getSource().getRealIndex(index), this);
    }

    @Override
    public void onSelectionChange() {
        Source src = ((DisplayExplorer)this.display).getProjectiveMethod().getSource();
        boolean[] lesObjetsSelect = this.cs.getSelectStates();
        Set<Integer> s = this.hmi.keySet();
        Iterator<Integer> i = s.iterator();
        while (i.hasNext()) {
            int index = src.getLocalIndex(i.next());
            if (index == -1) continue;
            this.hmi.get(index).setSelected(lesObjetsSelect[index]);
        }
    }

    protected String[] correct(int rg, boolean isRight) {
        return this.parent.addConstraint(this.id, rg, isRight);
    }

    protected class IANPMouseListener
    implements MouseListener {
        protected IANPMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImagePanel ip;
            ip.setSelected(!(ip = (ImagePanel)e.getSource()).getSelected());
            if (ImageAndNeighborsPanel.this.display != null) {
                ImageAndNeighborsPanel.this.selectionStateChanged(ip.getId());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

