/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.data.DataManager;
import explorer.windows.w2D.utils.DragableImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.international.Messages;

public class ImgComparator
extends JFrame {
    private static final long serialVersionUID = 1L;
    JLabel jlZoom;
    JSlider jsZoom;
    JLabel jlImg1;
    JLabel jlImg2;
    JScrollPane jspImg1;
    JScrollPane jspImg2;
    InnerPanel ipImg1;
    InnerPanel ipImg2;
    JCheckBox jcbHqZoom;
    private boolean hqZoom = false;

    public ImgComparator() {
        this.setTitle(Messages.getString("imgcomp_title"));
        DropListener dl = new DropListener(this);
        JPanel jpImg = new JPanel();
        jpImg.setLayout(new FlowLayout());
        JPanel jpImg1 = new JPanel(new BorderLayout());
        this.jlImg1 = new JLabel("");
        jpImg1.add((Component)this.jlImg1, "North");
        this.ipImg1 = new InnerPanel();
        this.ipImg1.addMouseListener(dl);
        this.jspImg1 = new JScrollPane(this.ipImg1, 22, 32);
        this.jspImg1.setPreferredSize(new Dimension(300, 300));
        this.jspImg1.addMouseListener(dl);
        jpImg1.add((Component)this.jspImg1, "South");
        jpImg.add(jpImg1);
        JPanel jpImg2 = new JPanel(new BorderLayout());
        this.jlImg2 = new JLabel("");
        jpImg2.add((Component)this.jlImg2, "North");
        this.ipImg2 = new InnerPanel();
        this.ipImg2.addMouseListener(dl);
        this.jspImg2 = new JScrollPane(this.ipImg2, 22, 32);
        this.jspImg2.setPreferredSize(new Dimension(300, 300));
        this.jspImg2.addMouseListener(dl);
        jpImg2.add((Component)this.jspImg2, "South");
        jpImg.add(jpImg2);
        this.add((Component)jpImg, "Center");
        JPanel jpsouth = new JPanel(new BorderLayout());
        JPanel jptextZoom = new JPanel(new FlowLayout(1));
        jptextZoom.add(new JLabel(Messages.getString("imgcomp_hqzoom")));
        this.jcbHqZoom = new JCheckBox();
        this.jcbHqZoom.setToolTipText(Messages.getString("imgcomp_hqzoom_tooltip"));
        this.jcbHqZoom.addMouseListener(new ImgMouseListener());
        jptextZoom.add(this.jcbHqZoom);
        this.jlZoom = new JLabel("    100%");
        this.jlZoom.setHorizontalAlignment(0);
        jptextZoom.add(this.jlZoom);
        jpsouth.add((Component)jptextZoom, "North");
        this.jsZoom = new JSlider(1, 20, 5);
        this.jsZoom.addChangeListener(new ImgChangeListener());
        jpsouth.add((Component)this.jsZoom, "South");
        this.add((Component)jpsouth, "South");
        this.pack();
    }

    public ImgComparator(URL img1, String title1, URL img2, String title2) {
        this();
        this.setContent(img1, title1, img2, title2);
    }

    public void setContent(URL img1, String title1, URL img2, String title2) {
        this.jlImg1.setText(title1);
        this.ipImg1.setContent(img1);
        this.jlImg2.setText(title2);
        this.ipImg2.setContent(img2);
        this.pack();
    }

    private Dictionary<Integer, JComponent> sliderDict(int min, int max, int hundred) {
        int step = 100 / hundred;
        Hashtable<Integer, JComponent> ht = new Hashtable<Integer, JComponent>();
        int i = min;
        while (i <= max) {
            ht.put(i, new JLabel(String.valueOf(step * i) + "%"));
            ++i;
        }
        return ht;
    }

    class DropListener
    implements MouseListener {
        private JFrame parent;

        public DropListener(JFrame p) {
            this.parent = p;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Common c;
            JComponent jc;
            if (e.isShiftDown() && (jc = (c = Common.getSingleton()).getDraggedComponent()) != null && jc instanceof DragableImagePanel) {
                String src = ((DragableImagePanel)jc).getFileName();
                URL u = DataManager.getSingleton().getParams().getInHqImagePath(src);
                if (e.getSource() == ImgComparator.this.jspImg1 || e.getSource() == ImgComparator.this.ipImg1) {
                    ImgComparator.this.jlImg1.setText(src);
                    ImgComparator.this.ipImg1.setContent(u);
                } else {
                    ImgComparator.this.jlImg2.setText(src);
                    ImgComparator.this.ipImg2.setContent(u);
                }
                this.parent.pack();
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    class ImgChangeListener
    implements ChangeListener {
        float scale = 1.0f;

        ImgChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            float newscale = (float)ImgComparator.this.jsZoom.getValue() * 0.2f;
            if (newscale != this.scale) {
                this.scale = newscale;
                ImgComparator.this.ipImg1.zoom(this.scale);
                ImgComparator.this.ipImg2.zoom(this.scale);
                ImgComparator.this.jlZoom.setText("    " + (int)(this.scale * 100.0f) + "%");
            }
        }
    }

    class ImgMouseListener
    implements MouseListener {
        ImgMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImgComparator.this.hqZoom = ImgComparator.this.jcbHqZoom.isSelected();
            ImgComparator.this.ipImg1.zoom();
            ImgComparator.this.ipImg2.zoom();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class InnerPanel
    extends JLabel
    implements Scrollable {
        private static final long serialVersionUID = 1L;
        private ImageIcon icon;
        private Image image;
        private int width;
        private int height;
        private float scale;

        public InnerPanel() {
            this.setAutoscrolls(true);
            this.image = null;
            this.icon = null;
        }

        public InnerPanel(URL img) {
            this();
            this.setContent(img);
        }

        public void setContent(URL img) {
            this.image = Toolkit.getDefaultToolkit().getImage(img);
            this.icon = new ImageIcon(this.image);
            if (this.image.getWidth(null) == -1) {
                this.image = null;
                this.icon = null;
                this.height = -1;
                this.width = -1;
            } else {
                this.setIcon(this.icon);
                this.width = this.image.getWidth(null);
                this.height = this.image.getHeight(null);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }

        public void zoom(float scale) {
            if (this.image != null) {
                this.scale = scale;
                int scaling_mode = 2;
                if (scale > 1.0f && ImgComparator.this.hqZoom) {
                    scaling_mode = 4;
                }
                this.icon = new ImageIcon(this.image.getScaledInstance((int)((float)this.width * scale), (int)((float)this.height * scale), scaling_mode));
                this.setIcon(this.icon);
            }
        }

        public void zoom() {
            if (this.scale > 1.0f && this.image != null) {
                this.icon = ImgComparator.this.hqZoom ? new ImageIcon(this.image.getScaledInstance((int)((float)this.width * this.scale), (int)((float)this.height * this.scale), 4)) : new ImageIcon(this.image.getScaledInstance((int)((float)this.width * this.scale), (int)((float)this.height * this.scale), 2));
                this.setIcon(this.icon);
            }
        }
    }
}

