/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.parser.primitiveParser;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import lib3d4j.international.Messages;

public class IterationsDialog
extends JDialog {
    protected Common parent;
    private JButton precedent;
    private JButton suivant;
    private JButton courant;
    protected JTextField numero;

    public IterationsDialog(Common com) {
        this.parent = com;
        int nbLayouts = 3;
        IterationsActionListener al = new IterationsActionListener(this);
        this.setTitle(Messages.getString("iteration_dialog_title"));
        this.setLocation(100, 0);
        this.setLayout(new GridLayout(2, 2, 5, 5));
        this.precedent = new JButton(Messages.getString("previous_iteration"));
        this.precedent.addActionListener(al);
        this.add(this.precedent);
        this.suivant = new JButton(Messages.getString("next_iteration"));
        this.suivant.addActionListener(al);
        this.add(this.suivant);
        this.courant = new JButton(Messages.getString("this_iteration"));
        this.courant.addActionListener(al);
        this.add(this.courant);
        this.numero = new JTextField("1");
        this.add(this.numero);
        this.pack();
    }

    final class IterationsActionListener
    implements ActionListener {
        IterationsDialog parent = null;

        public IterationsActionListener(IterationsDialog ld) {
            this.parent = ld;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            try {
                if (src == IterationsDialog.this.suivant) {
                    IterationsDialog.this.numero.setText("" + (Integer.parseInt(IterationsDialog.this.numero.getText()) + 1));
                }
                if (src == IterationsDialog.this.precedent) {
                    IterationsDialog.this.numero.setText("" + (Integer.parseInt(IterationsDialog.this.numero.getText()) - 1));
                }
                if (Integer.parseInt(IterationsDialog.this.numero.getText()) <= 0) {
                    IterationsDialog.this.numero.setText("1");
                }
                this.parent.parent.getAffichagePrimitives().setVisuPrimitives(primitiveParser.parseScene(this.parent.parent.getCheminVisuPrimitives(), Integer.parseInt(IterationsDialog.this.numero.getText())));
            }
            catch (Exception exc) {
                exc.printStackTrace();
                IterationsDialog.this.numero.setText("Iteration inexistante!");
            }
        }
    }
}

