/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.display3D.DisplayExplorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib3d4j.display3D.javafx.JFXSwingUtils;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;
import lib3d4j.w2d.BoxTransp;
import lib3d4j.w2d.JPanelLegendStandard;
import lib3d4j.w2d.LDMouseAdapter;
import lib3d4j.w2d.LegendSquare;
import lib3d4j.w2d.Legendable;

public class JPanelLegendMultiClass
extends JPanelLegendStandard {
    Vector<Object> cats;
    JPanel jpMulti;
    JCheckBox jcbMulti;
    JLabel jlMulti;
    JSlider jsMulti;
    BoxTransp[] boxCenters = null;
    float[][] centers;

    public JPanelLegendMultiClass(Vector<Object> cats, float[][] centers, Legendable f3d) {
        super(new GridBagLayout());
        this.cats = cats;
        this.centers = centers;
        Color[] colors = JFXSwingUtils.toAwtColors(RichPrimitiveFactoryJFX.getFactory().getTabColor());
        this.init(colors, cats, f3d);
    }

    protected void init(Color[] colors, Vector<Object> cats, Legendable f3d) {
        this.parent = f3d;
        JLabel jlVisu = new JLabel(Messages.getString("legend_view"));
        super.add(jlVisu, 0, 0, 3);
        super.add(new JLabel("      "), 3, 0, 1, cats.size() + 2);
        JLabel jlAttr = new JLabel(Messages.getString("legend_attr"));
        super.add(jlAttr, 4, 0, 2);
        LDMouseAdapter ldma = new LDMouseAdapter(this);
        EnvelopeListener el = new EnvelopeListener();
        this.boxPoints = new BoxTransp[this.getNbClasses()];
        this.boxEnvelopes = new BoxTransp[this.getNbClasses()];
        this.boxCenters = new BoxTransp[this.getNbClasses()];
        this.add((Component)new JLabel(Messages.getString("legend_view_classes")), 0, 1);
        this.add((Component)new JLabel(Messages.getString("legend_view_envelope")), 1, 1);
        this.add((Component)new JLabel(Messages.getString("legend_view_center")), 2, 1);
        this.add((Component)new JLabel(Messages.getString("legend_color")), 3, 1);
        this.add((Component)new JLabel(Messages.getString("legend_attr_val")), 5, 1);
        this.add((Component)new JLabel(Messages.getString("legend_attr_card")), 6, 1);
        int i = 0;
        while (i < cats.size()) {
            BoxTransp box = new BoxTransp(i, 0);
            this.add((Component)box, 0, i + 2);
            this.boxPoints[i] = box;
            BoxTransp box3 = new BoxTransp(i, 2, false);
            box3.addActionListener(el);
            this.add((Component)box3, 1, i + 2);
            this.boxEnvelopes[i] = box3;
            BoxTransp box4 = new BoxTransp(i, 3, false);
            box4.addActionListener(el);
            this.add((Component)box4, 2, i + 2);
            this.boxCenters[i] = box4;
            LegendSquare jlc = new LegendSquare(i, colors[i]);
            this.add((Component)jlc, 3, i + 2);
            jlc.addMouseListener(ldma);
            JLabel jlName = new JLabel(cats.elementAt(i).toString());
            this.add((Component)jlName, 5, i + 2);
            JLabel jlCard = new JLabel("-");
            this.add((Component)jlCard, 6, i + 2);
            ++i;
        }
        this.jpMulti = new JPanel(new GridLayout(2, 2));
        this.jlMulti = new JLabel("Activer les enveloppes convexes");
        this.jpMulti.add(this.jlMulti);
        this.jcbMulti = new JCheckBox();
        this.jcbMulti.addMouseListener(new MultiMouseListener());
        this.jpMulti.add(this.jcbMulti);
        this.jsMulti = new JSlider();
        this.jsMulti.setMinorTickSpacing(10);
        this.jsMulti.setPaintTicks(true);
        this.jsMulti.setEnabled(false);
        this.jsMulti.addChangeListener(new JsListener());
        this.jpMulti.add(this.jsMulti);
        this.add(this.jpMulti, 0, cats.size() + 2, 7, 2);
    }

    public int getNbClasses() {
        return this.cats.size();
    }

    @Override
    public void cleanBoxes() {
        BoxTransp box;
        BoxTransp[] boxTranspArray = this.boxEnvelopes;
        int n = this.boxEnvelopes.length;
        int n2 = 0;
        while (n2 < n) {
            box = boxTranspArray[n2];
            if (box.isSelected()) {
                box.doClick(1);
            }
            ++n2;
        }
        boxTranspArray = this.boxCenters;
        n = this.boxCenters.length;
        n2 = 0;
        while (n2 < n) {
            box = boxTranspArray[n2];
            if (box.isSelected()) {
                box.doClick(1);
            }
            ++n2;
        }
    }

    @Override
    public void updateColor(int r, Color c) {
        this.parent.setGroupColor(r, JFXSwingUtils.toJFXColor(c));
        if (this.jcbMulti.isSelected()) {
            this.jcbMulti.doClick(1);
            this.jcbMulti.doClick(1);
        }
    }

    protected void drawEnvelopes() {
        float thres = (float)this.jsMulti.getValue() / 100.0f;
        int i = 0;
        while (i < this.cats.size()) {
            this.drawEnvelope(i, thres);
            ++i;
        }
    }

    protected void drawEnvelope(int i, float thres) {
        if (this.boxEnvelopes[i].isSelected()) {
            if (this.boxEnvelopes[i].getAssociatedObject() != -1) {
                this.parent.desurround(this.boxEnvelopes[i].getAssociatedObject());
                this.boxEnvelopes[i].setAssociatedObject(-1);
            }
            this.boxEnvelopes[i].setAssociatedObject(((DisplayExplorer)this.parent).surroundGroup(i, 1, thres));
        }
    }

    @Override
    public void setFunctionScript(String nomFonction, String[] lesParametres) {
        if (nomFonction.equals("isEnveloppeActivated")) {
            boolean isActivate = Boolean.parseBoolean(lesParametres[0]);
            if (isActivate && !this.jcbMulti.isSelected()) {
                this.jcbMulti.doClick(1);
                this.jsMulti.setEnabled(true);
                this.drawEnvelopes();
                this.jsMulti.setValue(Integer.parseInt(lesParametres[1]));
            } else if (!isActivate && this.jcbMulti.isSelected()) {
                this.jcbMulti.doClick(1);
                this.jsMulti.setEnabled(false);
                int i = 0;
                while (i < this.cats.size()) {
                    if (this.boxEnvelopes[i].isSelected()) {
                        this.parent.desurround(this.boxEnvelopes[i].getAssociatedObject());
                        this.boxEnvelopes[i].setAssociatedObject(-1);
                    }
                    ++i;
                }
            }
        } else {
            int index = Integer.parseInt(lesParametres[0]) - 1;
            boolean isSelected = Boolean.parseBoolean(lesParametres[1]);
            if (nomFonction.substring(3).equals(Messages.getString("legend_view_classes"))) {
                if (this.boxPoints[index].isSelected() && !isSelected || !this.boxPoints[index].isSelected() && isSelected) {
                    this.boxPoints[index].doClick();
                }
            } else if (nomFonction.substring(3).equals(Messages.getString("legend_view_envelope"))) {
                if (this.boxEnvelopes[index].isSelected() && !isSelected || !this.boxEnvelopes[index].isSelected() && isSelected) {
                    this.boxEnvelopes[index].doClick();
                }
            } else if (nomFonction.substring(3).equals(Messages.getString("legend_view_center")) && (this.boxCenters[index].isSelected() && !isSelected || !this.boxCenters[index].isSelected() && isSelected)) {
                this.boxCenters[index].doClick();
            }
        }
    }

    class EnvelopeListener
    implements ActionListener {
        EnvelopeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            BoxTransp square = (BoxTransp)src;
            switch (square.getType()) {
                case 2: {
                    if (!JPanelLegendMultiClass.this.jcbMulti.isSelected()) break;
                    float thres = (float)JPanelLegendMultiClass.this.jsMulti.getValue() / 100.0f;
                    int cat = square.getRank();
                    if (square.isSelected()) {
                        square.setAssociatedObject(((DisplayExplorer)JPanelLegendMultiClass.this.parent).surroundGroup(cat, 1, thres));
                        break;
                    }
                    JPanelLegendMultiClass.this.parent.desurround(square.getAssociatedObject());
                    square.setAssociatedObject(-1);
                    break;
                }
                case 3: {
                    int cat = square.getRank();
                    if (square.isSelected()) {
                        square.setAssociatedObject(((DisplayExplorer)JPanelLegendMultiClass.this.parent).drawCenter(cat));
                        break;
                    }
                    JPanelLegendMultiClass.this.parent.desurround(square.getAssociatedObject());
                    square.setAssociatedObject(-1);
                }
            }
        }
    }

    class JsListener
    implements ChangeListener {
        JsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JPanelLegendMultiClass.this.drawEnvelopes();
        }
    }

    class MultiMouseListener
    implements MouseListener {
        MultiMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == JPanelLegendMultiClass.this.jcbMulti) {
                if (JPanelLegendMultiClass.this.jcbMulti.isSelected()) {
                    JPanelLegendMultiClass.this.jsMulti.setEnabled(true);
                    JPanelLegendMultiClass.this.drawEnvelopes();
                } else {
                    JPanelLegendMultiClass.this.jsMulti.setEnabled(false);
                    int i = 0;
                    while (i < JPanelLegendMultiClass.this.cats.size()) {
                        if (JPanelLegendMultiClass.this.boxEnvelopes[i].isSelected()) {
                            JPanelLegendMultiClass.this.parent.desurround(JPanelLegendMultiClass.this.boxEnvelopes[i].getAssociatedObject());
                            JPanelLegendMultiClass.this.boxEnvelopes[i].setAssociatedObject(-1);
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

