/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import explorer.data.Common;
import explorer.windows.w2D.utils.Lateral;
import javafx.beans.value.ChangeListener;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;
import lib3d4j.display3D.javafx.SceneJFX;
import lib3d4j.international.Messages;
import lib3d4j.w2d.Stage3D;

public class Stage3DExplorer
extends Stage3D {
    private static final int STEP_SIZE = 30;
    private static final int NB_MAX_STEP = 10;
    private static int xMin;
    private static int yMin;
    private static int nbOffset;

    static {
        nbOffset = -1;
    }

    public Stage3DExplorer(SceneJFX jp3d, String sourceName, boolean withBorder, ChangeListener<Boolean> listener) {
        super(jp3d, String.valueOf(Messages.getString("f3d_title")) + " : " + sourceName);
        this.setScene(jp3d.getScene());
        if (withBorder) {
            ((BorderPane)this.getScene().getRoot()).setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)HASFOCUS, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, bw)}));
        }
        this.setXY();
        this.focusedProperty().addListener(listener);
    }

    private void setXY() {
        if (nbOffset == -1) {
            Lateral lat = Common.getSingleton().getLateral();
            xMin = lat.getX() + lat.getWidth();
            yMin = lat.getY();
            nbOffset = 0;
        } else {
            nbOffset = (nbOffset + 1) % 10;
        }
        int xOffset = xMin + nbOffset * 30;
        int yOffset = yMin + nbOffset * 30;
        this.setX(xOffset);
        this.setY(yOffset);
    }
}

