/*
 * Decompiled with CFR 0.152.
 */
package explorer.windows.w2D.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import lib3d4j.w2d.ImagePanel;

public class Welcome {
    static WelcomeWindow w;
    static int maxWidth;

    static {
        maxWidth = 600;
    }

    public static void generateWelcome() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                w = new Welcome().new WelcomeWindow();
                w.setVisible(true);
            }
        });
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void closeWelcome(int delay) {
        try {
            Thread.sleep(delay * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                w.setVisible(false);
                w = null;
            }
        });
    }

    public class WelcomeWindow
    extends JWindow {
        public WelcomeWindow() {
            this.setContent();
        }

        private void setContent() {
            int h;
            float scale;
            int w;
            File dir = new File(".");
            String fileName = "images/explorer3d.jpg";
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            int dim = scrSize.width / 3;
            File imgFile = new File(dir, fileName);
            Image image = null;
            try {
                if (imgFile.exists()) {
                    image = Toolkit.getDefaultToolkit().getImage(imgFile.getAbsolutePath());
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            if (image == null) {
                image = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource(fileName));
            }
            if ((float)(w = (image = new ImageIcon(image).getImage()).getWidth(null)) * (scale = (float)dim / (float)Math.max(w, h = image.getHeight(null))) > (float)maxWidth) {
                scale = (float)maxWidth / (float)w;
            }
            w = (int)(scale * (float)w);
            h = (int)(scale * (float)h);
            int x = (scrSize.width - w) / 2;
            int y = (scrSize.height - h) / 4;
            ImagePanel imagePanel = new ImagePanel(image, w, h);
            this.getContentPane().add((Component)imagePanel, "Center");
            this.setLocation(new Point(x, y));
            this.pack();
        }
    }
}

