/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.compute.tools;

import Jama.Matrix;
import lib3d4j.compute.tools.OutilsTableaux;

public class OutilsAlgebre {
    public static final int ANG_DEGREE = 0;
    public static final int ANG_RADIAN = 0;

    public static float[] vectorToAngle(float[] f, int unit) {
        float x = f[2];
        float y = f[0];
        float z = f[1];
        float[] res = new float[3];
        double r = Math.sqrt(f[0] * f[0] + f[1] * f[1] + f[2] * f[2]);
        float psy = (float)Math.acos(z / (float)r);
        float theta = (float)Math.asin((double)y / Math.sqrt(x * x + y * y));
        if (x < 0.0f) {
            theta = (float)Math.PI - theta;
        }
        res[1] = theta;
        res[0] = psy;
        if (x == 0.0f && y == 0.0f) {
            res[1] = 0.0f;
        }
        if (unit == 0) {
            float conv = 57.29578f;
            res[0] = res[0] * conv;
            res[1] = res[1] * conv;
        }
        return res;
    }

    public static float meanDistanceToCenterAlongAxes(float[][] setOfPoints, float[] lineVector) {
        return OutilsAlgebre.meanDistanceToPointAlongAxes(setOfPoints, lineVector, OutilsAlgebre.barycenter(setOfPoints));
    }

    public static float meanDistancePlusVarianceSqrtToCenterAlongAxes(float[][] ensemblePoints, float[] vectDroite) {
        return OutilsAlgebre.meanDistancePlusVarianceSqrtToPointAlongAxes(ensemblePoints, vectDroite, OutilsAlgebre.barycenter(ensemblePoints));
    }

    public static float[][] normalize(float[][] data) {
        float[] centre = OutilsAlgebre.barycenter(data);
        int i = 0;
        while (i < data.length) {
            OutilsTableaux.substractArrays(data[i], centre);
            ++i;
        }
        i = 0;
        while (i < data[0].length) {
            OutilsTableaux.multiplyByScalar(data, i, 1.0f / OutilsTableaux.colMean(data, i));
            ++i;
        }
        return data;
    }

    public static float meanDistanceToPointAlongAxes(float[][] ensemblePoints, float[] lineVector, float[] point) {
        float total = 0.0f;
        float moyenne = 0.0f;
        int nbIndiv = 0;
        int nbObjets = ensemblePoints.length;
        int i = 0;
        while (i < nbObjets) {
            double courant = OutilsAlgebre.distanceToLine(ensemblePoints[i], lineVector, point);
            moyenne = (float)((double)moyenne + courant);
            total = (float)((double)total + courant * courant);
            ++nbIndiv;
            ++i;
        }
        return moyenne / (float)nbIndiv;
    }

    public static float meanDistancePlusVarianceSqrtToPointAlongAxes(float[][] ensemblePoints, float[] vectDroite, float[] point) {
        float total = 0.0f;
        float moyenne = 0.0f;
        int nbIndiv = 0;
        int nbObjets = ensemblePoints.length;
        int i = 0;
        while (i < nbObjets) {
            double courant = OutilsAlgebre.distanceToLine(ensemblePoints[i], vectDroite, point);
            moyenne = (float)((double)moyenne + courant);
            total = (float)((double)total + courant * courant);
            ++nbIndiv;
            ++i;
        }
        return (float)((double)(moyenne / (float)nbIndiv) + Math.sqrt(total / (float)nbIndiv));
    }

    public static float[] barycenter(float[][] ensemblePoints) {
        float[] res = new float[ensemblePoints[0].length];
        int i = 0;
        while (i < ensemblePoints.length) {
            int j = 0;
            while (j < ensemblePoints[i].length) {
                int n = j;
                res[n] = res[n] + ensemblePoints[i][j];
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < ensemblePoints[0].length) {
            int n = j++;
            res[n] = res[n] / (float)ensemblePoints.length;
        }
        return res;
    }

    public static float distanceToLine(float[] coordPtExterieur, float[] vectDroite, float[] coordPtDroite) {
        float[] autrePtDroite = new float[coordPtDroite.length];
        int i = 0;
        while (i < coordPtDroite.length) {
            autrePtDroite[i] = coordPtDroite[i] + vectDroite[i];
            ++i;
        }
        float[] resVect = new float[coordPtDroite.length];
        float d1 = OutilsAlgebre.distance(coordPtDroite, autrePtDroite);
        float d2 = OutilsAlgebre.distance(autrePtDroite, coordPtExterieur);
        float d3 = OutilsAlgebre.distance(coordPtDroite, coordPtExterieur);
        if (d1 == 0.0f) {
            return 0.0f;
        }
        float m = (d1 * d1 + d3 * d3 - d2 * d2) / (2.0f * d1);
        int i2 = 0;
        while (i2 < coordPtDroite.length) {
            resVect[i2] = coordPtDroite[i2] + (autrePtDroite[i2] - coordPtDroite[i2]) * m / d1;
            ++i2;
        }
        float res = 0.0f;
        int i3 = 0;
        while (i3 < coordPtDroite.length) {
            res += (resVect[i3] - coordPtExterieur[i3]) * (resVect[i3] - coordPtExterieur[i3]);
            ++i3;
        }
        if (!(res < d3 * d3)) {
            return 0.0f;
        }
        return (float)Math.sqrt((double)d3 * (double)d3 - (double)res);
    }

    public static double distanceToABLine(float[] pA, float[] pB, float[] pC) {
        float[] vectBC = new float[]{pB[0] - pA[0], pB[1] - pA[1], pB[2] - pA[2]};
        float[] vectBA = new float[]{pC[0] - pA[0], pC[1] - pA[1], pC[2] - pA[2]};
        float[] prodVec = new float[]{vectBC[1] * vectBA[2] - vectBC[2] * vectBA[1], vectBC[2] * vectBA[0] - vectBC[0] * vectBA[2], vectBC[0] * vectBA[1] - vectBC[1] * vectBA[0]};
        return Math.sqrt(prodVec[0] * prodVec[0] + prodVec[1] * prodVec[1] + prodVec[2] * prodVec[2]) / Math.sqrt(vectBC[0] * vectBC[0] + vectBC[1] * vectBC[1] + vectBC[2] * vectBC[2]);
    }

    public static float distance(float[] p1, float[] p2) {
        float res = 0.0f;
        int i = 0;
        while (i < p1.length) {
            res += (p1[i] - p2[i]) * (p1[i] - p2[i]);
            ++i;
        }
        return (float)Math.sqrt(res);
    }

    public static float length(float[] v1) {
        float[] centre = new float[v1.length];
        return OutilsAlgebre.distance(v1, centre);
    }

    public static double length(double[] v1) {
        return OutilsAlgebre.length(OutilsTableaux.doubleToFloat(v1));
    }

    public static double[][] varianceCovariance(float[][] ensemblePoints) {
        float[] centre = OutilsAlgebre.barycenter(ensemblePoints);
        int nbObjets = ensemblePoints.length;
        int nbTermes = ensemblePoints[0].length;
        double[][] matrice = new double[nbTermes][nbTermes];
        int i = 0;
        while (i < nbTermes) {
            int j = i;
            while (j < nbTermes) {
                float som = 0.0f;
                int k = 0;
                while (k < nbObjets) {
                    som += (ensemblePoints[k][i] - centre[i]) * (ensemblePoints[k][j] - centre[j]);
                    ++k;
                }
                matrice[i][j] = 1.0 * (double)(som /= 1.0f * (float)nbObjets);
                matrice[j][i] = 1.0 * (double)som;
                ++j;
            }
            ++i;
        }
        return matrice;
    }

    public static float[][] mainAxes(float[][] ensemblePoints) {
        Matrix M = new Matrix(OutilsAlgebre.varianceCovariance(ensemblePoints));
        return OutilsAlgebre.mainAxesCovariance(M);
    }

    public static float[][] mainAxesCovariance(Matrix M) {
        float[][] f = OutilsTableaux.doubleToFloat(M.eig().getV2());
        float[][] f2 = new float[f.length][f[0].length];
        int i = 0;
        while (i < f.length) {
            int j = 0;
            while (j < f[0].length) {
                f2[i][j] = f[j][i];
                ++j;
            }
            ++i;
        }
        return f2;
    }

    public static double distanceDensityMultinormal(Matrix sigma, Matrix x, double c) {
        double p = sigma.getRowDimension();
        double k = 1.0 / (Math.pow(Math.PI * 2, p * 0.5) * Math.pow(sigma.det(), 0.5));
        Matrix inverseSigma = sigma.inverse();
        Matrix xTransp = x.transpose();
        Matrix total = xTransp.times(inverseSigma.times(x));
        double matrixProduct = total.get(0, 0);
        double log = Math.log(k / c);
        return Math.sqrt(2.0 * log / matrixProduct);
    }

    /*
     * Unable to fully structure code
     */
    public static float probDensityMultinormal(Matrix x, Matrix mu, Matrix sigma) {
        block8: {
            p = mu.getRowDimension();
            try {
                inverseSigma = sigma.inverse();
                break block8;
            }
            catch (Exception e) {
                matriceNulle = true;
                i = 0;
                ** while (i < sigma.getRowDimension())
            }
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < sigma.getColumnDimension()) {
                    if (sigma.get(i, j) != 0.0) {
                        matriceNulle = false;
                    }
                    ++j;
                }
                ++i;
                continue;
            }
lbl17:
            // 1 sources

            if (matriceNulle) {
                i = 0;
                while (i < x.getRowDimension()) {
                    if (x.get(i, 0) != mu.get(i, 0)) {
                        return 0.0f;
                    }
                    ++i;
                }
            }
            return 1.0E32f;
        }
        inverseSigma = sigma.inverse();
        xMinusMu = x.minus(mu);
        xMinusMuTransp = xMinusMu.transpose();
        total = xMinusMuTransp.times(inverseSigma.times(xMinusMu));
        valeurExp = Math.exp(-total.get(0, 0) / 2.0);
        sousFraction = Math.pow(6.283185307179586, (double)p * 0.5) * Math.pow(sigma.det(), 0.5);
        return (float)(valeurExp / sousFraction);
    }

    public static float distanceDensityMultinormal(float[][] sigma, float[] x, float densite) {
        Matrix sigm = new Matrix(OutilsTableaux.floatToDouble(sigma));
        double[] aux = OutilsTableaux.floatToDouble(x);
        double[][] aux2 = new double[aux.length][1];
        int i = 0;
        while (i < aux.length) {
            aux2[i][0] = aux[i];
            ++i;
        }
        Matrix x2 = new Matrix(aux2);
        return (float)OutilsAlgebre.distanceDensityMultinormal(sigm, x2, (double)densite);
    }

    public static float probDensityMultinormal(float[] x, float[] mu, float[][] sigma) {
        Matrix MSigma = new Matrix(OutilsTableaux.floatToDouble(sigma));
        return OutilsAlgebre.probDensityMultinormal(x, mu, MSigma);
    }

    public static float probDensityMultinormal(float[] x, float[] mu, Matrix sigma) {
        Matrix Mx = new Matrix(OutilsTableaux.floatToDouble(x), x.length);
        Matrix Mmu = new Matrix(OutilsTableaux.floatToDouble(mu), mu.length);
        return OutilsAlgebre.probDensityMultinormal(Mx, Mmu, sigma);
    }

    public static int indexNN(float[][] points, int ptTest) {
        int min = 0;
        if (ptTest == 0) {
            min = 1;
        }
        float dMin = OutilsAlgebre.distance(points[min], points[ptTest]);
        int i = 1;
        while (i < ptTest) {
            if (i == 84 && ptTest == 106) {
                int j = 1;
                ++j;
            }
            if (dMin > OutilsAlgebre.distance(points[i], points[ptTest])) {
                dMin = OutilsAlgebre.distance(points[i], points[ptTest]);
                min = i;
            }
            ++i;
        }
        i = ptTest + 1;
        while (i < points.length) {
            if (dMin > OutilsAlgebre.distance(points[i], points[ptTest])) {
                dMin = OutilsAlgebre.distance(points[i], points[ptTest]);
                min = i;
            }
            ++i;
        }
        return min;
    }

    public static int[] kNearestNeighbors(int k, int point, float[][] setOfPoints) {
        int[] resincl = OutilsAlgebre.kNearestNeighbors(k + 1, setOfPoints[point], setOfPoints);
        int[] res = new int[resincl.length - 1];
        System.arraycopy(resincl, 1, res, 0, res.length);
        return res;
    }

    public static int[] kNearestNeighbors(int k, float[] point, float[][] setOfPoints) {
        int szres = k > setOfPoints.length ? setOfPoints.length : k;
        int[] res = new int[szres];
        float[] resdist = new float[szres];
        int i = 0;
        while (i < szres) {
            res[i] = -1;
            resdist[i] = -1.0f;
            ++i;
        }
        i = 0;
        while (i < setOfPoints.length) {
            float dist = OutilsAlgebre.distance(setOfPoints[i], point);
            int rank = 0;
            while (rank < szres && resdist[rank] != -1.0f && resdist[rank] < dist) {
                ++rank;
            }
            if (rank < szres) {
                int end = szres - 1;
                while (end > rank) {
                    resdist[end] = resdist[end - 1];
                    res[end] = res[end - 1];
                    --end;
                }
                resdist[rank] = dist;
                res[rank] = i;
            }
            ++i;
        }
        return res;
    }

    public static boolean isInEllipsoid(float[] point, float[] centre, float[] parametresEllipse) {
        float somme = 0.0f;
        int i = 0;
        while (i < parametresEllipse.length) {
            somme += (point[i] - centre[i]) * (point[i] - centre[i]) / (parametresEllipse[i] * parametresEllipse[i]);
            ++i;
        }
        return somme <= 1.0f;
    }

    public static boolean isInEllipsoid(float[] point, float[] centre, float[][] vecteursPrincipauxEllipse) {
        float somme = 0.0f;
        int i = 0;
        while (i < vecteursPrincipauxEllipse.length) {
            somme += OutilsAlgebre.distanceToLine(point, vecteursPrincipauxEllipse[i], centre) / (OutilsAlgebre.length(vecteursPrincipauxEllipse[i]) * OutilsAlgebre.length(vecteursPrincipauxEllipse[i]));
            ++i;
        }
        return somme <= 1.0f;
    }
}

