/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.data;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;

public class DatasetParams
extends Observable {
    public static final int DP_COLOR = 1;
    public static final int DP_CLASS = 2;
    public static final int DP_ASDAT = 4;
    public static final int DP_FORM = 8;
    public static final int DP_LABEL = 16;
    public static final int DP_NORMALIZE = 32;
    public static final int DP_CENTER = 64;
    public static final int DP_NOASSOC = 1024;
    public static final int FILE = 1;
    public static final int HTTP = 2;
    private URL currentUrl = null;
    private URL currentPath;
    private URL imagePath;
    private URL hqImagePath;
    public String separator = "/";
    private String protocolStr = "file";
    private int protocol = 1;
    private int formCol;
    private int colorCol;
    private int labelCol;
    private int assocDataCol;
    private int classCol;
    private boolean normalize;
    private boolean centre;

    public DatasetParams() {
        try {
            this.currentPath = new URL("file", null, System.getProperty("user.dir"));
            this.separator = File.separator;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.formCol = -1;
        this.colorCol = -1;
        this.labelCol = -1;
        this.assocDataCol = -1;
        this.classCol = -1;
        this.normalize = false;
        this.centre = false;
    }

    public URL getCurrentUrl() {
        return this.currentUrl;
    }

    public void setCurrentUrl(URL curr) {
        this.currentUrl = curr;
        this.protocolStr = this.currentUrl.getProtocol();
        if (this.protocolStr.equals("file")) {
            this.protocol = 1;
            this.separator = File.separator;
        } else {
            this.separator = "/";
            this.protocol = 2;
        }
        String path = this.currentUrl.toString();
        path = path.substring(0, path.lastIndexOf(this.separator));
        try {
            URL upath = new URL(path);
            this.setCurrentPath(upath);
            this.setImagePath(upath);
            this.setHqImagePath(upath);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public URL getCurrentPath() {
        return this.currentPath;
    }

    public String getCurrentPathString() {
        return String.valueOf(this.protocolStr) + "://" + this.currentPath.getPath();
    }

    public void setCurrentPath(URL cd) {
        this.currentPath = cd;
    }

    public void setCurrentPath(File cd) {
        try {
            this.currentPath = new URL("file://" + cd.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void setImagePath(URL imageDir) {
        this.imagePath = imageDir;
    }

    public void setImagePath(File imageDir) {
        try {
            this.imagePath = new URL("file://" + imageDir.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public URL getImagePath() {
        return this.imagePath;
    }

    public URL getInImagePath(String imgName) {
        URL u = null;
        try {
            u = new URL(String.valueOf(this.imagePath.toString()) + this.separator + imgName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return u;
    }

    public URL getHqImagePath() {
        return this.hqImagePath;
    }

    public void setHqImagePath(URL hqImagePath) {
        this.hqImagePath = hqImagePath;
    }

    public URL getInHqImagePath(String imgName) {
        URL u = null;
        try {
            u = new URL(String.valueOf(this.hqImagePath.toString()) + this.separator + imgName);
            System.out.println(u.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return u;
    }

    public int getColumnRole(int rank) {
        int role = 0;
        if (rank == this.colorCol) {
            ++role;
        }
        if (rank == this.classCol) {
            role += 2;
        }
        if (rank == this.assocDataCol) {
            role += 4;
        }
        if (rank == this.formCol) {
            role += 8;
        }
        if (rank == this.labelCol) {
            role += 16;
        }
        if (role == 0) {
            role = 1024;
        }
        return role;
    }

    public int getRoleColumn(int role) {
        int col = -1;
        if (role == 1) {
            col = this.colorCol;
        } else if (role == 2) {
            col = this.classCol;
        } else if (role == 4) {
            col = this.assocDataCol;
        } else if (role == 8) {
            col = this.formCol;
        } else if (role == 16) {
            col = this.labelCol;
        }
        return col;
    }

    public int getAssocDataCol() {
        return this.assocDataCol;
    }

    public void setAssocDataCol(int adc) {
        if (this.assocDataCol != adc) {
            this.assocDataCol = adc;
            this.setChanged();
            this.notifyObservers(4);
        }
    }

    public int getLabelCol() {
        return this.labelCol;
    }

    public void setLabelCol(int lc) {
        if (this.labelCol != lc) {
            this.labelCol = lc;
            this.setChanged();
            this.notifyObservers(16);
        }
    }

    public int getColorCol() {
        return this.colorCol;
    }

    public void setColorCol(int lc) {
        if (this.colorCol != lc) {
            this.colorCol = lc;
            this.setChanged();
            this.notifyObservers(1);
        }
    }

    public int getFormCol() {
        return this.formCol;
    }

    public void setFormCol(int lc) {
        if (this.formCol != lc) {
            this.formCol = lc;
            this.setChanged();
            this.notifyObservers(8);
        }
    }

    public int getClassCol() {
        return this.classCol;
    }

    public void setClassCol(int lc) {
        if (this.classCol != lc) {
            this.classCol = lc;
            this.setChanged();
            this.notifyObservers(2);
        }
    }

    public boolean isSetClassCol() {
        return this.classCol != -1;
    }

    public int unsetColsSetAt(int lc) {
        int changedElem = 0;
        if (this.colorCol == lc) {
            this.colorCol = -1;
            changedElem |= 1;
        }
        if (this.classCol == lc) {
            this.classCol = -1;
            changedElem |= 2;
        }
        if (this.assocDataCol == lc) {
            this.assocDataCol = -1;
            changedElem |= 4;
        }
        if (this.formCol == lc) {
            this.formCol = -1;
            changedElem |= 8;
        }
        if (this.labelCol == lc) {
            this.labelCol = -1;
            changedElem |= 0x10;
        }
        if (changedElem != 0) {
            this.setChanged();
            this.notifyObservers(changedElem);
        }
        return changedElem;
    }

    public boolean getNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean etat) {
        this.normalize = etat;
        this.setChanged();
        this.notifyObservers(32);
    }

    public boolean getCentre() {
        return this.centre;
    }

    public void setCentre(boolean etat) {
        this.centre = etat;
        this.setChanged();
        this.notifyObservers(64);
    }

    public String getBaseDir() {
        return System.getProperty("user.dir");
    }

    public void reset() {
        this.currentUrl = null;
        this.setFormCol(-1);
        this.setColorCol(-1);
        this.setLabelCol(-1);
        this.setAssocDataCol(-1);
        this.setClassCol(-1);
        this.normalize = false;
        this.centre = false;
    }
}

