/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.data;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Observable;
import json.JSONException;
import json.JSONObject;

public class Options
extends Observable
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static String DEFAULTOPTIONFILE = ".options";
    private static boolean DEFAULT_INITIALROTATION = false;
    private static String STR_INITIALROTATION = "initialrotation";
    private boolean initialRotation = DEFAULT_INITIALROTATION;
    private static int DEFAULT_DEFAULTCOLOR = Color.BLUE.getRGB();
    private static String STR_DEFAULTCOLOR = "defaultcolor";
    private Color defaultColor = new Color(DEFAULT_DEFAULTCOLOR);
    private static boolean DEFAULT_STANDALONEFIGURES = true;
    private static String STR_STANDALONEFIGURES = "standalonefigures";
    private boolean standAloneFigures = DEFAULT_STANDALONEFIGURES;
    private static boolean DEFAULT_REMOTEVIEW = false;
    private static String STR_REMOTEVIEW = "standalonefigures";
    private boolean remoteView = DEFAULT_REMOTEVIEW;
    private static int DEFAULT_HISTORYSIZE = 7;
    private static String STR_HISTORYSIZE = "historysize";
    private int historySize = DEFAULT_HISTORYSIZE;
    private static boolean DEFAULT_LOADANDSHOW = true;
    private static String STR_LOADANDSHOW = "loadandshow";
    private boolean loadAndShow = DEFAULT_LOADANDSHOW;
    private static boolean DEFAULT_CROPINNEWWINDOW = false;
    private static String STR_CROPINNEWWINDOW = "cropinnewwindow";
    private boolean cropInNewWindow = DEFAULT_CROPINNEWWINDOW;
    private static boolean DEFAULT_SHOWATTRIBUTESDIALOG = false;
    private static String STR_SHOWATTRIBUTESDIALOG = "showattributesdialog";
    private boolean showAttributesDialog = DEFAULT_SHOWATTRIBUTESDIALOG;
    private static int DEFAULT_LABELSIZE = 1;
    private static String STR_LABELSIZE = "labelsize";
    private int labelSize = 1;
    private static boolean DEFAULT_SHOWFIGUREONMOUSEOVER = true;
    private static String STR_SHOWFIGUREONMOUSEOVER = "showfigureonmouseover";
    private boolean showFigureOnMouseOver = DEFAULT_SHOWFIGUREONMOUSEOVER;
    private static boolean DEFAULT_STEREO = false;
    private static String STR_STEREO = "stereo";
    private boolean stereo = DEFAULT_STEREO;
    private static boolean DEFAULT_DYNAMICOBJECTSIZE = true;
    private static String STR_DYNAMICOBJECTSIZE = "dynamicobjectsize";
    private boolean dynamicObjectSize = DEFAULT_DYNAMICOBJECTSIZE;
    private static int DEFAULT_OBJECTSIZE = 1;
    private static String STR_OBJECTSIZE = "objectsize";
    private float objectSize = DEFAULT_OBJECTSIZE;

    @Override
    public void notifyObservers() {
        super.setChanged();
        super.notifyObservers();
    }

    public boolean isDynamicObjectSize() {
        return this.dynamicObjectSize;
    }

    public void setDynamicObjectSize(boolean dynamicObjectSize) {
        this.dynamicObjectSize = dynamicObjectSize;
    }

    public float getObjectSize() {
        return this.objectSize;
    }

    public void setObjectSize(float objectSize) {
        this.objectSize = objectSize;
    }

    public boolean isInitialRotation() {
        return this.initialRotation;
    }

    public void setInitialRotation(boolean initialRotation) {
        this.initialRotation = initialRotation;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void setDefaultColor(int rgb) {
        this.setDefaultColor(new Color(rgb));
    }

    public boolean isStandAloneFigures() {
        return this.standAloneFigures;
    }

    public void setStandAloneFigures(boolean standAloneFigures) {
        this.standAloneFigures = standAloneFigures;
    }

    public boolean isRemoteView() {
        return this.remoteView;
    }

    public void setRemoteView(boolean remoteView) {
        this.remoteView = remoteView;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    public boolean isLoadAndShow() {
        return this.loadAndShow;
    }

    public void setLoadAndShow(boolean loadAndShow) {
        this.loadAndShow = loadAndShow;
    }

    public boolean isCropInNewWindow() {
        return this.cropInNewWindow;
    }

    public void setCropInNewWindow(boolean cropInNewWindow) {
        this.cropInNewWindow = cropInNewWindow;
    }

    public boolean isShowAttributesDialog() {
        return this.showAttributesDialog;
    }

    public void setShowAttributesDialog(boolean showAttributesDialog) {
        this.showAttributesDialog = showAttributesDialog;
    }

    public boolean isShowFigureOnMouseOver() {
        return this.showFigureOnMouseOver;
    }

    public void setShowFigureOnMouseOver(boolean showFigureOnMouseOver) {
        this.showFigureOnMouseOver = showFigureOnMouseOver;
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(int i) {
        this.labelSize = i;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public void setStereo(boolean stereo) {
        this.stereo = stereo;
    }

    protected void load(JSONObject jso) {
        this.setInitialRotation(jso.optBoolean(STR_INITIALROTATION, DEFAULT_INITIALROTATION));
        this.setDefaultColor(jso.optInt(STR_DEFAULTCOLOR, DEFAULT_DEFAULTCOLOR));
        this.setStandAloneFigures(jso.optBoolean(STR_STANDALONEFIGURES, DEFAULT_STANDALONEFIGURES));
        this.setRemoteView(jso.optBoolean(STR_REMOTEVIEW, DEFAULT_REMOTEVIEW));
        this.setHistorySize(jso.optInt(STR_HISTORYSIZE, DEFAULT_HISTORYSIZE));
        this.setLoadAndShow(jso.optBoolean(STR_LOADANDSHOW, DEFAULT_LOADANDSHOW));
        this.setCropInNewWindow(jso.optBoolean(STR_CROPINNEWWINDOW, DEFAULT_CROPINNEWWINDOW));
        this.setShowAttributesDialog(jso.optBoolean(STR_SHOWATTRIBUTESDIALOG, DEFAULT_SHOWATTRIBUTESDIALOG));
        this.setLabelSize(jso.optInt(STR_LABELSIZE, DEFAULT_LABELSIZE));
        this.setShowFigureOnMouseOver(jso.optBoolean(STR_SHOWFIGUREONMOUSEOVER, DEFAULT_SHOWFIGUREONMOUSEOVER));
        this.setStereo(jso.optBoolean(STR_STEREO, DEFAULT_STEREO));
        this.setDynamicObjectSize(jso.optBoolean(STR_DYNAMICOBJECTSIZE, DEFAULT_DYNAMICOBJECTSIZE));
        this.setObjectSize(jso.optInt(STR_OBJECTSIZE, DEFAULT_OBJECTSIZE));
    }

    public static Options loadOptions(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            ObjectInputStream oin = new ObjectInputStream(in);
            Options opt = (Options)oin.readObject();
            oin.close();
            return opt;
        }
        catch (FileNotFoundException fnfe) {
            return new Options();
        }
        catch (Exception e) {
            System.out.println("exception during access to option file: " + e.getMessage());
            return new Options();
        }
    }

    public static Options loadOptions() {
        return Options.loadOptions(DEFAULTOPTIONFILE);
    }

    protected JSONObject toJson() {
        JSONObject jso = new JSONObject();
        try {
            jso.put(STR_INITIALROTATION, this.isInitialRotation());
            jso.put(STR_DEFAULTCOLOR, this.getDefaultColor().getRGB());
            jso.put(STR_STANDALONEFIGURES, this.isStandAloneFigures());
            jso.put(STR_REMOTEVIEW, this.isRemoteView());
            jso.put(STR_HISTORYSIZE, this.getHistorySize());
            jso.put(STR_LOADANDSHOW, this.isLoadAndShow());
            jso.put(STR_CROPINNEWWINDOW, this.isCropInNewWindow());
            jso.put(STR_SHOWATTRIBUTESDIALOG, this.isShowAttributesDialog());
            jso.put(STR_LABELSIZE, this.getLabelSize());
            jso.put(STR_SHOWFIGUREONMOUSEOVER, this.isShowFigureOnMouseOver());
            jso.put(STR_STEREO, this.isStereo());
            jso.put(STR_DYNAMICOBJECTSIZE, this.isDynamicObjectSize());
            jso.put(STR_OBJECTSIZE, this.getObjectSize());
        }
        catch (JSONException e) {
            System.out.println("exception while preparing option file saving: " + e.getMessage());
        }
        return jso;
    }

    public static void saveOptions(Options opt, String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(opt);
            oout.close();
        }
        catch (Exception e) {
            System.out.println("exception during access to option file: " + e.getMessage());
        }
    }

    public static void saveOptions(Options opt) {
        Options.saveOptions(opt, DEFAULTOPTIONFILE);
    }
}

