/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.java3D;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lib3d4j.display3D.java3D.CentralSelectionObserver;

public class CentralSelection {
    private boolean[] selectStates;
    private int lastUse;
    private List<CentralSelectionObserver> callbacks = new ArrayList<CentralSelectionObserver>();
    private static CentralSelection singleton = new CentralSelection();

    public static CentralSelection getSingleton() {
        return singleton;
    }

    public void setObjectList(int nbo) {
        if (this.selectStates == null) {
            this.selectStates = new boolean[nbo];
            Arrays.fill(this.selectStates, false);
        }
    }

    public void flipState(int index, CentralSelectionObserver modified) {
        this.selectStates[index] = !this.selectStates[index];
        this.lastUse = index;
        this.broadcast(modified);
    }

    public boolean isSelected(int index) {
        return this.selectStates[index];
    }

    public void reference(CentralSelectionObserver cb) {
        this.callbacks.add(cb);
    }

    public void dereference(CentralSelectionObserver cb) {
        this.callbacks.remove(cb);
    }

    private void broadcast(CentralSelectionObserver modifier) {
        for (CentralSelectionObserver cb : this.callbacks) {
            if (cb == modifier) continue;
            cb.onSelectionChange();
        }
    }

    public boolean[] getSelectStates() {
        return this.selectStates;
    }

    public int[] getSelectIndices() {
        int nbtrue = 0;
        int i = 0;
        while (i < this.selectStates.length) {
            if (this.selectStates[i]) {
                ++nbtrue;
            }
            ++i;
        }
        int[] tabtrue = new int[nbtrue];
        int cpttrue = 0;
        int cptall = 0;
        while (cpttrue < nbtrue) {
            if (this.selectStates[cptall]) {
                tabtrue[cpttrue] = cptall;
                ++cpttrue;
            }
            ++cptall;
        }
        return tabtrue;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void reset() {
        this.selectStates = null;
        this.lastUse = -1;
        this.callbacks.clear();
    }
}

