/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.java3D.data;

import java.util.ArrayList;
import java.util.List;
import lib3d4j.international.Messages;

public class Parameters3D {
    public static final int BG_DARK = 0;
    public static final int BG_CLEAR = 1;
    public static final int BG_WHITE = 2;
    private static final int[] BG_STYLES;
    public static final int GL_AXES = 0;
    public static final int GL_CUBE = 1;
    public static final int GL_AXESCOLOR = 2;
    public static final int GL_XLSTATS = 3;
    public static final int GL_SPHERE = 4;
    public static final int GL_NONE = 1000;
    private static final int[] GL_STYLES;
    private static List<String> bgStyles;
    private static List<String> glStyles;
    private static int style;
    private static int axes;
    private int background;
    private int guidelines;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        BG_STYLES = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        GL_STYLES = nArray2;
        bgStyles = null;
        glStyles = null;
        style = 0;
        axes = 1;
    }

    public static List<String> getBgStyles() {
        if (bgStyles == null) {
            bgStyles = new ArrayList<String>(BG_STYLES.length);
            int[] nArray = BG_STYLES;
            int n = BG_STYLES.length;
            int n2 = 0;
            while (n2 < n) {
                int bg = nArray[n2];
                bgStyles.add(Messages.getString("display_bg_style_" + bg));
                ++n2;
            }
        }
        return bgStyles;
    }

    public static List<String> getGlStyles() {
        if (glStyles == null) {
            glStyles = new ArrayList<String>(GL_STYLES.length);
            int[] nArray = GL_STYLES;
            int n = GL_STYLES.length;
            int n2 = 0;
            while (n2 < n) {
                int gl = nArray[n2];
                glStyles.add(Messages.getString("display_gl_style_" + gl));
                ++n2;
            }
        }
        return glStyles;
    }

    public Parameters3D() {
        this(0, 0);
    }

    public Parameters3D(int bg, int gl) {
        this.background = bg;
        this.guidelines = gl;
    }

    public Parameters3D clone() {
        return new Parameters3D(this.getBackground(), this.getGuidelines());
    }

    public int getBackground() {
        return this.background;
    }

    public void setBackground(int background) {
        this.background = background;
    }

    public int getGuidelines() {
        return this.guidelines;
    }

    public void setGuidelines(int guidelines) {
        this.guidelines = guidelines;
    }

    public static void setStyle(int s) {
        style = s;
    }

    public static int getStyle() {
        return style;
    }

    public static void setAxes(int s) {
        axes = s;
    }

    public static int getAxes() {
        return axes;
    }
}

