/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Transform;
import javafx.stage.Stage;
import lib3d4j.compute.tools.Envelope3D;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.data.Coordinates;
import lib3d4j.data.DatasetParams;
import lib3d4j.data.DescriptionData;
import lib3d4j.data.Options;
import lib3d4j.data.Source;
import lib3d4j.display3D.Display;
import lib3d4j.display3D.java3D.CentralAction;
import lib3d4j.display3D.java3D.CentralActionObserver;
import lib3d4j.display3D.java3D.CentralSelection;
import lib3d4j.display3D.java3D.CentralSelectionObserver;
import lib3d4j.display3D.java3D.DisplayAction;
import lib3d4j.display3D.java3D.ShowHidePictureDisplayAction;
import lib3d4j.display3D.java3D.data.Parameters3D;
import lib3d4j.display3D.java3D.tools.LocalCoord;
import lib3d4j.display3D.javafx.JFXSwingUtils;
import lib3d4j.display3D.javafx.SceneJFX;
import lib3d4j.display3D.javafx.SceneJFXController;
import lib3d4j.display3D.javafx.XForm;
import lib3d4j.display3D.javafx.objects.RichObjectJFX;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.w2d.ImageDisplayer;
import lib3d4j.w2d.Stage3D;

public class DisplayJFX
implements Display,
CentralSelectionObserver,
CentralActionObserver {
    protected float objectSize;
    protected Parameters3D p3d;
    protected RichObjectJFX[] primArray = null;
    protected ArrayList<XForm> surroundingObjects = new ArrayList();
    protected CentralSelection cs;
    private DatasetParams param;
    protected DescriptionData data;
    private Options opt;
    private ArrayList<ImageDisplayer> imagesDisp;
    private Map<Integer, XForm> images = new HashMap<Integer, XForm>();
    private ArrayList<Boolean> visibiliteClasse;
    private CentralAction ca;
    protected SceneJFX jp3d;
    private ArrayList<XForm> otherObjects;
    private XForm lesAxes;
    protected LocalCoord loccoord;
    protected float[][] lc;
    protected RichPrimitiveFactoryJFX pf = RichPrimitiveFactoryJFX.getFactory();
    protected ArrayList<XForm> allObjects = new ArrayList();
    protected Stage3D stage3d;
    protected SceneJFXController controller;
    private boolean allLabelsVisible;

    public DisplayJFX() {
    }

    public DisplayJFX(Coordinates d3d, DescriptionData descr, Options opt) {
        this(d3d, descr, opt, true, 10.0f, true, new Parameters3D());
    }

    public DisplayJFX(Coordinates d3d, DescriptionData descr, Options opt, boolean scale, float size, boolean inFrame, Parameters3D aspect) {
        this.objectSize = size;
        this.p3d = aspect;
        this.init(descr.getParams(), opt, descr);
        this.jp3d = new SceneJFX(this, opt.isStereo());
        this.createScene(d3d, true);
        this.stage3d = new Stage3D(this.jp3d, "Tests");
        this.stage3d.show();
        this.cs.setObjectList(this.primArray.length);
        this.controller = new SceneJFXController(this, this.jp3d);
        this.initialRotation();
    }

    @Override
    public int surroundGroup(int index, int form) {
        if (form != 1 && form != 0) {
            return -1;
        }
        LinkedList<float[]> points = new LinkedList<float[]>();
        ArrayList<Integer> realpoints = new ArrayList<Integer>();
        int i = 0;
        while (i < this.lc.length) {
            int ri = i;
            if (index == this.data.getColorIndice(ri)) {
                points.add(this.lc[i]);
                realpoints.add(i);
            }
            ++i;
        }
        if (points.size() == 0) {
            return -1;
        }
        System.out.println(points.size());
        XForm fake = new XForm();
        this.surroundingObjects.add(fake);
        int resIndex = this.surroundingObjects.indexOf((Object)fake);
        Platform.runLater(() -> {
            float[][] f = new float[points.size()][3];
            points.toArray((T[])f);
            int allIdx = 0;
            if (form == 0) {
                float[] center = OutilsAlgebre.barycenter(f);
                float[][] axes = OutilsAlgebre.mainAxes(f);
                float dim1 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[0]);
                float dim2 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[1]);
                float dim3 = OutilsAlgebre.meanDistancePlusVarianceSqrtToCenterAlongAxes(f, axes[2]);
                allIdx = this.addEllipsoid(center, axes, dim1, dim2, dim3, (Material)this.pf.getTranslucentAppearance(index));
            } else if (form == 1) {
                Envelope3D env3d = new Envelope3D(f);
                int[][] envelope = env3d.getConvexEnvelope();
                int i = 0;
                while (i < envelope.length) {
                    envelope[i][0] = (Integer)realpoints.get(envelope[i][0]);
                    envelope[i][1] = (Integer)realpoints.get(envelope[i][1]);
                    envelope[i][2] = (Integer)realpoints.get(envelope[i][2]);
                    ++i;
                }
                allIdx = this.addPolyedron(envelope, index);
            }
            XForm xf = this.allObjects.set(allIdx, null);
            this.surroundingObjects.set(resIndex, xf);
        });
        return resIndex;
    }

    @Override
    public void desurround(int index) {
        if (index != -1 && index < this.surroundingObjects.size() && this.surroundingObjects.get(index) != null) {
            Platform.runLater(() -> this.jp3d.removeObject(this.surroundingObjects.set(index, null)));
        }
    }

    @Override
    public void desuroundAll() {
        int i = 0;
        while (i < this.surroundingObjects.size()) {
            this.desurround(i);
            ++i;
        }
    }

    @Override
    public void setGroupColor(int index, Color col) {
        this.pf.setAppearance(index, col);
    }

    @Override
    public void setGroupVisible(int index, boolean visible) {
        int i = this.visibiliteClasse.size();
        while (index >= this.visibiliteClasse.size()) {
            this.visibiliteClasse.add(i, true);
            ++i;
        }
        this.visibiliteClasse.set(index, visible);
        Platform.runLater(() -> {
            int i = 0;
            while (i < this.primArray.length) {
                if (this.getGroupIndices()[i] == index) {
                    this.setObjectVisible(i, visible);
                }
                ++i;
            }
        });
    }

    @Override
    public void setAllVisible(boolean visible) {
    }

    @Override
    public boolean isGroupVisible(int index) {
        return false;
    }

    @Override
    public boolean isInVisibleGroup(int objIndex) {
        return false;
    }

    @Override
    public void clicLeft(Object n) {
    }

    @Override
    public void clicRight(Object n) {
    }

    @Override
    public void clicRight(Object n, int x, int y) {
    }

    @Override
    public void clicCentral(Object n) {
    }

    @Override
    public void altClicLeft(Object n) {
    }

    @Override
    public void altClicRight(Object n) {
    }

    @Override
    public void altClicCentral(Object n) {
    }

    @Override
    public void shiftClicLeft(Object n) {
        int index = this.indexPrimArray(n);
        if (index == -1) {
            return;
        }
        this.setSelected(index, !this.primArray[index].isSelected());
    }

    @Override
    public void shiftClicRight(Object n) {
    }

    @Override
    public void shiftClicCentral(Object n) {
    }

    @Override
    public void controlClicLeft(Object n) {
    }

    @Override
    public void controlClicRight(Object n) {
    }

    @Override
    public void controlClicCentral(Object n) {
    }

    @Override
    public void collision(Object n, boolean in) {
    }

    @Override
    public void beginFlatSelection() {
        this.controller.switchToRectangle();
        this.jp3d.setFlatSelOn(true);
    }

    @Override
    public void ulFlatSelection() {
    }

    @Override
    public void selectZone(int x0, int y0, int x1, int y1, boolean finish) {
        if (!finish) {
            this.jp3d.drawSelectRectangle(x0, y0, x1, y1);
        } else {
            int yMax;
            int xMax;
            int xMin = xMax = (int)(this.stage3d.getX() + this.stage3d.getScene().getX());
            int yMin = yMax = (int)(this.stage3d.getY() + this.stage3d.getScene().getY());
            if (x0 < x1) {
                xMin += x0;
                xMax += x1;
            } else {
                xMin += x1;
                xMax += x0;
            }
            if (y0 < y1) {
                yMin += y0;
                yMax += y1;
            } else {
                yMin += y1;
                yMax += y0;
            }
            int index = 0;
            while (index < this.primArray.length) {
                RichObjectJFX ro = this.primArray[index];
                Point2D xy = ro.getPrimitive().localToScreen(0.0, 0.0);
                if (xy.getX() >= (double)xMin && xy.getX() <= (double)xMax && xy.getY() >= (double)yMin && xy.getY() <= (double)yMax) {
                    this.setSelected(index, true);
                }
                ++index;
            }
            this.controller.switchToStandard();
            this.jp3d.setFlatSelOn(false);
        }
    }

    @Override
    public void selectZoneCircular(int xcenter, int ycenter, int diameter) {
    }

    @Override
    public void onMouseOver(Object n) {
    }

    @Override
    public void onMouseOut(Object n) {
    }

    @Override
    public void setVisible(boolean isVisible) {
    }

    @Override
    public void remove() {
    }

    @Override
    public int getWidth() {
        return (int)this.jp3d.getScene().getWidth();
    }

    @Override
    public int getHeight() {
        return (int)this.jp3d.getScene().getHeight();
    }

    @Override
    public Image getScreenCapture() {
        return null;
    }

    @Override
    public Dimension2D getSize() {
        return null;
    }

    @Override
    public Point2D getLocationOnScreen() {
        return null;
    }

    @Override
    public void resetData(Coordinates d3d, DescriptionData dd, boolean scale) {
    }

    @Override
    public int addCone(float[] center, float scale) {
        return 0;
    }

    @Override
    public int addCone(float[] center, float[] direction, float scale) {
        return 0;
    }

    @Override
    public int addBox(float x, float y, float z, float mx, float my, float mz, int color, boolean resizable) {
        return 0;
    }

    @Override
    public int addBox(float x, float y, float z, float mx, float my, float mz) {
        return 0;
    }

    @Override
    public int addCube(float[] centre, float scale) {
        return 0;
    }

    @Override
    public int addCube(float[] centre, float scale, int color) {
        return 0;
    }

    @Override
    public void setCubeColors(int nbcol) {
    }

    @Override
    public int addPolyedron(int[][] sides, int color) {
        PhongMaterial appPoly = this.pf.getTranslucentAppearance(color);
        float[][][] sidef = new float[sides.length][3][3];
        int s = 0;
        while (s < sides.length) {
            sidef[s][0] = this.lc[sides[s][0]];
            sidef[s][1] = this.lc[sides[s][1]];
            sidef[s][2] = this.lc[sides[s][2]];
            ++s;
        }
        XForm poly = this.jp3d.addPolyedron(sidef, (Material)appPoly);
        return this.addToList(this.allObjects, poly);
    }

    @Override
    public int addCylinder(float[] center, float scale) {
        float[] lcCenter = this.loccoord.getLocCoord(center);
        XForm cyl = this.jp3d.addCylinder(lcCenter, scale);
        return this.addToList(this.allObjects, cyl);
    }

    @Override
    public int addEllipsoid(float[] center, float[] length, float[] width) {
        return -1;
    }

    public int addEllipsoid(float[] center, float[] length, float[] width, float[] depth) {
        return -1;
    }

    public int addEllipsoid(float[] center, float[] length, float[] width, float[] depth, int colorIndex) {
        return -1;
    }

    protected int addEllipsoid(float[] center, float[] length, float[] width, float[] depth, Material app) {
        XForm ell = this.jp3d.addEllipse(center, length, width, depth, app);
        return this.addToList(this.allObjects, ell);
    }

    public int addEllipsoid(float[] center, float[][] axes, float length, float width, float depth, Material mat) {
        XForm ell = this.jp3d.addEllipse(center, axes, length, width, depth, mat);
        return this.addToList(this.allObjects, ell);
    }

    @Override
    public int addSphere(float[] center, float scale) {
        XForm trans = new XForm();
        trans.setTranslate(center[0], center[1], center[2]);
        XForm sph = this.jp3d.addSphere(trans, scale, Color.BLACK);
        return this.addToList(this.allObjects, sph);
    }

    @Override
    public int addText(float[] start, String text) {
        int rank = this.addToList(this.allObjects, new XForm());
        Platform.runLater(() -> {
            XForm txt = this.jp3d.addText(this.loccoord.getLocCoord(start), text);
            this.allObjects.set(rank, txt);
        });
        return rank;
    }

    @Override
    public int addLine(float[] from, float[] to) {
        int index = this.addToList(this.allObjects, new XForm());
        Platform.runLater(() -> {
            XForm line = this.jp3d.addVertex(this.loccoord.getLocCoord(from), this.loccoord.getLocCoord(to));
            this.allObjects.set(index, line);
        });
        return index;
    }

    @Override
    public int addTriangle(int v1, int v2, int v3) {
        return 0;
    }

    @Override
    public void removeCubes() {
    }

    @Override
    public void setLabel(int index, String text) {
        this.primArray[index].setText(text);
    }

    @Override
    public boolean isLabelsVisible() {
        return this.allLabelsVisible;
    }

    @Override
    public void setLabelsVisible(boolean visible) {
        RichObjectJFX prim;
        int n;
        int n2;
        RichObjectJFX[] richObjectJFXArray;
        this.allLabelsVisible = visible;
        if (!visible) {
            richObjectJFXArray = this.primArray;
            n2 = this.primArray.length;
            n = 0;
            while (n < n2) {
                prim = richObjectJFXArray[n];
                if (prim.isTextAvailable()) {
                    prim.setText(null);
                }
                ++n;
            }
        } else {
            int index = 0;
            while (index < this.primArray.length) {
                if (!this.primArray[index].isTextAvailable()) {
                    this.primArray[index].setText(this.computeLabel(index));
                }
                ++index;
            }
        }
        richObjectJFXArray = this.primArray;
        n2 = this.primArray.length;
        n = 0;
        while (n < n2) {
            prim = richObjectJFXArray[n];
            prim.setLabelVisible(visible);
            ++n;
        }
    }

    protected String computeLabel(int index) {
        String label = (String)this.data.getLabelValue(index);
        if (label == null) {
            label = Integer.toString(index);
        }
        return label;
    }

    @Override
    public void switchLabel(int index) {
        this.setLabelVisible(index, !this.primArray[index].isLabelVisible());
    }

    @Override
    public void setLabelVisible(int index, boolean visible) {
        RichObjectJFX prim = this.primArray[index];
        if (!visible) {
            if (prim.isTextAvailable()) {
                prim.setText(null);
            }
        } else if (!prim.isTextAvailable()) {
            prim.setText(this.computeLabel(index));
        }
        prim.setLabelVisible(visible);
    }

    @Override
    public void switchLabels(boolean all) {
        if (all) {
            int index = 0;
            while (index < this.primArray.length) {
                this.switchLabel(index);
                ++index;
            }
        } else {
            boolean one = false;
            RichObjectJFX[] richObjectJFXArray = this.primArray;
            int n = this.primArray.length;
            int n2 = 0;
            while (n2 < n) {
                RichObjectJFX ro = richObjectJFXArray[n2];
                one |= ro.isSelected() && !ro.isLabelVisible();
                ++n2;
            }
            if (one) {
                int index = 0;
                while (index < this.primArray.length) {
                    if (this.primArray[index].isSelected() && !this.primArray[index].isLabelVisible()) {
                        this.setLabelVisible(index, true);
                    }
                    ++index;
                }
            } else {
                int index = 0;
                while (index < this.primArray.length) {
                    if (this.primArray[index].isSelected()) {
                        this.setLabelVisible(index, false);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void removeObject(int index) {
        if (index != -1) {
            XForm obj = this.allObjects.set(index, null);
            Platform.runLater(() -> this.jp3d.removeObject(obj));
        }
    }

    @Override
    public void setBrightness(int index, float value) {
    }

    @Override
    public void setSelected(int index, boolean sel) {
        if (this.primArray[index].isSelected() != sel) {
            this.objectSelected(index, sel);
            this.selectionStateChanged(index);
        }
    }

    @Override
    public void selectAll(boolean select) {
        int index = 0;
        while (index < this.primArray.length) {
            this.setSelected(index, select);
            ++index;
        }
    }

    @Override
    public boolean isSelected(int index) {
        return this.primArray[index].isSelected();
    }

    @Override
    public int countSelected() {
        return 0;
    }

    @Override
    public int[] getSelectedObjects() {
        return null;
    }

    @Override
    public void showHidePicture(int index) {
        if (index != -1) {
            this.ca.broadcast(this, new ShowHidePictureDisplayAction(index));
            this.showHidePictureLocal(index);
        }
    }

    @Override
    public void showHidePictureLocal(int index) {
        try {
            if (!this.primArray[index].asAssocData()) {
                if (this.data.isPictureAttrGiven()) {
                    String imgFile = (String)this.data.getAssocDataValue(index);
                    if (this.opt.isStandAloneFigures()) {
                        ImageDisplayer.getImageDisplayer().addImage(imgFile, this.param.getInImagePath(imgFile), index);
                        this.primArray[index].setAssocData(index);
                    } else {
                        Image img = new Image(this.param.getInImagePath(imgFile).toString());
                        XForm trans = new XForm();
                        Transform t = this.primArray[index].getPrimitive().getLocalToSceneTransform();
                        trans.setTx(t.getTx());
                        trans.setTy(t.getTy());
                        trans.setTz(t.getTz());
                        XForm xfImg = this.jp3d.addImage(trans, img);
                        this.images.put(index, xfImg);
                        this.primArray[index].setAssocData(true);
                    }
                } else {
                    this.setLabel(index, "" + index);
                }
            } else if (this.opt.isStandAloneFigures()) {
                ImageDisplayer.getImageDisplayer().removeImage(index, this.param.getInImagePath((String)this.data.getAssocDataValue(index)));
                this.primArray[index].setAssocData(null);
            } else {
                XForm img = this.images.remove(index);
                this.jp3d.removeObject(img);
                this.primArray[index].setAssocData(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setObjectColor(int index, Color color) {
        Node f = (Node)this.allObjects.get(index).getChildren().get(0);
        while (!(f instanceof Shape3D)) {
            f = (Node)((XForm)f).getChildren().get(0);
        }
        ((Shape3D)f).setMaterial((Material)this.pf.getAppearance(color));
    }

    @Override
    public void setObjectColor(int objectindex, int colorindex) {
        RichObjectJFX ro = this.primArray[objectindex];
        PhongMaterial mat = this.pf.getAppearance(colorindex, ro.isSelected());
        ro.getPrimitive().setMaterial((Material)mat);
    }

    @Override
    public void setObjectColor(int index, float value) {
        this.primArray[index].getPrimitive().setMaterial((Material)this.pf.getAppearance(value));
    }

    @Override
    public void setObjectsColor(int[] objects, int[] colors) {
        int i = 0;
        while (i < objects.length) {
            this.setObjectColor(objects[i], colors[i]);
            ++i;
        }
    }

    @Override
    public void setObjectVisible(int index, boolean visible) {
        this.primArray[index].setVisible(visible);
    }

    @Override
    public void setAllObjectsVisible(boolean allVisible) {
    }

    @Override
    public void setObjectSize(float size) {
        this.objectSize = size;
    }

    @Override
    public float getObjectSize() {
        return this.objectSize;
    }

    @Override
    public float getDefaultSize() {
        return 0.0f;
    }

    @Override
    public void setDefaultSize(float defaultSize) {
    }

    @Override
    public void setAspect(Parameters3D p3d) {
        Color bgCol;
        this.p3d = p3d;
        switch (this.p3d.getBackground()) {
            case 2: {
                bgCol = Color.WHITE;
                break;
            }
            case 1: {
                bgCol = Color.LIGHTGRAY;
            }
            default: {
                bgCol = Color.DARKGRAY;
            }
        }
        this.jp3d.setBackground(bgCol);
    }

    @Override
    public Parameters3D getAspect() {
        return this.p3d;
    }

    @Override
    public void setColorTable(int card) {
    }

    @Override
    public void setColorTable(Color[] setOfColors) {
    }

    @Override
    public void setGradientColorTable(float min, float max) {
    }

    @Override
    public void setLabelSize(float size) {
    }

    @Override
    public int getNbObjects() {
        return 0;
    }

    @Override
    public void setDefaultColor(Color c) {
    }

    @Override
    public void removePictures() {
    }

    @Override
    public float[][] getPoints() {
        return this.lc;
    }

    @Override
    public void centerObject(int obj) {
    }

    @Override
    public boolean isInGroup(int objectIndex, int groupIndex) {
        return false;
    }

    @Override
    public int[] getGroupIndices() {
        return this.data.getIndicesByRole(1);
    }

    @Override
    public void resetData(float[][] d3d, Source src, DatasetParams dsp, boolean scale) {
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public void setOptions(Options opt) {
    }

    @Override
    public void translateRelativeView(float x, float y, float z) {
    }

    @Override
    public void translateViewHome() {
    }

    @Override
    public void setRelativeAvatar(float x, float y, float z) {
    }

    @Override
    public void rotateRelativeView(float x, float y, float z) {
    }

    @Override
    public void createAvatar() {
    }

    @Override
    public LocalCoord getLocalCoord() {
        return this.loccoord;
    }

    protected void createScene(Coordinates dat3D, boolean scale) {
        this.setBackground();
        this.setAxes();
        this.loccoord = scale ? new LocalCoord(dat3D.tab3D, this.param.getNormalize(), this.param.getCentre()) : new LocalCoord();
        this.lc = this.loccoord.getLocCoord(dat3D.tab3D);
        this.primArray = new RichObjectJFX[dat3D.size()];
        int i = 0;
        while (i < dat3D.size()) {
            XForm trans = new XForm();
            trans.setTranslate(this.lc[i][0], -this.lc[i][1], -this.lc[i][2]);
            int form = this.param.getFormCol() == -1 || this.data.getNbAtt() <= this.param.getFormCol() ? 3 : this.data.getFormIndice(i);
            int color = this.param.getColorCol() == -1 || this.data.getNbAtt() <= this.param.getColorCol() ? -1 : this.data.getColorIndice(i);
            this.primArray[i] = new RichObjectJFX(this.addPrimitive(trans, form, color, this.objectSize));
            ++i;
        }
    }

    protected void init(DatasetParams param, Options opt, DescriptionData data) {
        this.param = param;
        this.data = data;
        this.opt = opt;
        this.imagesDisp = new ArrayList();
        this.visibiliteClasse = new ArrayList();
        this.otherObjects = new ArrayList();
        this.setDefaultColor(JFXSwingUtils.toJFXColor(opt.getDefaultColor()));
        ImageDisplayer.getImageDisplayer().setSelectCallback(this);
        this.cs = CentralSelection.getSingleton();
        this.cs.reference(this);
        this.ca = CentralAction.getCentralAction();
        this.ca.reference(this);
    }

    protected void setAxes() {
        if (this.lesAxes != null) {
            this.jp3d.removeObject(this.lesAxes);
        }
        this.lesAxes = this.jp3d.setAxis(this.p3d.getGuidelines(), this.p3d.getBackground());
    }

    protected void setBackground() {
    }

    protected void initialRotation() {
    }

    protected XForm addPrimitive(XForm trans, int form, int color, float scale) {
        PhongMaterial app = color != -1 ? this.pf.getAppearance(color, false) : this.pf.getDefaultAppearance(false);
        return this.addPrimitive(trans, form, (Material)app, scale);
    }

    protected XForm addPrimitive(XForm trans, int form, Material app, float scale) {
        switch (form) {
            case 3: {
                return this.jp3d.addSphere(trans, scale, app, true, true);
            }
            case 1: {
                return this.jp3d.addBox(trans, scale, app, true, true);
            }
            case 2: {
                return this.jp3d.addCylinder(trans, scale, app, true, true);
            }
            case 0: {
                return this.jp3d.addCone(trans, scale, app, true, true);
            }
        }
        return null;
    }

    protected Material transpApp(int color) {
        PhongMaterial tApp = new PhongMaterial();
        if (this.pf == null) {
            if (Parameters3D.getStyle() == 1) {
                tApp.setDiffuseColor(new Color((double)0.3f, (double)0.3f, (double)0.3f, (double)0.1f));
            } else {
                tApp.setDiffuseColor(new Color((double)0.3f, (double)0.3f, (double)0.3f, (double)0.1f));
            }
        } else {
            Color col = this.pf.getTabColor()[color];
            tApp.setDiffuseColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), (double)0.1f));
        }
        return tApp;
    }

    protected int addToList(ArrayList<XForm> l, XForm b) {
        l.add(b);
        return l.indexOf((Object)b);
    }

    protected void removeFromList(ArrayList<XForm> l, int index) {
        if (index != -1) {
            this.jp3d.removeObject(l.set(index, null));
        }
    }

    protected void clearList(ArrayList<XForm> l) {
        for (XForm bg : l) {
            this.jp3d.removeObject(bg);
        }
        l.clear();
    }

    protected void objectSelected(int index, boolean isSelected) {
        PhongMaterial app;
        this.primArray[index].setSelected(isSelected);
        if (this.param.getColorCol() == -1 || this.data.getNbAtt() <= this.param.getColorCol()) {
            app = this.pf.getAppearance((PhongMaterial)this.primArray[index].getPrimitive().getMaterial(), isSelected);
        } else {
            int color = this.data.getColorIndice(index);
            app = this.pf.getAppearance(color, isSelected);
        }
        this.primArray[index].getPrimitive().setMaterial((Material)app);
    }

    public int indexPrimArray(Object p) {
        int i = 0;
        while (i < this.primArray.length) {
            if (p == this.primArray[i].getPrimitive()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void onAction(DisplayAction da) {
    }

    @Override
    public void selectionStateChanged(int index) {
        this.cs.flipState(index, this);
    }

    @Override
    public void onSelectionChange() {
    }

    @Override
    public void setXYWH(int x, int y, int width, int height) {
        Platform.runLater(() -> {
            this.stage3d.setX(x);
            this.stage3d.setY(y);
            this.stage3d.setWidth(width);
            this.stage3d.setHeight(height);
        });
    }

    public Stage getStage() {
        return this.stage3d;
    }
}

