/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx;

import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class JFXSwingUtils {
    public static java.awt.Color toAwtColor(Color jfxCol) {
        return new java.awt.Color((float)jfxCol.getRed(), (float)jfxCol.getGreen(), (float)jfxCol.getBlue(), (float)jfxCol.getOpacity());
    }

    public static java.awt.Color[] toAwtColors(Color[] jfxCols) {
        int nbc = jfxCols.length;
        java.awt.Color[] awtCols = new java.awt.Color[nbc];
        int i = 0;
        while (i < nbc) {
            awtCols[i] = JFXSwingUtils.toAwtColor(jfxCols[i]);
            ++i;
        }
        return awtCols;
    }

    public static Color toJFXColor(java.awt.Color awtCol) {
        return new Color((double)((float)awtCol.getRed() / 255.0f), (double)((float)awtCol.getGreen() / 255.0f), (double)((float)awtCol.getBlue() / 255.0f), (double)((float)awtCol.getAlpha() / 255.0f));
    }

    public static Color[] toJFXColors(java.awt.Color[] awtCols) {
        int nbc = awtCols.length;
        Color[] jfxCols = new Color[nbc];
        int i = 0;
        while (i < nbc) {
            jfxCols[i] = JFXSwingUtils.toJFXColor(awtCols[i]);
            ++i;
        }
        return jfxCols;
    }

    public static BufferedImage toAwtImage(Image jfxImg) {
        return SwingFXUtils.fromFXImage((Image)jfxImg, null);
    }

    public static BufferedImage[] toAwtImages(Image[] jfxImgs) {
        int nbc = jfxImgs.length;
        BufferedImage[] awtImgs = new BufferedImage[nbc];
        int i = 0;
        while (i < nbc) {
            awtImgs[i] = JFXSwingUtils.toAwtImage(jfxImgs[i]);
            ++i;
        }
        return awtImgs;
    }
}

