/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Sphere;
import javafx.scene.text.Text;
import lib3d4j.display3D.javafx.XForm;

public class AxesJFX {
    private static final double AXIS_LENGTH = 250.0;
    private static final double AXIS_WIDTH = 1.0;

    public static XForm createAxes(int style, int axes) {
        XForm bg = null;
        switch (axes) {
            case 0: {
                bg = AxesJFX.lesAxes(style);
                break;
            }
            case 1: {
                bg = AxesJFX.leCube(style);
                break;
            }
            case 2: {
                bg = AxesJFX.scolor(style);
                break;
            }
            case 3: {
                bg = AxesJFX.xlstats(style);
                break;
            }
            case 4: {
                bg = AxesJFX.lesSpheres(style);
            }
        }
        return bg;
    }

    public static XForm leCube(int style) {
        XForm cubeGroup = new XForm();
        return cubeGroup;
    }

    public static XForm lesSpheres(int style) {
        XForm sphereGroup = new XForm();
        return sphereGroup;
    }

    public static XForm scolor(int style) {
        XForm axisGroup = new XForm();
        return axisGroup;
    }

    public static XForm lesAxes(int style) {
        float scale = 1.0f;
        XForm axisGroup = new XForm();
        PhongMaterial posMaterial = new PhongMaterial();
        PhongMaterial negMaterial = new PhongMaterial();
        if (style == 0) {
            posMaterial.setDiffuseColor(Color.DARKGRAY);
            posMaterial.setSpecularColor(Color.WHITE);
            negMaterial.setDiffuseColor(Color.DARKGRAY);
            negMaterial.setSpecularColor(Color.LIGHTGRAY);
        } else {
            posMaterial.setDiffuseColor(Color.DARKGRAY);
            posMaterial.setSpecularColor(Color.BLACK);
            negMaterial.setDiffuseColor(Color.DARKGRAY);
            negMaterial.setSpecularColor(Color.DARKGRAY);
        }
        Box xAxisPos = new Box(250.0, 1.0, 1.0);
        XForm xAPT = new XForm();
        xAPT.setTranslateX(125.0);
        xAPT.getChildren().add((Object)xAxisPos);
        Box yAxisPos = new Box(1.0, 250.0, 1.0);
        XForm yAPT = new XForm();
        yAPT.setTranslateY(-125.0);
        yAPT.getChildren().add((Object)yAxisPos);
        Box zAxisPos = new Box(1.0, 1.0, 250.0);
        XForm zAPT = new XForm();
        zAPT.setTranslateZ(-125.0);
        zAPT.getChildren().add((Object)zAxisPos);
        xAxisPos.setMaterial((Material)posMaterial);
        yAxisPos.setMaterial((Material)posMaterial);
        zAxisPos.setMaterial((Material)posMaterial);
        Box xAxisNeg = new Box(250.0, 1.0, 1.0);
        XForm xANT = new XForm();
        xANT.setTranslateX(-125.0);
        xANT.getChildren().add((Object)xAxisNeg);
        Box yAxisNeg = new Box(1.0, 250.0, 1.0);
        XForm yANT = new XForm();
        yANT.setTranslateY(125.0);
        yANT.getChildren().add((Object)yAxisNeg);
        Box zAxisNeg = new Box(1.0, 1.0, 250.0);
        XForm zANT = new XForm();
        zANT.setTranslateZ(125.0);
        zANT.getChildren().add((Object)zAxisNeg);
        xAxisNeg.setMaterial((Material)negMaterial);
        yAxisNeg.setMaterial((Material)negMaterial);
        zAxisNeg.setMaterial((Material)negMaterial);
        axisGroup.getChildren().addAll((Object[])new Node[]{xAPT, yAPT, zAPT, xANT, yANT, zANT});
        Sphere spherex = new Sphere((double)(0.005f / scale));
        spherex.setMaterial((Material)posMaterial);
        spherex.setTranslateX(250.0);
        Sphere spherey = new Sphere((double)(0.005f / scale));
        spherey.setMaterial((Material)posMaterial);
        spherey.setTranslateY(-250.0);
        Sphere spherez = new Sphere((double)(0.005f / scale));
        spherez.setMaterial((Material)posMaterial);
        spherez.setTranslateZ(-250.0);
        axisGroup.getChildren().addAll((Object[])new Node[]{spherex, spherey, spherez});
        Text tX = new Text("X1");
        XForm labelX = new XForm();
        labelX.setTranslateX(255.0);
        labelX.getChildren().add((Object)tX);
        Text tY = new Text("X2");
        XForm labelY = new XForm();
        labelY.setTranslateY(-255.0);
        labelY.getChildren().add((Object)tY);
        Text tZ = new Text("X3");
        XForm labelZ = new XForm();
        labelZ.setTranslateZ(-255.0);
        labelZ.getChildren().add((Object)tZ);
        axisGroup.getChildren().addAll((Object[])new Node[]{labelX, labelY, labelZ});
        return axisGroup;
    }

    public static XForm xlstats(int style) {
        XForm xlsGroup = new XForm();
        return xlsGroup;
    }
}

