/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public abstract class AxisShape
extends MeshView {
    private Point2D[] profile;
    private int divisions;

    public AxisShape() {
    }

    public AxisShape(Point2D[] points, int divisions) {
        this.profile = points;
        this.divisions = divisions;
        this.tracer();
    }

    protected void tracer() {
        this.createCoords();
        PhongMaterial mat = new PhongMaterial();
        mat.setDiffuseColor(Color.BLACK);
        mat.setSpecularColor(Color.WHITE);
        this.setMaterial((Material)mat);
    }

    protected void createCoords() {
        int nbp = this.profile.length;
        if (this.profile[0].getX() != 0.0 || this.profile[nbp - 1].getX() != 0.0) {
            throw new IllegalArgumentException("First and last point x must be 0");
        }
        float[] coords = new float[nbp * this.divisions * 3];
        int i = 0;
        while (i < this.divisions) {
            int j = 0;
            while (j < nbp) {
                double angle = Math.PI * 2 * (double)i / (double)this.divisions;
                coords[i * nbp * 3 + 3 * j] = (float)(this.profile[j].getX() * Math.cos(angle));
                coords[i * nbp * 3 + 3 * j + 1] = (float)this.profile[j].getY();
                coords[i * nbp * 3 + 3 * j + 2] = (float)(this.profile[j].getX() * Math.sin(angle));
                ++j;
            }
            ++i;
        }
        float[] texCoords = new float[nbp * (this.divisions + 1) * 2];
        int i2 = 0;
        while (i2 <= this.divisions) {
            int j = 0;
            while (j < nbp) {
                texCoords[i2 * nbp * 2 + 2 * j] = (float)i2 / (float)this.divisions;
                texCoords[i2 * nbp * 2 + 2 * j + 1] = (float)j / (float)(nbp - 1);
                ++j;
            }
            ++i2;
        }
        int[] faces = new int[(nbp - 1) * this.divisions * 12];
        int nbf = 0;
        int i3 = 0;
        while (i3 < this.divisions) {
            int left = i3 * nbp;
            int pRight = (i3 + 1) % this.divisions * nbp;
            int tRight = (i3 + 1) * nbp;
            int j = 0;
            while (j < nbp - 1) {
                int top = j;
                int bottom = j + 1;
                faces[nbf++] = left + top;
                faces[nbf++] = left + top;
                faces[nbf++] = left + bottom;
                faces[nbf++] = left + bottom;
                faces[nbf++] = pRight + bottom;
                faces[nbf++] = tRight + bottom;
                faces[nbf++] = left + top;
                faces[nbf++] = left + top;
                faces[nbf++] = pRight + bottom;
                faces[nbf++] = tRight + bottom;
                faces[nbf++] = pRight + top;
                faces[nbf++] = tRight + top;
                ++j;
            }
            ++i3;
        }
        TriangleMesh tm = new TriangleMesh();
        tm.getPoints().addAll(coords);
        tm.getTexCoords().addAll(texCoords);
        tm.getFaces().addAll(faces);
        this.setMesh((Mesh)tm);
    }
}

