/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public class Polyedron
extends MeshView {
    public Polyedron(float[][][] tab) {
        int nbsides = tab.length;
        float[] coords = new float[9 * nbsides];
        int shift = 0;
        int side = 0;
        while (side < nbsides) {
            int vertex = 0;
            while (vertex < 3) {
                coords[shift + 3 * vertex] = tab[side][vertex][0];
                coords[shift + 3 * vertex + 1] = -tab[side][vertex][1];
                coords[shift + 3 * vertex + 2] = -tab[side][vertex][2];
                ++vertex;
            }
            shift += 9;
            ++side;
        }
        float[] texCoords = new float[]{0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 0.0f};
        int[] faces = new int[12 * nbsides];
        int nbf = 0;
        int side2 = 0;
        while (side2 < nbsides) {
            faces[nbf++] = 3 * side2;
            faces[nbf++] = 0;
            faces[nbf++] = 3 * side2 + 1;
            faces[nbf++] = 2;
            faces[nbf++] = 3 * side2 + 2;
            faces[nbf++] = 1;
            ++side2;
        }
        side2 = 0;
        while (side2 < nbsides) {
            faces[nbf++] = 3 * side2 + 1;
            faces[nbf++] = 0;
            faces[nbf++] = 3 * side2;
            faces[nbf++] = 2;
            faces[nbf++] = 3 * side2 + 2;
            faces[nbf++] = 1;
            ++side2;
        }
        TriangleMesh tm = new TriangleMesh();
        tm.getPoints().addAll(coords);
        tm.getTexCoords().addAll(texCoords);
        tm.getFaces().addAll(faces);
        this.setMesh((Mesh)tm);
    }
}

