/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.display3D.javafx.objects;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import lib3d4j.display3D.javafx.XForm;

public class Target
extends XForm {
    public Target(Color color, double radius, double length) {
        double thickness = length / 2.5;
        double offset = radius + length / 2.0;
        PhongMaterial mat = new PhongMaterial(color);
        XForm north = this.createSegment(thickness, length, thickness, (Material)mat);
        north.setTranslateY(-offset);
        XForm south = this.createSegment(thickness, length, thickness, (Material)mat);
        south.setTranslateY(offset);
        XForm east = this.createSegment(length, thickness, thickness, (Material)mat);
        east.setTranslateX(offset);
        XForm west = this.createSegment(length, thickness, thickness, (Material)mat);
        west.setTranslateX(-offset);
        XForm back = this.createSegment(thickness, thickness, length, (Material)mat);
        back.setTranslateZ(offset);
        XForm front = this.createSegment(thickness, thickness, length, (Material)mat);
        front.setTranslateZ(-offset);
        this.getChildren().addAll((Object[])new Node[]{north, east, west, south, back, front});
    }

    private XForm createSegment(double x, double y, double z, Material mat) {
        XForm segment = new XForm();
        Box b = new Box(x, y, z);
        b.setMaterial(mat);
        segment.getChildren().add((Object)b);
        return segment;
    }
}

