/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import lib3d4j.w2d.ImagePanel;

public class InnerPanel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Image image;
    private ImagePanel parent;

    public InnerPanel(Image img, int w, int h, ImagePanel p) {
        this.parent = p;
        this.image = img == null ? Toolkit.getDefaultToolkit().createImage(new BufferedImage(w, h, 1).getSource()) : img;
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        if ((float)width / (float)w > (float)height / (float)h) {
            height = (int)((float)height / (float)width * (float)w);
            width = w;
        } else {
            width = (int)((float)width / (float)height * (float)h);
            height = h;
        }
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setIcon(new ImageIcon(this.image.getScaledInstance(width, height, 2)));
    }

    public InnerPanel(Image img, int w, int h, String title, ImagePanel p) {
        this(img, w, h, p);
        this.setToolTipText(title);
        this.addMouseListener(new PopupListener(this));
    }

    public void drag(boolean b) {
        this.parent.drag(b);
    }

    private class PopupListener
    implements MouseListener {
        private InnerPanel parent = null;

        public PopupListener(InnerPanel ip) {
            this.parent = ip;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isShiftDown()) {
                this.parent.drag(true);
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

