/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javafx.scene.paint.Color;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lib3d4j.display3D.javafx.objects.RichPrimitiveFactoryJFX;
import lib3d4j.international.Messages;
import lib3d4j.w2d.JPanelLegend;

public class JPanelContinuousLegend
extends JPanelLegend {
    private static final long serialVersionUID = 1L;
    protected Dimension size = new Dimension(200, 60);
    protected GradientPanel gradP;
    protected java.awt.Color cMin;
    protected java.awt.Color cMax;
    protected JLabel jlMin;
    protected JLabel jlMax;
    protected JLabel jlUnit;
    JDialog jdialog = null;

    public JPanelContinuousLegend(float[] values, String unit) {
        this.setPreferredSize(this.size);
        this.setSize(this.size);
        this.setLayout(new GridLayout(0, 1));
        this.jlUnit = new JLabel(unit, 0);
        this.add(this.jlUnit);
        this.gradP = new GradientPanel();
        this.add(this.gradP);
        JPanel minmax = new JPanel();
        minmax.setLayout(new BorderLayout());
        this.jlMin = new JLabel("");
        minmax.add((Component)this.jlMin, "West");
        this.jlMax = new JLabel("");
        minmax.add((Component)this.jlMax, "East");
        this.add(minmax);
        this.reset(values, unit);
    }

    public void reset(float[] values, String unit) {
        float min;
        if (values == null || values.length == 0) {
            return;
        }
        float max = min = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            } else if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        this.reset(min, max, RichPrimitiveFactoryJFX.getFactory().getMinColor(), RichPrimitiveFactoryJFX.getFactory().getMaxColor(), unit);
    }

    private void reset(float min, float max, Color colorMin, Color colorMax, String unit) {
        this.reset(min, max, new java.awt.Color((float)colorMin.getRed(), (float)colorMin.getGreen(), (float)colorMin.getBlue()), new java.awt.Color((float)colorMax.getRed(), (float)colorMax.getGreen(), (float)colorMax.getBlue()), unit);
    }

    private void reset(float min, float max, java.awt.Color colorMin, java.awt.Color colorMax, String unit) {
        this.cMin = colorMin;
        this.cMax = colorMax;
        this.jlUnit.setText(unit);
        this.jlMin.setText("" + min);
        this.jlMax.setText("" + max);
        this.repaint();
    }

    public void reset(float min, float max, String unit) {
        this.reset(min, max, RichPrimitiveFactoryJFX.getFactory().getMinColor(), RichPrimitiveFactoryJFX.getFactory().getMaxColor(), unit);
    }

    @Override
    public JFrame createDialog() {
        return super.createDialog(Messages.getString("gradient_title"));
    }

    public JDialog getJdialog() {
        return this.jdialog;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.size.width = this.getWidth();
        this.size.height = this.getHeight();
        this.gradP.repaint();
        super.paintComponent(g);
    }

    class GradientPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        GradientPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setSize(new Dimension(JPanelContinuousLegend.this.size.width, JPanelContinuousLegend.this.size.height / 3));
            System.out.println("grdp");
            BufferedImage gradient = new BufferedImage(JPanelContinuousLegend.this.size.width, JPanelContinuousLegend.this.size.height / 3, 1);
            Graphics2D g2d = (Graphics2D)((Image)gradient).getGraphics();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, JPanelContinuousLegend.this.cMin, JPanelContinuousLegend.this.size.width, 0.0f, JPanelContinuousLegend.this.cMax, false));
            g2d.fillRect(0, 0, JPanelContinuousLegend.this.size.width, JPanelContinuousLegend.this.size.height / 3);
            g.drawImage(gradient, 0, 0, this);
        }
    }
}

