/*
 * Decompiled with CFR 0.152.
 */
package lib3d4j.w2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lib3d4j.international.Messages;

public class TextureChooser
extends JDialog {
    private int value = -1;

    public TextureChooser(BufferedImage[] img, ImageIcon currImg) {
        this.setModal(true);
        this.setTitle(Messages.getString("texturechooser_title"));
        this.setLayout(new BorderLayout());
        JPanel jpCurrent = new JPanel();
        jpCurrent.setLayout(new FlowLayout());
        jpCurrent.add(new JLabel(Messages.getString("texturechooser_current")));
        jpCurrent.add(new IndexedJLabel(currImg, -1));
        this.add((Component)jpCurrent, "North");
        JPanel jpTextures = new JPanel();
        jpTextures.setLayout(new FlowLayout());
        TCMouseAdapter ml = new TCMouseAdapter();
        int i = 0;
        while (i < img.length) {
            IndexedJLabel jl = new IndexedJLabel(new ImageIcon(img[i]), i);
            jl.addMouseListener(ml);
            jpTextures.add(jl);
            ++i;
        }
        this.add((Component)jpTextures, "Center");
        JButton jbCancel = new JButton(Messages.getString("cancel"));
        jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextureChooser.this.setVisible(false);
            }
        });
        this.add((Component)jbCancel, "South");
        this.pack();
    }

    public int getValue() {
        return this.value;
    }

    public static int showDialog(BufferedImage[] img, ImageIcon currImg) {
        TextureChooser tc = new TextureChooser(img, currImg);
        tc.setVisible(true);
        return tc.getValue();
    }

    private class IndexedJLabel
    extends JLabel {
        private int index;

        public IndexedJLabel(ImageIcon ii, int n) {
            super(ii);
            this.index = n;
            this.setPreferredSize(new Dimension(30, 30));
        }
    }

    private class TCMouseAdapter
    extends MouseAdapter {
        private TCMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexedJLabel src = (IndexedJLabel)e.getSource();
            TextureChooser.this.value = src.index;
            TextureChooser.this.setVisible(false);
        }
    }
}

