/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.plaf.TaskPaneUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    protected JTaskPane taskPane;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTaskPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.taskPane = (JTaskPane)c;
        this.taskPane.setLayout(new PercentLayout(1, 14));
        this.taskPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.taskPane.setOpaque(true);
        if (this.taskPane.getBackground() == null || this.taskPane.getBackground() instanceof ColorUIResource) {
            this.taskPane.setBackground(UIManager.getColor("TaskPane.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPane.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPane.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPane.backgroundGradientEnd");
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.useGradient) {
            Paint old = g2d.getPaint();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, c.getHeight(), this.gradientEnd);
            g2d.setPaint(gradient);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2d.setPaint(old);
        }
    }
}

