/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javafx.geometry.Dimension2D;
import javax.swing.JWindow;
import lib3d4j.display3D.Display;
import lib3d4j.display3D.javafx.JFXSwingUtils;
import lib3d4j.w2d.InnerPanel;

public class Lens
extends JWindow {
    public static final int DEFAULT_DIAMETER = 100;
    public static final int DEFAULT_COEFFICIENT = 2;
    private boolean active = false;
    BufferedImage img = null;
    private int diameter = 100;
    private int coeff = 2;
    private int opacity = 0;
    Display panel = null;
    private BufferedImage screenshot = null;
    Cursor transparentCursor = null;
    Cursor standardCursor = null;
    private int topleftX = 0;
    private int topleftY = 0;
    private int bottomrightX;
    private int bottomrightY;
    private static Lens singleton = new Lens();

    public static Lens getSingleton() {
        return singleton;
    }

    public Lens() {
        this.CreateCursors();
        this.setSize(this.diameter, this.diameter);
        MyMouseAdapter mma = new MyMouseAdapter();
        this.addMouseListener(mma);
        this.addMouseMotionListener(mma);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
        this.setSize(diameter, diameter);
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setCoeff(int coeff) {
        this.coeff = coeff;
        if (this.isVisible()) {
            this.drawLens();
        }
    }

    public int getCoeff() {
        return this.coeff;
    }

    @Override
    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public void start(Display disp, int globalX, int globalY) {
        this.active = true;
        this.panel = disp;
        this.screenshot = JFXSwingUtils.toAwtImage(this.panel.getScreenCapture());
        Point ulP = new Point((int)this.panel.getLocationOnScreen().getX(), (int)this.panel.getLocationOnScreen().getY());
        this.topleftX = ulP.x;
        this.topleftY = ulP.y;
        Dimension2D dfx = this.panel.getSize();
        Dimension d = new Dimension((int)dfx.getWidth(), (int)dfx.getHeight());
        this.bottomrightX = d.width;
        this.bottomrightY = d.height;
        this.drawLens(globalX, globalY);
        this.setCursor(this.transparentCursor);
        this.setVisible(true);
    }

    public void stop() {
        this.setCursor(this.standardCursor);
        this.setActive(false);
        this.setVisible(false);
    }

    private void CreateCursors() {
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.standardCursor = new Cursor(0);
    }

    private void drawLens() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.drawLens(p.x, p.y);
    }

    private void drawLens(int globalX, int globalY) {
        int innerX = globalX - this.topleftX;
        int innerY = globalY - this.topleftY;
        if (innerX - this.diameter / 2 < 0 || innerX + this.diameter / 2 > this.bottomrightX || innerY - this.diameter / 2 < 0 || innerY + this.diameter / 2 > this.bottomrightY) {
            if (innerX - this.diameter / 2 < 0) {
                innerX = this.diameter / 2;
            } else if (innerX + this.diameter / 2 > this.bottomrightX) {
                innerX = this.bottomrightX - this.diameter / 2;
            }
            if (innerY - this.diameter / 2 < 0) {
                innerY = this.diameter / 2;
            } else if (innerY + this.diameter / 2 > this.bottomrightY) {
                innerY = this.bottomrightY - this.diameter / 2;
            }
            globalX = innerX + this.topleftX;
            globalY = innerY + this.topleftY;
            try {
                Robot r = new Robot();
                r.mouseMove(globalX, globalY);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        this.setLocation(globalX - this.diameter / 2, globalY - this.diameter / 2);
        BufferedImage img2 = this.screenshot.getSubimage(innerX - this.diameter / (2 * this.coeff), innerY - this.diameter / (2 * this.coeff), this.diameter / this.coeff, this.diameter / this.coeff);
        BufferedImage img3 = new BufferedImage(this.diameter, this.diameter, img2.getType());
        Graphics2D g = (Graphics2D)img3.getGraphics();
        g.drawImage(img2, 0, 0, this.diameter, this.diameter, null);
        g.setColor(Color.WHITE);
        g.setStroke(new BasicStroke(3.0f));
        g.draw(new Ellipse2D.Float(1.0f, 1.0f, this.diameter - 2, this.diameter - 2));
        g.setColor(Color.GRAY);
        g.draw(new Ellipse2D.Float(3.0f, 3.0f, this.diameter - 6, this.diameter - 6));
        InnerPanel ip = new InnerPanel(img3, this.diameter, this.diameter, null);
        this.getContentPane().removeAll();
        this.getContentPane().add(ip);
        this.pack();
        this.panel.selectZoneCircular(innerX, innerY, this.diameter);
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Lens.this.stop();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int coordX = e.getXOnScreen();
            int coordY = e.getYOnScreen();
            Lens.this.drawLens(coordX, coordY);
        }
    }
}

