/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.compute.compute.Decoupe;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMLDA;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class InterTauxTest {
    private static boolean contient(Vector<String> LC, String s) {
        int i = 0;
        while (i < LC.size() && !LC.elementAt(i).equals(s)) {
            ++i;
        }
        return i < LC.size();
    }

    private static String contrainteC2inf(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int iMin = -1;
        int jMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        String s = "Comp | 1 : " + i + " - " + j + " < " + y;
                        if (y < x && !InterTauxTest.contient(LC, s) && y > 0.1f && (x / y > min || min == -1.0f)) {
                            iMin = i;
                            jMin = j;
                            min = x / y;
                            ymin = y;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("Comp | 1 : " + iMin + " - " + jMin + " < " + ymin);
        return "Comp | 1 : " + iMin + " - " + jMin + " < " + ymin;
    }

    private static String contrainteC2sup(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int iMin = -1;
        int jMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        String s = "Comp | 1 : " + i + " - " + j + " > " + y;
                        if (x < y && !InterTauxTest.contient(LC, s) && y / x > min || min == -1.0f) {
                            iMin = i;
                            jMin = j;
                            min = y / x;
                            ymin = y;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("Comp | 1 : " + iMin + " - " + jMin + " > " + ymin);
        return "Comp | 1 : " + iMin + " - " + jMin + " > " + ymin;
    }

    private static String contrainteC3inf(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int aMin = -1;
        int bMin = -1;
        int cMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int a = 0;
        while (a < n) {
            if (lda.estActif(a)) {
                int b = 0;
                while (b < n) {
                    if (a != b && lda.estActif(b)) {
                        float Dab = acp.distanceND(a, b, nbDims);
                        float y = lda.distanceND(a, b, nbDims);
                        int c = 0;
                        while (c < n) {
                            if (a != c && b != c && lda.estActif(c) && lda.classe(a) == lda.classe(c) && lda.classe(a) != lda.classe(b)) {
                                float Dac = acp.distanceND(a, c, nbDims);
                                float y1 = lda.distanceND(a, c, nbDims);
                                String s = "An | 1 : " + a + " - " + b + " - " + c + " < " + 0.5;
                                if (Dab < Dac && !InterTauxTest.contient(LC, s) && Dac / Dab > min || min == -1.0f) {
                                    aMin = a;
                                    bMin = b;
                                    cMin = c;
                                    min = Dac / Dab;
                                    ymin = y1 / y;
                                }
                            }
                            ++c;
                        }
                    }
                    ++b;
                }
            }
            ++a;
        }
        System.out.println("An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + ymin);
        return "An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + 0.5;
    }

    public static void testclassic(int nbelem, SourceAttrVal dt, int[] classe, String output, String nameFic, int nbDims) {
        int nbgroupes = 3;
        int nbBoucles = 5;
        int maxConstr = 50;
        int nbConstr = 0;
        int knn = 1;
        int verbose = 1;
        int[] axes = new int[3];
        int i = 0;
        while (i < 3) {
            axes[i] = i;
            ++i;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PrintStream psout = new PrintStream(fos);
        Conditioning c = ConditioningFactory.createConditioning(2, true);
        PMLDA lda = PMFactory.getSingleton().createPMLDA(dt, c);
        int nbO = lda.getNbObjets();
        int[] crossb = new int[nbO];
        c = ConditioningFactory.createConditioning(2, true);
        PMPCA acp = PMFactory.getSingleton().createPMPCA(dt, c);
        CentralResult resultats = new CentralResult();
        int nbboucles = 0;
        while (nbboucles < nbBoucles) {
            int[] cross = Decoupe.nFold(classe, nbgroupes);
            int nbg = 0;
            while (nbg < nbgroupes) {
                System.out.println("Run n\u00b0 " + nbboucles + "." + nbg);
                int i2 = 0;
                while (i2 < nbO) {
                    crossb[i2] = cross[i2] == nbg ? nbg + 1 : nbg;
                    ++i2;
                }
                lda.setCrossValidation(crossb, nbg);
                lda.calculer();
                lda.creerProjection();
                lda.creerProjection3D(axes);
                lda.test(crossb, nbg, false, knn, nbDims);
                resultats.addResult("lda", "Taux", lda.getTauxCorrect(2));
                acp.setCrossValidation(crossb, nbg);
                acp.calculer();
                acp.creerProjection();
                acp.creerProjection3D(axes);
                acp.test(crossb, nbg, false, knn, nbDims);
                resultats.addResult("acp(0)", "Taux", acp.getTauxCorrect(2));
                Vector<String> LC = new Vector<String>();
                while (nbConstr < maxConstr) {
                    LC.add(InterTauxTest.contrainteC2inf(acp, lda, LC, nbDims));
                    acp.reinit();
                    acp.modificationProjection(axes, LC);
                    acp.creerProjection();
                    acp.test(crossb, nbg, false, knn, nbDims);
                    resultats.addResult("acp(" + ++nbConstr + ")", "Taux", acp.getTauxCorrect(2));
                    float x = acp.getVarianceInter(2);
                    float y = acp.getVarianceIntra(2);
                    resultats.addResult("acp(" + nbConstr + ")", "Inter", 100.0f * x / (x + y));
                    resultats.addResult("acp(" + nbConstr + ")", "Intra", 100.0f * y / (x + y));
                    System.out.println();
                }
                ++nbg;
            }
            ++nbboucles;
        }
        ResultDisplay resdisplay = new ResultDisplay(resultats, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficherln("Source : " + nameFic, psout, verbose);
        resdisplay.afficherln("knn=" + knn, psout, verbose);
        resdisplay.afficherln("nbgroupes=" + nbgroupes, psout, verbose);
        resdisplay.afficherln("nbBoucles=" + nbBoucles, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficheMethodeType("lda", "Taux");
        int i3 = 0;
        while (i3 < maxConstr) {
            resdisplay.afficheMoyenne("acp(" + i3 + ")", "Taux");
            ++i3;
        }
        System.out.println("");
        i3 = 0;
        while (i3 < maxConstr) {
            resdisplay.afficheMoyenne("acp(" + i3 + ")", "Inter");
            ++i3;
        }
        System.out.println("");
        i3 = 0;
        while (i3 < maxConstr) {
            resdisplay.afficheMoyenne("acp(" + i3 + ")", "Intra");
            ++i3;
        }
        System.out.println("");
        psout.close();
    }
}

