/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch;

import explorer.batch.CentralResult;
import explorer.batch.StockageUnit;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class ResultDisplay {
    private PrintStream psout;
    private int verbose;
    private CentralResult resultats;

    public static void affiche(CentralResult res) {
        int i = 0;
        while (i < res.getResult().size()) {
            res.getResult().elementAt(i).affiche();
            ++i;
        }
    }

    public ResultDisplay(CentralResult res, PrintStream _psout, int _verbose) {
        this.resultats = res;
        this.psout = _psout;
        this.verbose = _verbose;
    }

    public void afficheMethode(String nomMethode) {
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getNomMethod().equals(nomMethode)) {
                this.resultats.getResult().elementAt(i).affiche(this.psout, this.verbose);
            }
            ++i;
        }
    }

    public void afficheType(String typeResult) {
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getTypeResult().equals(typeResult)) {
                this.resultats.getResult().elementAt(i).affiche(this.psout, this.verbose);
            }
            ++i;
        }
    }

    public void afficheMethodeType(String _nomMethod, String _typeResult) {
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getNomMethod().equals(_nomMethod) && this.resultats.getResult().elementAt(i).getTypeResult().equals(_typeResult)) {
                this.resultats.getResult().elementAt(i).affiche(this.psout, this.verbose);
            }
            ++i;
        }
    }

    public void afficheTout() {
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            this.resultats.getResult().elementAt(i).affiche(this.psout, this.verbose);
            ++i;
        }
    }

    public void afficheMoyenne(String _nomMethod, String _typeResult) {
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getNomMethod().equals(_nomMethod) && this.resultats.getResult().elementAt(i).getTypeResult().equals(_typeResult)) {
                this.resultats.getResult().elementAt(i).afficheMoyenne(this.psout, this.verbose);
            }
            ++i;
        }
    }

    public void afficheColumns() {
        if (this.resultats.getListeCols().size() == 0) {
            return;
        }
        int nblines = this.resultats.getListeCols().get(0).size();
        this.psout.print("line ");
        for (StockageUnit su : this.resultats.getListeCols()) {
            su.afficheType(this.psout);
        }
        this.psout.println();
        int line = 0;
        while (line < nblines) {
            this.psout.print(String.valueOf(line) + " ");
            for (StockageUnit su : this.resultats.getListeCols()) {
                su.afficheElem(this.psout, line);
            }
            this.psout.println();
            ++line;
        }
    }

    public String formatFloat(float f) {
        DecimalFormat df = new DecimalFormat("##0.0000");
        String s = df.format(f);
        String esp = "   ";
        int i = 8 - s.length();
        return esp.subSequence(0, i) + s;
    }

    public void printFloat(float f, PrintStream psout, int verbose) {
        this.afficher(String.valueOf(this.formatFloat(f)) + " ", psout, verbose);
    }

    public void afficher(String s, PrintStream psout, int verbose) {
        if (verbose == 1) {
            System.out.print(s);
        }
        psout.print(s);
    }

    public void afficherln(String s, PrintStream psout, int verbose) {
        if (verbose == 1) {
            System.out.println(s);
        }
        psout.println(s);
    }

    public void afficherln(PrintStream psout, int verbose) {
        if (verbose == 1) {
            System.out.println();
        }
        psout.println();
    }

    public float getMoyenne(String _nomMethod, String _typeResult) {
        float res = 0.0f;
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getNomMethod().equals(_nomMethod) && this.resultats.getResult().elementAt(i).getTypeResult().equals(_typeResult)) {
                res = this.resultats.getResult().elementAt(i).getMoyenne();
            }
            ++i;
        }
        return res;
    }

    public float getEcartType(String _nomMethod, String _typeResult) {
        float res = 0.0f;
        int i = 0;
        while (i < this.resultats.getResult().size()) {
            if (this.resultats.getResult().elementAt(i).getNomMethod().equals(_nomMethod) && this.resultats.getResult().elementAt(i).getTypeResult().equals(_typeResult)) {
                res = this.resultats.getResult().elementAt(i).getEcartType();
            }
            ++i;
        }
        return res;
    }
}

