/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Vector;

public class StockageUnit
implements Serializable {
    public static int notSpecified = -1;
    public static int entiers = 0;
    public static int reels = 1;
    public static int tabReels = 2;
    private int dataType = notSpecified;
    private String nomMethod;
    private String typeResult;
    private Vector<Integer> intValues;
    private Vector<Float> floatValues;
    private Vector<Float[]> tabFloatValues;

    public StockageUnit(String nom, String typ) {
        this.nomMethod = nom;
        this.typeResult = typ;
    }

    public String getNomComplet() {
        return String.valueOf(this.nomMethod) + " - " + this.typeResult;
    }

    public String getNomMethod() {
        return this.nomMethod;
    }

    public String getTypeResult() {
        return this.typeResult;
    }

    public int getValEntier(int i) {
        if (this.dataType == entiers) {
            return this.intValues.elementAt(i);
        }
        return 0;
    }

    public Float getValReel(int i) {
        if (this.dataType == reels) {
            return this.floatValues.elementAt(i);
        }
        return null;
    }

    public int getDataType() {
        return this.dataType;
    }

    public Float[] getValTabReel(int i) {
        if (this.dataType == tabReels) {
            return this.tabFloatValues.elementAt(i);
        }
        return null;
    }

    public void addresult(int val) {
        if (this.dataType == notSpecified) {
            this.dataType = entiers;
            this.intValues = new Vector();
        } else if (this.dataType != entiers) {
            System.out.println("Incoh\u00e9rence de type dans l'unit\u00e9 de stockage" + this.getNomComplet());
        }
        this.intValues.addElement(val);
    }

    public void addresult(float val) {
        if (this.dataType == notSpecified) {
            this.dataType = reels;
            this.floatValues = new Vector();
        } else if (this.dataType != reels) {
            System.out.println("Incoh\u00e9rence de type dans l'unit\u00e9 de stockage" + this.getNomComplet());
        }
        this.floatValues.addElement(Float.valueOf(val));
    }

    public void addresult(float[] val) {
        if (this.dataType == notSpecified) {
            this.dataType = tabReels;
            this.tabFloatValues = new Vector();
        } else if (this.dataType != tabReels) {
            System.out.println("Incoh\u00e9rence de type dans l'unit\u00e9 de stockage" + this.getNomComplet());
        }
        Float[] tab = new Float[val.length];
        int i = 0;
        while (i < val.length) {
            tab[i] = new Float(val[i]);
            ++i;
        }
        this.tabFloatValues.addElement(tab);
    }

    public void addresult(Float[] val) {
        if (this.dataType == notSpecified) {
            this.dataType = tabReels;
            this.tabFloatValues = new Vector();
        } else if (this.dataType != tabReels) {
            System.out.println("Incoh\u00e9rence de type dans l'unit\u00e9 de stockage" + this.getNomComplet());
        }
        Float[] tab = new Float[val.length];
        int i = 0;
        while (i < val.length) {
            tab[i] = new Float(val[i].floatValue());
            ++i;
        }
        this.tabFloatValues.addElement(tab);
    }

    public void afficheType(PrintStream psout) {
        this.afficher(String.valueOf(this.getTypeResult()) + " ", psout, 0);
    }

    public void afficheElem(PrintStream psout, int line) {
        if (this.dataType == entiers) {
            this.afficher(this.intValues.elementAt(line) + " ", psout, 0);
        } else if (this.dataType == reels) {
            this.afficher(String.valueOf(this.formatFloat(this.floatValues.elementAt(line).floatValue(), false)) + " ", psout, 0);
        }
    }

    public void affiche(PrintStream psout, int verbose) {
        int som = 0;
        float somf = 0.0f;
        this.afficher(String.valueOf(this.getNomComplet()) + "   ", psout, verbose);
        if (this.dataType == entiers) {
            int i = 0;
            while (i < this.intValues.size()) {
                this.afficherln(this.intValues.elementAt(i) + " ", psout, verbose);
                som += this.intValues.elementAt(i).intValue();
                ++i;
            }
            somf = som;
            this.afficherln(" -> Moyenne : " + this.formatFloat(somf / (float)this.intValues.size(), true) + "  +/- " + this.formatFloat(this.getEcartType(), true), psout, verbose);
        } else if (this.dataType == reels) {
            int i = 0;
            while (i < this.floatValues.size()) {
                this.afficherln(String.valueOf(i) + " " + this.formatFloat(this.floatValues.elementAt(i).floatValue(), true) + " ", psout, verbose);
                somf += this.floatValues.elementAt(i).floatValue();
                ++i;
            }
            this.afficherln(" -> Moyenne : " + this.formatFloat(somf / (float)this.floatValues.size(), true) + "  +/- " + this.formatFloat(this.getEcartType(), true), psout, verbose);
        }
    }

    public void affiche() {
        int som = 0;
        float somf = 0.0f;
        System.out.println(String.valueOf(this.getNomComplet()) + "   ");
        if (this.dataType == entiers) {
            int i = 0;
            while (i < this.intValues.size()) {
                System.out.println(this.intValues.elementAt(i) + " ");
                som += this.intValues.elementAt(i).intValue();
                ++i;
            }
            somf = som;
            System.out.println(" -> Moyenne : " + this.formatFloat(somf / (float)this.intValues.size(), true) + "  +/- " + this.formatFloat(this.getEcartType(), true));
        } else if (this.dataType == reels) {
            int i = 0;
            while (i < this.floatValues.size()) {
                System.out.println(String.valueOf(i) + " " + this.formatFloat(this.floatValues.elementAt(i).floatValue(), true) + " ");
                somf += this.floatValues.elementAt(i).floatValue();
                ++i;
            }
            System.out.println(" -> Moyenne : " + this.formatFloat(somf / (float)this.floatValues.size(), true) + "  +/- " + this.formatFloat(this.getEcartType(), true));
        }
    }

    public void afficheMoyenne(PrintStream psout, int verbose) {
        int som = 0;
        float somf = 0.0f;
        if (this.dataType == entiers) {
            int i = 0;
            while (i < this.intValues.size()) {
                som += this.intValues.elementAt(i).intValue();
                ++i;
            }
            somf = som;
            this.printFloat(somf / (float)this.intValues.size(), psout, verbose);
        } else if (this.dataType == reels) {
            int i = 0;
            while (i < this.floatValues.size()) {
                somf += this.floatValues.elementAt(i).floatValue();
                ++i;
            }
            this.printFloat(somf / (float)this.floatValues.size(), psout, verbose);
        }
    }

    public int size() {
        if (this.dataType == entiers) {
            return this.intValues.size();
        }
        if (this.dataType == reels) {
            return this.floatValues.size();
        }
        if (this.dataType == tabReels) {
            return this.tabFloatValues.size();
        }
        return 0;
    }

    public float getMoyenne() {
        int som = 0;
        float somf = 0.0f;
        if (this.dataType == entiers) {
            int i = 0;
            while (i < this.intValues.size()) {
                som += this.intValues.elementAt(i).intValue();
                ++i;
            }
            somf = som;
            somf /= (float)this.intValues.size();
        } else if (this.dataType == reels) {
            int i = 0;
            while (i < this.floatValues.size()) {
                somf += this.floatValues.elementAt(i).floatValue();
                ++i;
            }
            somf /= (float)this.floatValues.size();
        }
        return somf;
    }

    public float getEcartType() {
        int som = 0;
        float somf = 0.0f;
        if (this.dataType == entiers) {
            int i = 0;
            while (i < this.intValues.size()) {
                som += this.intValues.elementAt(i).intValue();
                ++i;
            }
            somf = som;
            float moy = somf / (float)this.intValues.size();
            somf = 0.0f;
            i = 0;
            while (i < this.intValues.size()) {
                somf += (moy - (float)this.intValues.elementAt(i).intValue()) * (moy - (float)this.intValues.elementAt(i).intValue());
                ++i;
            }
            double somd = somf / (float)this.intValues.size();
            somf = (float)Math.sqrt(somd);
            return somf;
        }
        if (this.dataType == reels) {
            int i = 0;
            while (i < this.floatValues.size()) {
                somf += this.floatValues.elementAt(i).floatValue();
                ++i;
            }
            float moy = somf / (float)this.floatValues.size();
            somf = 0.0f;
            i = 0;
            while (i < this.floatValues.size()) {
                somf += (moy - this.floatValues.elementAt(i).floatValue()) * (moy - this.floatValues.elementAt(i).floatValue());
                ++i;
            }
            double somd = somf / (float)this.floatValues.size();
            somf = (float)Math.sqrt(somd);
        }
        return somf;
    }

    private String formatFloat(float f, boolean align) {
        int offset = 16;
        DecimalFormat df = new DecimalFormat("##0.0000");
        String s = df.format(f);
        if (align) {
            String esp = "           ";
            int i = offset - s.length();
            s = esp.subSequence(0, i) + s;
        }
        return s;
    }

    private void printFloat(float f, PrintStream psout, int verbose) {
        this.afficher(String.valueOf(this.formatFloat(f, true)) + " ", psout, verbose);
    }

    private void afficher(String s, PrintStream psout, int verbose) {
        if (verbose == 1) {
            System.out.print(s);
        }
        psout.print(s);
    }

    private void afficherln(String s, PrintStream psout, int verbose) {
        if (verbose == 1) {
            System.out.println(s);
        }
        psout.println(s);
    }
}

